<%--
  - FILE
  -   ulnChannelsHome.jsp
  -
  - DESCRIPTION
  -   Page showing ULN Channels information.
  -
  - MODIFIED  (MM/DD/YY)
  -   tasingh  09/02/04 - created
  -
  - SINCE
  -   10.2.0.4
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%--To display the Timestamp--%>
<uix:buildTree nodeID="timestamp" scope="request">
  <%@ include file="timestamp.jspf" %>
</uix:buildTree>

<%--All page contents should be within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">

  <uix:tableLayout>
    <uix:rowLayout>
      <uix:styledText
        textBinding="ULN_CHANNELS_HOME_PAGE_INST_TEXT@hostPatchResourceBundle"
        styleClass="OraInstructionText"/>
    </uix:rowLayout>
  </uix:tableLayout>

  <uix:spacer height="10"/>
    
  <%--
    - This table uses partial renderring mode. So id attribute is must. Also
    - partial renderring requires "/enablePPR.jspf" to be included, which is
    - inculded in the template.jspf
  --%>
  <uix:table
    width="80%"
    name="ulnChannelsTable"
    id="ulnChannelsTableID"
    summaryBinding="ULN_CHANNELS_TABLE_SUMMARY@hostPatchResourceBundle"
    partialRenderMode="self"
    formSubmitted="true"
    alternateTextBinding="MSG_NO_CHANNEL_FOUND@hostPatchResourceBundle"
    tableDataBinding="rows@ulnChannelsHomeBean@servletRequest"
    valueBinding="currentValue@ulnChannelsHomeBean@servletRequest"
    minValueBinding="minValue@ulnChannelsHomeBean@servletRequest"
    blockSizeBinding="blockSize@ulnChannelsHomeBean@servletRequest"
    maxValueBinding="maxValue@ulnChannelsHomeBean@servletRequest"
    columnHeaderDataBinding="colHeaders@ulnChannelsHomeBean@servletRequest">

    <uix:tableFormat tableBanding="rowBanding"/>

    <uix:columnHeaderStamp>
      <uix:sortableHeader
        textBinding="text"
        sortableBinding="sortable">
      </uix:sortableHeader>
    </uix:columnHeaderStamp>

    <oem:license>
      <uix:styledText
        textBinding="channelName"
        destinationBinding="channelNameDest">
      </uix:styledText>
    </oem:license>

    <uix:styledText
      textBinding="stagingServer">
    </uix:styledText>

    <uix:styledText
      textBinding="directory">
    </uix:styledText>

    <uix:column>
      <uix:columnFormat
        cellNoWrapFormat="true"
        columnDataFormat="numberFormat"/>
      <uix:styledText
        textBinding="numPkgs">
      </uix:styledText>
    </uix:column>

    <uix:column>
      <uix:columnFormat
        cellNoWrapFormat="true"
        columnDataFormat="numberFormat"/>
      <uix:styledText
        textBinding="numCfgFiles">
      </uix:styledText>
    </uix:column>

    <uix:column>
      <uix:columnFormat
        cellNoWrapFormat="true"
        columnDataFormat="numberFormat"/>
      <uix:styledText
        textBinding="numGroups">
      </uix:styledText>
    </uix:column>

  </uix:table>
  <uix:spacer height="5"/>

</uix:buildTree>

<%@ include file="template.jspf" %>
