<%--
  - FILE
  -   undoPatchingAction.jsp
  -
  - DESCRIPTION
  -   The Undo Patching - Action step of the wizard.
  -   Allows the user to choose one of the three options-
  -     * Uninstall Packages
  -     * Rollback Packages
  -     * Rollback Last Update Session
  -
  - MODIFIED  (MM/DD/YY)
  -   hmodawel 03/06/06 - fix compilation 
  -   tasingh  05/26/05 - tasingh_bug-4327813
  -   tasingh  09/02/04 - created
  -
  - SINCE
  -   10.2
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%--All page contents should be within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">

  <uix:dataScope currentDataBinding="pageData@servletRequest">

    <uix:stackLayout>
      <uix:styledText
        textBinding="UNDO_PATCHING_ACTION_TEXT@hostPatchResourceBundle"
        styleClass="OraInstructionText"/>

      <uix:spacer height="10"/>

      <uix:messageRadioGroup
        promptBinding="UNDO_PATCHING_ACTION_OPTIONS_TEXT@hostPatchResourceBundle"
        name="actionRdBtn"
        childDataBinding="actionsList@pageData@servletRequest"
        textBinding="actionText"
        valueBinding="actionValue"
        selectedValueBinding="actionSelVal@stepsData@servletRequest"
        type="radio">
      </uix:messageRadioGroup>
    </uix:stackLayout>

  </uix:dataScope>

</uix:buildTree>

<%@ include file="wizTemplate.jspf" %>
