<%--
  - FILE
  -   undoPatchingCreds.jsp
  -
  - DESCRIPTION
  -   The Undo Patching - Credentials step of the wizard.
  -
  - MODIFIED  (MM/DD/YY)
  -   tasingh  09/19/05 - Bug-4613497 Add noAutoComplete=true for username and 
  -                       password fields. 
  -   nbhandar 08/10/05 - Bug: 4498959 
  -   tasingh  07/13/05 - ADA Bugs 
  -   tasingh  06/15/05 - Use PPR to render dependent elements on change of 
  -                       dropdown list option 
  -   tasingh  05/26/05 - tasingh_bug-4327813
  -   tasingh  09/02/04 - created
  -
  - SINCE
  -   10.2
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%--All page contents should be within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">

  <uix:dataScope currentDataBinding="pageData@servletRequest">

    <uix:styledText
      textBinding="UNDO_PATCHING_CREDS_TEXT@hostPatchResourceBundle"
      styleClass="oraInstructionText"/>

    <uix:spacer height="10"/>

    <uix:tableLayout cellSpacing="4">
      <uix:rowLayout>
        <uix:cellFormat width="50%" columnSpan="2">
          <uix:rowLayout>
	    <uix:messageRadioButton
	      id="usePrefRdBtnID"
	      name="usePrefRdBtn"
	      shortDescBinding="USE_PREFERRED_CREDENTIALS@hostPatchResourceBundle"
	      selectedBinding="usePrefRdBtn@stepsData@servletRequest"
	      primaryClientActionBinding="onChangeUsePrefRdBtn@pageData@servletRequest"/>
	   <uix:messagePrompt promptBinding="USE_PREFERRED_CREDENTIALS@hostPatchResourceBundle"/>
          </uix:rowLayout>
        </uix:cellFormat>
        <uix:cellFormat width="50%"> 
          <uix:rowLayout>
	    <uix:messageRadioButton
	      id="overridePrefRdBtnID"
	      name="overridePrefRdBtn"
	      shortDescBinding="OVERRIDE_PREFERRED_CREDENTIALS@hostPatchResourceBundle"
	      selectedBinding="overridePrefRdBtn@stepsData@servletRequest"
	      primaryClientActionBinding="onChangeOverridePrefRdBtn@pageData@servletRequest"/>
	    <uix:messagePrompt promptBinding="OVERRIDE_PREFERRED_CREDENTIALS@hostPatchResourceBundle"/>
          </uix:rowLayout>
        </uix:cellFormat>
      </uix:rowLayout>
    </uix:tableLayout>

    <uix:tableLayout cellSpacing="4" id="overrideCredsID">
      <uix:rowLayout hAlign="right">
        <uix:cellFormat width="3%">
        </uix:cellFormat>

        <uix:cellFormat>
          <uix:switcher childNameBinding="isOverridePrefClkd@stepsData@servletRequest">
            <uix:case name="true">
              <uix:tableLayout cellSpacing="4">
                <uix:rowLayout>
                  <uix:messageChoice
                    name="hostOptionsList"
                    promptBinding="SPECIFY_CREDENTIALS_FOR@hostPatchResourceBundle"
                    shortDescBinding="SPECIFY_CREDENTIALS_FOR_SHORT_DESC@hostPatchResourceBundle"
                    selectedValueBinding="hostOptionSelVal@stepsData@servletRequest"
                    primaryClientActionBinding="onChangeHostOptionsList@pageData@servletRequest">
                    <uix:contents
                      childDataBinding="hostOptionsList@pageData@servletRequest">
                      <uix:option
                        textBinding="hostOption"
                        valueBinding="hostOptionVal"/>
                    </uix:contents>
                  </uix:messageChoice>
                </uix:rowLayout>

                <uix:rowLayout id="dependentID"> 
                  <uix:switcher 
                     childNameBinding="isEachHostSelected@stepsData@servletRequest"> 
                    <uix:case name="true">

                      <uix:table
                        width="100%"
                        name="setCred"
                        id="setCredID"
                        summaryBinding="OVERRIDE_PREFERRED_CREDENTIALS@hostPatchResourceBundle"
                        partialRenderMode="self"
                        formSubmitted="true"
                        tableDataBinding="setCred@stepsData@servletRequest"
                        columnHeaderDataBinding="setCredColHeader@stepsData@servletRequest"
                        valueBinding="setCredCurrValue@pageData@servletRequest"
                        minValueBinding="setCredMinValue@pageData@servletRequest"
                        blockSizeBinding="setCredBlockSize@pageData@servletRequest"
                        maxValueBinding="setCredMaxValue@pageData@servletRequest">

                        <uix:tableFormat tableBanding="rowBanding"/>
                        <uix:columnHeaderStamp>
                          <uix:sortableHeader
                            textBinding="text"
                            sortableBinding="sortable">
                          </uix:sortableHeader>
                        </uix:columnHeaderStamp>

                        <uix:styledText
                          textBinding="targetName"
                          shortDescBinding="SELECTED_TARGETS@hostPatchResourceBundle">
                        </uix:styledText>

                        <uix:messageTextInput
                          name="username"
                          textBinding="username"
                          shortDescBinding="USERNAME@hostPatchResourceBundle"
                          noAutoComplete="true"
                          columns="15"
                          maximumLength="255"
                          messageTypeBinding="usernameMsgType"
                          messageBinding="usernameMsg"/>

                        <uix:messageTextInput
                          name="password"
                          textBinding="password"
                          shortDescBinding="PASSWORD@hostPatchResourceBundle"
                          noAutoComplete="true"
                          columns="15"
                          maximumLength="255"
                          messageTypeBinding="passwordMsgType"
                          messageBinding="passwordMsg"
                          secret="true"/>

                        <uix:messageTextInput
                          name="cfmPassword"
                          textBinding="cfmPassword"
                          shortDescBinding="CFM_PASSWORD@hostPatchResourceBundle"
                          noAutoComplete="true"
                          columns="15"
                          maximumLength="255"
                          messageTypeBinding="cfmPasswordMsgType"
                          messageBinding="cfmPasswordMsg"
                          secret="true"/>

                      </uix:table>

                    </uix:case>
                    <uix:default>
                      <uix:tableLayout>
                        <uix:rowLayout hAlign="right">
                          <uix:messageTextInput columns="20"
                            name="username"
                            textBinding="username@stepsData@servletRequest"
                            promptBinding="USERNAME@hostPatchResourceBundle"
                            noAutoComplete="true"
                            maximumLength="255"
                            required="uiOnly"
                            messageTypeBinding="usernameMsgType@pageData@servletRequest"
                            messageBinding="usernameMsg@pageData@servletRequest"/>
                        </uix:rowLayout>
                        <uix:rowLayout hAlign="right">
                          <uix:messageTextInput columns="20"
                            name="password"
                            textBinding="password@stepsData@servletRequest"
                            promptBinding="PASSWORD@hostPatchResourceBundle"
                            noAutoComplete="true"
                            maximumLength="255"
                            secret="true"
                            required="uiOnly"
                            messageTypeBinding="passwordMsgType@pageData@servletRequest"
                            messageBinding="passwordMsg@pageData@servletRequest"/>
                        </uix:rowLayout>
                        <uix:rowLayout hAlign="right">
                          <uix:messageTextInput columns="20"
                            name="cfmPassword"
                            textBinding="cfmPassword@stepsData@servletRequest"
                            promptBinding="CFM_PASSWORD@hostPatchResourceBundle"
                            noAutoComplete="true"
                            maximumLength="255"
                            secret="true"
                            required="uiOnly"
                            messageTypeBinding="cfmPasswordMsgType@pageData@servletRequest"
                            messageBinding="cfmPasswordMsg@pageData@servletRequest"/>
                        </uix:rowLayout>
                      </uix:tableLayout>

                    </uix:default>
                  </uix:switcher>


                </uix:rowLayout>
              </uix:tableLayout>
            </uix:case>

            <uix:default>
              <uix:tableLayout>
                <uix:rowLayout>
                  <uix:messageChoice
                    name="prefHostCredType"
                    promptBinding="HOST_CREDENTIALS@hostPatchResourceBundle"
                    shortDescBinding="HOST_CREDENTIALS_TYPE@hostPatchResourceBundle"
                    selectedValueBinding="hostCredentialsTypeSelValue@stepsData@servletRequest">
                    <uix:contents
                      childDataBinding="prefHostCredTypeList@pageData@servletRequest">
                      <uix:option
                        textBinding="hostCredType"
                        valueBinding="hostCredTypeVal"/>
                    </uix:contents>
                  </uix:messageChoice>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:default>
          </uix:switcher>
        </uix:cellFormat>
      </uix:rowLayout>
    </uix:tableLayout>

  </uix:dataScope>

</uix:buildTree>

<%@ include file="wizTemplate.jspf" %>
