<%--
  - FILE
  -   undoPatchingHosts.jsp
  -
  - DESCRIPTION
  -   The Undo Patching - Hosts step of the wizard.
  -
  - MODIFIED  (MM/DD/YY)
  -   tasingh  07/13/05 - ADA Bugs 
  -   tasingh  06/20/05 - Add summary attribute 
  -   tasingh  05/26/05 - tasingh_bug-4327813
  -   tasingh  09/02/04 - created
  -
  - SINCE
  -   10.2
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%--All page contents should be within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">

    <uix:dataScope currentDataBinding="pageData@servletRequest">

      <uix:tableLayout>
        <uix:rowLayout>
          <uix:styledText
            textBinding="UNDO_PATCHING_SELECT_HOSTS_TEXT@hostPatchResourceBundle"
            styleClass="oraInstructionText"/>
        </uix:rowLayout>
      </uix:tableLayout>

      <uix:spacer height="10"/>

      <%--to display error message--%>
      <uix:inlineMessage
        messageTypeBinding="msgType@pageData@servletRequest"
        messageBinding="infoMsg@pageData@servletRequest">

        <%--the hGrid--%>
        <uix:hGrid
          id="hostHGrid"
          width="500"
          summaryBinding="HGRID_SEL_HOSTS_SUMMARY@hostPatchResourceBundle"
          partialRenderMode="self"
          alternateTextBinding="MSG_NO_HOSTS_FOUND@hostPatchResourceBundle"
          treeDataBinding="hGridData@pageData@servletRequest"
          proxyBinding="hGridProxy@pageData@servletRequest"
          formSubmitted="true">

          <uix:nodeStamp>
            <uix:column>
              <uix:columnHeader>
                <uix:styledText textBinding="NAME@commonResourceBundle"/>
              </uix:columnHeader>
              <uix:styledText textBinding="text"/>
            </uix:column>
          </uix:nodeStamp>

          <uix:tableSelection>
            <uix:multipleSelection
              shortDescBinding="SELECT@commonResourceBundle"
              selectedBinding="selected">
            </uix:multipleSelection>
          </uix:tableSelection>
        </uix:hGrid>

      </uix:inlineMessage>
    </uix:dataScope>

</uix:buildTree>

<%@ include file="wizTemplate.jspf" %>
