<%--
  - FILE
  -   undoPatchingPkgs.jsp
  -
  - DESCRIPTION
  -   The Undo Patching - Packages step of the wizard.
  -   It provides an interface to the user to select the
  -   packages that need to be uninstalled or rolled back.
  -
  - MODIFIED  (MM/DD/YY)
  -   tasingh  07/13/05 - ADA Bugs 
  -   tasingh  06/20/05 - Add summary attribute for table 
  -   tasingh  05/26/05 - tasingh_bug-4327813
  -   tasingh  09/02/04 - created
  -
  - SINCE
  -   10.2
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%--All page contents should be within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">

  <uix:dataScope currentDataBinding="pageData@servletRequest">

    <uix:switcher childNameBinding="actionSelVal@stepsData@servletRequest">
      <uix:case name="uninstallPkgs">

        <uix:stackLayout>
          <uix:styledText
            textBinding="UNDO_PATCHING_UNINSTALL_PKGS_TEXT@hostPatchResourceBundle"
            styleClass="oraInstructionText"/>

          <uix:spacer height="10"/>

          <%--to display error message--%>
          <uix:inlineMessage
            messageTypeBinding="msgType@pageData@servletRequest"
            messageBinding="infoMsg@pageData@servletRequest">

            <%--package selection shuttle--%>
            <uix:shuttle
              name="shuttlePkgSel"
              reorderable="false"
              leadingHeaderBinding="AVAILABLE_PACKAGES@hostPatchResourceBundle"
              trailingHeaderBinding="SELECTED_PACKAGES@hostPatchResourceBundle"
              size="10">

              <uix:leading>
                <uix:list
                  name="availPkgs"
                  multiple="true"
                  shortDescBinding="AVAILABLE_PACKAGES@hostPatchResourceBundle">
                  <uix:contents childDataBinding="availPkgs@stepsData@servletRequest">
                    <uix:option textBinding="pkgName"/>
                  </uix:contents>
                </uix:list>
              </uix:leading>

              <uix:trailing>
                <uix:list
                  name="selPkgs"
                  multiple="true"
                  shortDescBinding="SELECTED_PACKAGES@hostPatchResourceBundle">
                  <uix:contents childDataBinding="selPkgs@stepsData@servletRequest">
                    <uix:option textBinding="pkgName"/>
                  </uix:contents>
                </uix:list>
              </uix:trailing>
            </uix:shuttle>
          </uix:inlineMessage>

          <uix:spacer height="15"/>
          <uix:messageTextInput
            name="explicitlySpecifiedPkgs"
            maximumLength="255"
            columns="50"
            vAlign="center"
            tipBinding="COMMA_SEPARATED_TIP@hostPatchResourceBundle"
            messageTypeBinding="explicitPkgsMsgType@pageData@servletRequest"
            messageBinding="explicitPkgsInfoMsg@pageData@servletRequest"
            promptBinding="UNDO_PATCHING_EXPLICITLY_SPECIFY_PKGS@hostPatchResourceBundle"
            textBinding="explicitlySpecifiedPkgs@stepsData@servletRequest">
          </uix:messageTextInput>

          <uix:spacer height="10"/>
          
        </uix:stackLayout>
      </uix:case>

      <uix:case name="rollbackPkgs">
        <uix:stackLayout>
          <uix:styledText
            textBinding="UNDO_PATCHING_ROLLBACK_PKGS_TEXT@hostPatchResourceBundle"
            styleClass="oraInstructionText"/>

          <uix:spacer height="10"/>

          <%--to display error message--%>
          <uix:inlineMessage
            messageTypeBinding="msgType@pageData@servletRequest"
            messageBinding="infoMsg@pageData@servletRequest">

            <uix:table
              width="500"
              name="pkgsTable"
              id="pkgsTableID"
              summaryBinding="UNDO_PATCHING_ROLLBACK_PKGS_TEXT@hostPatchResourceBundle"
              partialRenderMode="self"
              formSubmitted="true"
              alternateTextBinding="MSG_NO_PKGG_FOUND_FOR_ROLLBACK@hostPatchResourceBundle"
              tableDataBinding="pkgsTable@stepsData@servletRequest"
              valueBinding="currValue@pageData@servletRequest"
              minValueBinding="minValue@pageData@servletRequest"
              blockSizeBinding="blockSize@pageData@servletRequest"
              maxValueBinding="maxValue@pageData@servletRequest"
              columnHeaderDataBinding="colHeaders@pageData@servletRequest">

              <uix:tableSelection>
                <uix:multipleSelection
                  shortDescBinding="SELECT@commonResourceBundle"
                  selectedBinding="isSelected">
                </uix:multipleSelection>
              </uix:tableSelection>

              <uix:columnHeaderStamp>
                <uix:sortableHeader
                  textBinding="text"
                  sortableBinding="sortable">
                </uix:sortableHeader>
              </uix:columnHeaderStamp>

              <uix:styledText
                textBinding="pkgName">
              </uix:styledText>

              <uix:column>
                <uix:choice
                  name="pkgVer"
                  selectedValueBinding="pkgVerSelVal">
                  <uix:contents
                    childDataBinding="pkgVerList">
                    <uix:option textBinding="version"/>
                  </uix:contents>
                </uix:choice>
              </uix:column>
            </uix:table>
          </uix:inlineMessage>
        </uix:stackLayout>
      </uix:case>
    </uix:switcher>
  </uix:dataScope>

</uix:buildTree>

<%@ include file="wizTemplate.jspf" %>
