<%--
  - FILE
  -   undoPatchingReview.jsp
  -
  - DESCRIPTION
  -   The Undo Patching - Review step of the wizard.
  -
  - MODIFIED  (MM/DD/YY)
  -   tasingh  07/13/05 - ADA Bugs 
  -   tasingh  06/20/05 - Add summary attribute 
  -   tasingh  05/26/05 - tasingh_bug-4327813
  -   tasingh  09/02/04 - created
  -
  - SINCE
  -   10.2
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%--All page contents should be within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">

  <uix:dataScope currentDataBinding="pageData@servletRequest">

    <uix:header textBinding="ACTION@hostPatchResourceBundle">
      <uix:rowLayout>
        <uix:styledText
          textBinding="SELECTED_ACTION@hostPatchResourceBundle"
          styleClass="OraInstructionText">
        </uix:styledText>
        <uix:spacer width="5"/>
        <uix:styledText
          textBinding="selectedActionText@pageData@servletRequest"
          styleClass="OraDataText">
        </uix:styledText>
      </uix:rowLayout>
    </uix:header>

    <uix:switcher childNameBinding="actionSelVal@stepsData@servletRequest">
      <uix:case name="uninstallPkgs">
        <uix:header textBinding="SELECTED_PACKAGES@hostPatchResourceBundle">
          <uix:table
            width="500"
            name="selPkgs"
            id="selPkgsID"
            summaryBinding="SELECTED_PACKAGES_TABLE@hostPatchResourceBundle"
            partialRenderMode="self"
            formSubmitted="true"
            alternateTextBinding="NONE@hostPatchResourceBundle"
            tableDataBinding="selPkgs@stepsData@servletRequest"
            columnHeaderDataBinding="selPkgsColHeader@pageData@servletRequest"
            valueBinding="selPkgsCurrValue@pageData@servletRequest"
            minValueBinding="selPkgsMinValue@pageData@servletRequest"
            blockSizeBinding="selPkgsBlockSize@pageData@servletRequest"
            maxValueBinding="selPkgsMaxValue@pageData@servletRequest">

            <uix:tableFormat tableBanding="rowBanding"/>

            <uix:columnHeaderStamp>
              <uix:sortableHeader
                textBinding="text"
                sortableBinding="sortable">
              </uix:sortableHeader>
            </uix:columnHeaderStamp>

            <uix:styledText
              textBinding="pkgName"
              shortDescBinding="SELECTED_PACKAGES@hostPatchResourceBundle">
            </uix:styledText>
          </uix:table>

          <uix:spacer height="10"/>

          <%--Explicitly specified packages--%>
          <uix:rowLayout>
            <uix:styledText
              textBinding="EXPLICITLY_SPECIFIED_PKGS@hostPatchResourceBundle"
              styleClass="OraPromptText">
            </uix:styledText>
            <uix:spacer width="5"/>
            <uix:styledText
              textBinding="explicitlySpecifiedPkgs@pageData@servletRequest"
              styleClass="OraDataText">
            </uix:styledText>
          </uix:rowLayout>
        </uix:header>
      </uix:case>

      <uix:case name="rollbackPkgs">
        <uix:header textBinding="SELECTED_PACKAGES@hostPatchResourceBundle">
          <uix:table
            width="500"
            name="selRollbackPkgsTable"
            id="selRollbackPkgsTableID"
            summaryBinding="SELECTED_PACKAGES_TABLE@hostPatchResourceBundle"
            partialRenderMode="self"
            formSubmitted="true"
            tableDataBinding="selRollbackPkgsTable@stepsData@servletRequest"
            valueBinding="currValue@pageData@servletRequest"
            minValueBinding="minValue@pageData@servletRequest"
            blockSizeBinding="blockSize@pageData@servletRequest"
            maxValueBinding="maxValue@pageData@servletRequest"
            columnHeaderDataBinding="colHeaders@pageData@servletRequest">

            <uix:columnHeaderStamp>
              <uix:sortableHeader
                textBinding="text"
                sortableBinding="sortable">
              </uix:sortableHeader>
            </uix:columnHeaderStamp>

            <uix:styledText
              textBinding="pkgName">
            </uix:styledText>

            <uix:styledText
              textBinding="pkgVer">
            </uix:styledText>

          </uix:table>
        </uix:header>
      </uix:case>
    </uix:switcher>

    <uix:header textBinding="SELECTED_HOSTS@hostPatchResourceBundle">
      <uix:hGrid
        id="hostHGrid"
        width="500"
        partialRenderMode="self"
        alternateTextBinding="MSG_NO_GROUPS_FOUND@hostPatchResourceBundle"
        summaryBinding="SELECTED_HOSTS_TABLE@hostPatchResourceBundle"
        treeDataBinding="hGridData@pageData@servletRequest"
        proxyBinding="hGridProxy@pageData@servletRequest"
        formSubmitted="true">

        <uix:nodeStamp>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="NAME@commonResourceBundle"/>
            </uix:columnHeader>
            <uix:styledText textBinding="text"/>
          </uix:column>
        </uix:nodeStamp>

      </uix:hGrid>
    </uix:header>

    <uix:spacer height="10"/>

    <%--Credentials Type--%>
    <uix:header textBinding="CREDENTIALS@hostPatchResourceBundle">
      <uix:switcher childNameBinding="credsType@pageData@servletRequest">

        <uix:case name="prefCreds">
          <uix:rowLayout>
            <uix:styledText
              textBinding="CREDENTIALS_TYPE@hostPatchResourceBundle"
              styleClass="OraPromptText">
            </uix:styledText>
            <uix:spacer width="5"/>
            <uix:styledText
              textBinding="credsTypeText@pageData@servletRequest"
              styleClass="OraDataText">
            </uix:styledText>
          </uix:rowLayout>
        </uix:case>

        <uix:case name="overrideCreds">
          <uix:tableLayout>
            <uix:rowLayout>
              <uix:styledText
                textBinding="CREDENTIALS_TYPE@hostPatchResourceBundle"
                styleClass="OraPromptText">
              </uix:styledText>
              <uix:spacer width="5"/>
              <uix:styledText
                textBinding="credsTypeText@pageData@servletRequest"
                styleClass="OraDataText">
              </uix:styledText>
            </uix:rowLayout>

            <uix:switcher childNameBinding="overridenCredType@pageData@servletRequest">

              <uix:case name="allHosts">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:styledText
                      textBinding="USERNAME@hostPatchResourceBundle"
                      styleClass="OraPromptText">
                    </uix:styledText>
                  </uix:cellFormat>
                  <uix:spacer width="5"/>
                  <uix:styledText
                    textBinding="username@stepsData@servletRequest"
                    styleClass="OraDataText">
                  </uix:styledText>
                </uix:rowLayout>
              </uix:case>

              <uix:case name="eachHost">
                <uix:table
                  width="500"
                  name="setCred"
                  id="setCredID"
                  summaryBinding="OVERRIDDEN_PREF_CREDS_EACH_HOST@hostPatchResourceBundle"
                  partialRenderMode="self"
                  formSubmitted="true"
                  tableDataBinding="setCred@stepsData@servletRequest"
                  columnHeaderDataBinding="setCredColHeader@stepsData@servletRequest"
                  valueBinding="setCredCurrValue@pageData@servletRequest"
                  minValueBinding="setCredMinValue@pageData@servletRequest"
                  blockSizeBinding="setCredBlockSize@pageData@servletRequest"
                  maxValueBinding="setCredMaxValue@pageData@servletRequest">


                  <uix:tableFormat tableBanding="rowBanding"/>

                  <uix:columnHeaderStamp>
                    <uix:sortableHeader
                      textBinding="text"
                      sortableBinding="sortable">
                    </uix:sortableHeader>
                  </uix:columnHeaderStamp>

                  <uix:styledText
                    textBinding="targetName"
                    shortDescBinding="SELECTED_TARGETS@hostPatchResourceBundle">
                  </uix:styledText>

                  <uix:styledText
                    textBinding="username">
                  </uix:styledText>

                </uix:table>
              </uix:case>

            </uix:switcher>
          </uix:tableLayout>
        </uix:case>
      </uix:switcher>
    </uix:header>

    <%--Patching Scripts Information--%>
    <uix:header textBinding="PATCHING_SCRIPTS@hostPatchResourceBundle">

      <%--Pre-Patching Script--%>
      <uix:header textBinding="PRE_PATCHING_SCRIPT@hostPatchResourceBundle">

        <uix:tableLayout>

          <uix:rowLayout>
            <uix:cellFormat>
              <uix:styledText
                textBinding="PRE_SCRIPT_CHK_BOX_TXT@hostPatchResourceBundle"
                styleClass="OraPromptText">
              </uix:styledText>
            </uix:cellFormat>

            <uix:spacer width="8"/>

            <uix:cellFormat>
              <uix:styledText
                textBinding="applyPreScript@pageData@servletRequest"
                styleClass="OraDataText">
              </uix:styledText>
            </uix:cellFormat>
          </uix:rowLayout>

          <uix:switcher childNameBinding="isPreScriptUnChkd@stepsData@servletRequest">
            <uix:case name="false">
              <uix:rowLayout>
                <uix:cellFormat>
                  <uix:styledText
                    textBinding="SCRIPT_LOCATION_TXT@hostPatchResourceBundle"
                    styleClass="OraPromptText">
                  </uix:styledText>
                </uix:cellFormat>

                <uix:spacer width="8"/>

                <uix:cellFormat>
                  <uix:styledText
                    textBinding="preScriptLoc@pageData@servletRequest"
                    styleClass="OraDataText">
                  </uix:styledText>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:case>
          </uix:switcher>

          <uix:switcher childNameBinding="isPreScriptUnChkd@stepsData@servletRequest">
            <uix:case name="false">
              <uix:rowLayout>
                <uix:cellFormat>
                  <uix:styledText
                    textBinding="PRE_SCRIPT_ROOT_CHK_BOX_TXT@hostPatchResourceBundle"
                    styleClass="OraPromptText">
                  </uix:styledText>
                </uix:cellFormat>

                <uix:spacer width="8"/>

                <uix:cellFormat>
                  <uix:styledText
                    textBinding="applyPreAsRoot@pageData@servletRequest"
                    styleClass="OraDataText">
                  </uix:styledText>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:case>
          </uix:switcher>

        </uix:tableLayout>
      </uix:header>

      <uix:spacer height="10"/>

      <%--Post-Patching Script--%>
      <uix:header textBinding="POST_PATCHING_SCRIPT@hostPatchResourceBundle">

        <uix:tableLayout>
          <uix:rowLayout>
            <uix:cellFormat>
              <uix:styledText
                textBinding="POST_SCRIPT_CHK_BOX_TXT@hostPatchResourceBundle"
                styleClass="OraPromptText">
              </uix:styledText>
            </uix:cellFormat>

            <uix:spacer width="8"/>

            <uix:cellFormat>
              <uix:styledText
                textBinding="applyPostScript@pageData@servletRequest"
                styleClass="OraDataText">
              </uix:styledText>
            </uix:cellFormat>
          </uix:rowLayout>

          <uix:switcher childNameBinding="isPostScriptUnChkd@stepsData@servletRequest">
            <uix:case name="false">
              <uix:rowLayout>
                <uix:cellFormat>
                  <uix:styledText
                    textBinding="SCRIPT_LOCATION_TXT@hostPatchResourceBundle"
                    styleClass="OraPromptText">
                  </uix:styledText>
                </uix:cellFormat>

                <uix:spacer width="8"/>

                <uix:cellFormat>
                  <uix:styledText
                    textBinding="postScriptLoc@pageData@servletRequest"
                    styleClass="OraDataText">
                  </uix:styledText>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:case>
          </uix:switcher>

          <uix:switcher childNameBinding="isPostScriptUnChkd@stepsData@servletRequest">
            <uix:case name="false">
              <uix:rowLayout>
                <uix:cellFormat>
                  <uix:styledText
                    textBinding="POST_SCRIPT_ROOT_CHK_BOX_TXT@hostPatchResourceBundle"
                    styleClass="OraPromptText">
                  </uix:styledText>
                </uix:cellFormat>

                <uix:spacer width="8"/>

                <uix:cellFormat>
                  <uix:styledText
                    textBinding="applyPostAsRoot@pageData@servletRequest"
                    styleClass="OraDataText">
                  </uix:styledText>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:case>
          </uix:switcher>
        </uix:tableLayout>
      </uix:header>
    </uix:header>
    <uix:spacer height="10"/>
  </uix:dataScope>
</uix:buildTree>

<%@ include file="wizTemplate.jspf" %>
