<%--
  - FILE
  -   affectedHomes.jsp
  - 
  - DESCRIPTION
  -   jsp file for the affected homes tab
  -   Its controller must provide getPageHeader() method
  -   Its default bean must provide getSubTabSelIdx() method
  -
  - MODIFIED  (MM/DD/YY)
  - hmodawel  03/06/06 - fix compilation 
  - abhalla   11/24/05 - NLS change 
  - somukher  06/27/05 - Bug - 4442857
  - abhalla   06/19/05 - bug fix 4378181 
  - somukher  06/18/05 - 
  - somukher  06/14/05 - Patch Management UI bug fixes 
  - mningomb  06/03/05 - Make search field labels locale-ware 
  - pdasika   04/15/05 - Remove destinationBinding from table tags 
  - mningomb  09/22/04 - Adding taglib url to oem 
  - mningomb  09/20/04 - mningomb_final
  - mningomb  09/11/04 - Alignment of filter criterias 
  - mningomb  09/09/04 - 
  - apbharga  09/02/04 - 
  - mningomb  08/02/04 - created
  -
  --%>

<%@ taglib uri= "http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:buildTree nodeID="timestamp" scope="request">
  <%@ include file="timestamp.jspf" %>
</uix:buildTree>
<uix:buildTree nodeID="filterHomes" scope="request">
     <uix:stackLayout>
      <uix:contents>
        <uix:tableLayout>
        <uix:rowLayout>
        <uix:contents>
         <uix:cellFormat hAlign="left">
          <uix:contents>
           <uix:styledText styleClass="OraPromptText" textBinding="PW_COLHDR_PLATFORM@patchResourceBundle"/>
           <uix:spacer width="10"/>
          </uix:contents>
         </uix:cellFormat>

         <uix:cellFormat hAlign="left">
          <uix:contents>
           <uix:choice name="platform"
                 selectedValueBinding="platform@cpfDefaultBean@servletRequest"
                 shortDescBinding="SD_SELECT_PLATFORM@patchResourceBundle">
             <uix:contents childDataBinding="platforms@cpfDefaultBean@servletRequest">
                 <uix:option textBinding="platform" valueBinding="platformValue"/>
             </uix:contents>
           </uix:choice>
           <uix:spacer width="10"/>
          </uix:contents>
         </uix:cellFormat>

         <uix:cellFormat hAlign="right">
          <uix:contents>
           <uix:messageLovField name="hostLov"
                   textBinding="host@cpfDefaultBean@servletRequest"
                   columns="39"
                   promptBinding="LBL_SEARCH_HOST@patchResourceBundle"
                   shortDescBinding="LBL_SEARCH_HOST@patchResourceBundle"
                   searchDescBinding="LBL_SEARCH_HOST@patchResourceBundle"
                   onClick= "setHomesHostRedirValue();
                             openWindow(top,
                             hostRedir.value,
                             'lovWindow',
                             {width:600, height:200},
                             true,
                             'dialog',
                             hostCallBack); " />
          </uix:contents>
         </uix:cellFormat>
         </uix:contents>
        </uix:rowLayout>

        <uix:rowLayout>
        <uix:contents>
         <uix:cellFormat hAlign="left">
          <uix:contents>
            <uix:styledText styleClass="OraPromptText" textBinding="PDR_PRODUCTID@patchResourceBundle"/>
            <uix:spacer width="10"/>
          </uix:contents>
         </uix:cellFormat>

         <uix:cellFormat hAlign="left">
          <uix:contents>
           <uix:choice name="product"
                 selectedValueBinding="product@cpfDefaultBean@servletRequest"
                 shortDescBinding="SD_SELECT_PRODUCT@patchResourceBundle">
             <uix:contents childDataBinding="products@cpfDefaultBean@servletRequest">
                 <uix:option textBinding="product" valueBinding="productValue"/>
             </uix:contents>
           </uix:choice>
           <uix:spacer width="10"/>
          </uix:contents>
         </uix:cellFormat>

         <uix:cellFormat hAlign="right">
          <uix:contents>
           <uix:messageLovField name="versionLov"
                   textBinding="version@cpfDefaultBean@servletRequest"
                   columns="39"
                   promptBinding="LBL_SEARCH_VERSION@patchResourceBundle"
                   shortDescBinding="LBL_SEARCH_VERSION@patchResourceBundle"
                   searchDescBinding="LBL_SEARCH_VERSION@patchResourceBundle"
                   onClick= "setVersionRedirValue();
                             openWindow(top,
                             versionRedir.value,
                             'lovWindow',
                             {width:600, height:200},
                             true,
                             'dialog',
                             versionCallBack); " />
          </uix:contents>
         </uix:cellFormat>
        </uix:contents>
        </uix:rowLayout>
        </uix:tableLayout>
         <uix:spacer width="10"/>
         <uix:submitButton name="event" textBinding="LBL_SEARCH_HOMES@patchResourceBundle"
               value="searchHomes"/>

      </uix:contents>
     </uix:stackLayout>
</uix:buildTree>
<uix:buildTree nodeID="pageContent" scope="request">
<uix:script id="cpf_script" source="/em/ecm/patch/cpf/lov/cpf.js"/>
<noScript>""</noScript>
<%--
 <uix:tableLayout cellSpacing="5" width="100%">
 <uix:rowLayout>
 <uix:contents>
--%>
  <uix:form name="affectedHomes" method="post" destination="affectedHomes">
  <uix:header textBinding="AFFECTED_HOMES_TABLE_HEADER@patchResourceBundle">
    <uix:tableLayout cellSpacing="5" width="100%">
     <uix:rowLayout>


	<uix:hideShowHeader textBinding="SEARCH@patchResourceBundle" id="search_homes"
	 formName="searchType@servletRequest"
	 formSubmitted="false"
	 disclosedBinding="disclosedVal@cpfDefaultBean@servletRequest"
	>
	<uix:contents>

			<uix:spacer height="10"/>
			 <uix:ref refID="filterHomes"/>
	</uix:contents>
	</uix:hideShowHeader>

<%--
             <uix:switcher childNameBinding="searchType@servletRequest">
              <uix:case name="allHomes">
                    <uix:tableLayout width="100%">
                    <uix:contents>
                    <uix:rowLayout>
                    <uix:contents>
                        <uix:cellFormat hAlign="right">
                        <uix:contents>
                             <uix:button textBinding="FILTER_HOME_LBL@patchResourceBundle"
                                         destination="affectedHomes?searchType=filterHomes"
                                         rendered="true"
                                        />
                        </uix:contents>
                      </uix:cellFormat>
                    </uix:contents>
                    </uix:rowLayout>
                    </uix:contents>
                    </uix:tableLayout>
              </uix:case>
              <uix:case name="filterHomes">
                    <uix:tableLayout width="100%">
                    <uix:contents>
                        <uix:rowLayout>
                        <uix:contents>
                            <uix:cellFormat columnSpan="2" hAlign="right">
                            <uix:contents>
                             <uix:button textBinding="ALL_HOMES_LBL@patchResourceBundle"
                                         destination="affectedHomes?searchType=allHomes"
                                         rendered="true"
                                        />
                            </uix:contents>
                            </uix:cellFormat>
                        </uix:contents>
                        </uix:rowLayout>
                        <uix:rowLayout>
                        <uix:contents>
                         <uix:spacer height="10"/>
                         <uix:ref refID="filterHomes"/>
                        </uix:contents>
                        </uix:rowLayout>
                    </uix:contents>
                    </uix:tableLayout>
              </uix:case>
              </uix:switcher>
    
--%>
	 </uix:rowLayout>
     <uix:separator>
         <uix:spacer width="10"/>
     </uix:separator>
     <uix:rowLayout width="100%">
      <uix:contents>
      <uix:table 
       name="affected_homes"
       id="affected_homes"
       width="88%"
       summary="affected_homes"	
       partialRenderMode="self"
       showAll="yes"
       valueBinding="currentValue@cpfDefaultBean@servletRequest"
       minValueBinding="minValue@cpfDefaultBean@servletRequest"
       blockSizeBinding="blockSize@cpfDefaultBean@servletRequest"
       maxValueBinding="maxValue@cpfDefaultBean@servletRequest" 
       alternateTextBinding="NO_AFFECTED_HOMES_FOUND@patchResourceBundle"
       tableDataBinding="rows@cpfDefaultBean@servletRequest"
       columnHeaderDataBinding="columnHeaders@cpfDefaultBean@servletRequest">
       
       <uix:tableFormat tableBanding="rowBanding"/>
       <uix:columnHeaderStamp>
        <uix:sortableHeader 
            textBinding="text"
            sortableBinding="sortable">
        </uix:sortableHeader>
       </uix:columnHeaderStamp>

      <uix:tableSelection>
       <uix:singleSelection selectedIndexBinding="index@cpfDefaultBean@servletRequest" shortDescBinding="SD_SELECT_LIST@patchResourceBundle">
        <uix:submitButton name="event" formName="affectedHomes"
                    textBinding="LBL_SHOW_REMEDIES@patchResourceBundle"
                    value="showRemediesForHome"/>
       </uix:singleSelection>
      </uix:tableSelection>

       <uix:column>
         <uix:contents>
            <uix:styledText textBinding="host"/>
            <uix:formValue name="rowKey" valueBinding="rowKey"/>
         </uix:contents>
       </uix:column>

       <uix:styledText textBinding="directory"/>

       <uix:column>
       <uix:contents>
        <uix:columnFormat 
          cellNoWrapFormat="true"
          columnDataFormat="numberFormat" />
        <uix:styledText textBinding="alerts"/>
       </uix:contents>
      </uix:column>
    </uix:table>
   </uix:contents>
   </uix:rowLayout>
   </uix:tableLayout>
 
   <uix:spacer height="10"/>
  
  </uix:header>
       <uix:formValue name="hostRedir" value=""/>
       <uix:formValue name="hostLovPage" valueBinding="hostLovPage@cpfDefaultBean@servletRequest"/>
       <uix:formValue name="versionRedir" value=""/>
       <uix:formValue name="versionLovPage" 
           valueBinding="versionLovPage@cpfDefaultBean@servletRequest"/>
       <uix:formValue name="contextPath" valueBinding="contextPath@servletRequest"/>
       <uix:formValue name="imagePath" valueBinding="imagePath@servletRequest"/>
       <uix:formValue name="event" value=""/>
<%--
 </uix:contents>
--%>
 </uix:form>
<%--
</uix:rowLayout>
</uix:tableLayout>
--%>

</uix:buildTree>

<%@ include file="cpftemplate.jspf" %>

