<%--
  - FILE
  -   groupAdvisories.jsp
  - 
  - DESCRIPTION
  -   jsp file for the group patch advisories.
  -   Its controller must provide getPageHeader() method
  -
  - MODIFIED  (MM/DD/YY)
  - pdasika   04/15/05 - Remove destinationBinding from table tags 
  - mningomb  02/20/05 - Change CPF_HEADER to GROUP_CPF_HEAFER 
  - mningomb  11/24/04 - mningomb_cpfps
  - mningomb  10/25/04 - Creation
  -
  --%>

<%@ taglib uri= "http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:buildTree nodeID="timestamp" scope="request">
<uix:tableLayout width="100%">
  <uix:rowLayout vAlign="top" hAlign="right" width="100%">
    <uix:cellFormat hAlign="right" width="40%">
      <uix:rowLayout>
        <uix:styledText styleClass="OraTipText"
            textBinding="PAGE_REFRESHED_TIME@sdkUIMsg"/>
        <uix:spacer width="4" />
        <uix:styledText styleClass="OraTipLabel"
            textBinding="timestamp@cpfDefaultBean@servletRequest"/>
        <uix:spacer width="4" />
        <uix:image sourceBinding="refreshIconURL@cpfDefaultBean@servletRequest"
                   destinationBinding="groupRefreshIconDest@cpfDefaultBean@servletRequest"
                   shortDescBinding="REFRESH_DATA@commonResourceBundle"/>
      </uix:rowLayout>
    </uix:cellFormat>
  </uix:rowLayout>
</uix:tableLayout>
</uix:buildTree>


<uix:buildTree nodeID="pageContent" scope="request">
 <uix:form name="groupAdvisoriesForm" method="get">
  <uix:header textBinding="PATCH_ADVISORIES_TABLE_HEADER@patchResourceBundle">
    <uix:table 
      name="patch_advisories"
      id="patch_advisories_id"
      width="100%"
      partialRenderMode="self"
      showAll="yes"
      valueBinding="currentValue@cpfDefaultBean@servletRequest"
      minValueBinding="minValue@cpfDefaultBean@servletRequest"
      blockSizeBinding="blockSize@cpfDefaultBean@servletRequest"
      maxValueBinding="maxValue@cpfDefaultBean@servletRequest" 
      alternateTextBinding="NO_ADVISORIES_FOUND@patchResourceBundle"
      tableDataBinding="rows@cpfDefaultBean@servletRequest"
      columnHeaderDataBinding="columnHeaders@cpfDefaultBean@servletRequest">
       
      <uix:tableFormat tableBanding="rowBanding"/>
      <uix:columnHeaderStamp>
        <uix:sortableHeader 
            textBinding="text"
            sortableBinding="sortable">
        </uix:sortableHeader>
      </uix:columnHeaderStamp>

      <uix:column>
         <uix:contents>
            <uix:styledText textBinding="advisory" destinationBinding="advisoryLink"/>
            <uix:formValue name="rowKey" valueBinding="rowKey"/>
         </uix:contents>
      </uix:column>

      <uix:styledText textBinding="impact"/>

      <uix:styledText textBinding="abstract"/>
      
      <uix:column>
       <uix:contents>
        <uix:columnFormat 
          cellNoWrapFormat="true"
          columnDataFormat="numberFormat" />
        <uix:styledText 
          textBinding="hosts"/>
       </uix:contents>
      </uix:column>

      <uix:column>
       <uix:contents>
        <uix:columnFormat 
          cellNoWrapFormat="true"
          columnDataFormat="numberFormat" />
        <uix:styledText 
          textBinding="homes"/>
       </uix:contents>
      </uix:column>
       
    </uix:table>
  </uix:header>
 </uix:form>

  <uix:header textBinding="LBL_PATCHSETS_TO_APPLY@patchResourceBundle">
    <uix:table 
      name="advPatchsetsTable"
      id="advPatchsetsTable"
      width="100%"
      partialRenderMode="self"
      showAll="yes"
      valueBinding="currentValue@groupPatchsetsBean@servletRequest"
      minValueBinding="minValue@groupPatchsetsBean@servletRequest"
      blockSizeBinding="blockSize@groupPatchsetsBean@servletRequest"
      maxValueBinding="maxValue@groupPatchsetsBean@servletRequest" 
      alternateTextBinding="NO_PATCHSETS_FOUND@patchResourceBundle"
      tableDataBinding="rows@groupPatchsetsBean@servletRequest"
      columnHeaderDataBinding="columnHeaders@groupPatchsetsBean@servletRequest"
      destinationBinding="destination@servletRequest">
       
      <uix:tableFormat tableBanding="rowBanding"/>
      <uix:columnHeaderStamp>
        <uix:sortableHeader 
            textBinding="text"
            sortableBinding="sortable">
        </uix:sortableHeader>
      </uix:columnHeaderStamp>

      <uix:styledText textBinding="patchset" destinationBinding="patchWizardLink"/>
      <uix:styledText textBinding="product"/>
      <uix:styledText textBinding="release"/>
      <uix:styledText textBinding="platform"/>
      <uix:rawText textBinding="advisory"/>
      <uix:column>
       <uix:contents>
        <uix:columnFormat 
          cellNoWrapFormat="true"
          columnDataFormat="numberFormat" />
        <uix:styledText 
          textBinding="homes" destinationBinding="patchWizardLink"/>
       </uix:contents>
      </uix:column>
    </uix:table>
  </uix:header>

  <uix:header textBinding="LBL_PATCHES_TO_APPLY@patchResourceBundle">
    <uix:table 
      name="advPatchesTable"
      id="advPatchesTable"
      width="100%"
      partialRenderMode="self"
      showAll="yes"
      valueBinding="currentValue@groupPatchesBean@servletRequest"
      minValueBinding="minValue@groupPatchesBean@servletRequest"
      blockSizeBinding="blockSize@groupPatchesBean@servletRequest"
      maxValueBinding="maxValue@groupPatchesBean@servletRequest" 
      alternateTextBinding="NO_PATCHES_FOUND@patchResourceBundle"
      tableDataBinding="rows@groupPatchesBean@servletRequest"
      columnHeaderDataBinding="columnHeaders@groupPatchesBean@servletRequest"
      destinationBinding="destination@servletRequest">
       
      <uix:tableFormat tableBanding="rowBanding"/>
      <uix:columnHeaderStamp>
        <uix:sortableHeader 
            textBinding="text"
            sortableBinding="sortable">
        </uix:sortableHeader>
      </uix:columnHeaderStamp>

      <uix:styledText textBinding="patches" destinationBinding="patchWizardLink"/>
      <uix:styledText textBinding="product"/>
      <uix:styledText textBinding="release"/>
      <uix:styledText textBinding="platform"/>
      <uix:rawText textBinding="advisory"/>
      <uix:column>
       <uix:contents>
        <uix:columnFormat 
          cellNoWrapFormat="true"
          columnDataFormat="numberFormat" />
        <uix:styledText 
          textBinding="homes" destinationBinding="patchWizardLink"/>
       </uix:contents>
      </uix:column>
    </uix:table>
  </uix:header>

</uix:buildTree>


<%@ page contentType="text/html; charset=UTF-8" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder  id="renderingContext"/>
  <%--Common UI messages --%>
  <uix:bundle name="sdkUIMsg"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  
  <%--ResourceBundle for common labels/headers etc--%>
  <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  
  <%--ResourceBundle for labels/headers specific to 'EM Patching' Project--%>
  <uix:bundle name="patchResourceBundle"
              class="oracle.sysman.eml.ecm.patch.util.PatchResourceBundle"/>
              
  <uix:document>
   <%-- To Support partial rendering --%>
   <%@ include  file="/enablePPR.jspf" %>
    <%--
      - To display "Oracle Enterprise Manager" followed by UserName on 
      - PageTitle. To append page specific string in the title implement
      - getPageHeader() in the CONTROLLER CLASS of YOUR JSP
      --%>
    <%@ include file="/oemTitle.jspf" %>
    
    <uix:body>
        <uix:pageLayout> 
        <uix:flowLayout>
         <uix:contents>
           <uix:link textBinding="groupLabel@cpfDefaultBean@servletRequest" 
                     destinationBinding="groupLink@cpfDefaultBean@servletRequest"/>
           <uix:spacer width="5"/>
           <uix:styledText styleClass="OraTipText" textBinding="GROUP_CPF_HEADER@patchResourceBundle"/>
         </uix:contents>
        </uix:flowLayout>
        <uix:spacer height="10"/>
        <uix:header textBinding="header@servletRequest"/>
        <uix:rowLayout>
          <uix:contents>
            <uix:styledText styleClass="OraInstructionText" 
               textBinding="GROUP_CPF_DESCRIPTION@patchResourceBundle"/>
          </uix:contents>
        </uix:rowLayout>

          <%--To display GlobalTabs, Buttons, Footer,Copyright etc.--%>
          <%@ include file="/oemGlobal.jspf" %>

          <uix:stackLayout>
                   
            <uix:ref refID="timestamp"/>

            <uix:subTabLayout>
                <oem:messageBox messageType="error"
                          titleTextKey="titleText"
                          mainTextKey="mainText"
                          errorTableBinding="errors@servletRequest"/>

              <%--
                - Your page specific contents will be attached here
                - Following tag does that. Your JSP page should
                - put all its contents WITHIN the 'buildTree' tag 
                - with attributes 
                -   nodeID="pageContent" and
                -   scope="request"
                --%>

                <uix:ref refID="pageContent"/>
              
            </uix:subTabLayout>
          </uix:stackLayout>
        </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>

