<%--
  - FILE
  -   patchadvisories.jsp
  - 
  - DESCRIPTION
  -   jsp file for the patch advisories tab.
  -   Its controller must provide getPageHeader() method
  -   Its default bean must provide getSubTabSelIdx() method
  -
  - MODIFIED  (MM/DD/YY)
  - somukher  06/27/05 - Bug 4442849 
  - pdasika   04/14/05 - Changes to make the navigation of tables work 
  - mningomb  09/22/04 - Adding taglib url to oem 
  - mningomb  09/20/04 - mningomb_final
  - mningomb  09/13/04 - Add hosts column 
  - apbharga  09/10/04 - 
  - mningomb  09/09/04 - 
  - apbharga  09/03/04 - 
  - mningomb  08/02/04 - created
  -
  --%>

<%@ taglib uri= "http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ include file="/oemNoscript.jspf" %>

<uix:buildTree nodeID="timestamp" scope="request">
  <%@ include file="timestamp.jspf" %>
</uix:buildTree>


<uix:buildTree nodeID="pageContent" scope="request">
 <uix:form name="advisoriesForm" method="get" destination="remediesAdvisories">
  <uix:header textBinding="PATCH_ADVISORIES_TABLE_HEADER@patchResourceBundle">
    <uix:table 
      name="patch_advisories"
      id="patch_advisories_id"
      width="100%"
      summary="PATCH_ADVISORIES_TABLE_HEADER@patchResourceBundle"	
      partialRenderMode="self"
      showAll="yes"
      valueBinding="currentValue@cpfDefaultBean@servletRequest"
      minValueBinding="minValue@cpfDefaultBean@servletRequest"
      blockSizeBinding="blockSize@cpfDefaultBean@servletRequest"
      maxValueBinding="maxValue@cpfDefaultBean@servletRequest" 
      alternateTextBinding="NO_ADVISORIES_FOUND@patchResourceBundle"
      tableDataBinding="rows@cpfDefaultBean@servletRequest"
      columnHeaderDataBinding="columnHeaders@cpfDefaultBean@servletRequest">
       
      <uix:tableFormat tableBanding="rowBanding"/>
      <uix:columnHeaderStamp>
        <uix:sortableHeader 
            textBinding="text"
            sortableBinding="sortable">
        </uix:sortableHeader>
      </uix:columnHeaderStamp>
     <uix:tableSelection>
    <uix:singleSelection   text="" selectedIndexBinding="index@cpfDefaultBean@servletRequest" shortDescBinding="SD_SELECT_LIST@patchResourceBundle">
   <label>   <uix:submitButton name="event" formName="advisoriesForm"
                    textBinding="LBL_SHOW_REMEDIES@patchResourceBundle"
                    value="showRemediesForAlert"/></label>
      </uix:singleSelection>
     </uix:tableSelection>
      <uix:column>
         <uix:contents>
            <uix:styledText textBinding="advisory" destinationBinding="advisoryLink"/>
            <uix:formValue name="rowKey" valueBinding="rowKey"/>
         </uix:contents>
      </uix:column>

      <uix:styledText textBinding="impact"/>

      <uix:styledText textBinding="abstract"/>
      
      <uix:column>
       <uix:contents>
    <uix:columnFormat 
          cellNoWrapFormat="true" 
	  columnDataFormat="numberFormat" />
	<uix:styledText 
          textBinding="hosts"/>
       </uix:contents>
      </uix:column>

      <uix:column>
       <uix:contents>
        <uix:columnFormat 
          cellNoWrapFormat="true"
          columnDataFormat="numberFormat" />
        <uix:styledText 
          textBinding="homes"/>
       </uix:contents>
      </uix:column>
       
    </uix:table>
  </uix:header>
 </uix:form>

  <uix:header textBinding="LBL_PATCHSETS_TO_APPLY@patchResourceBundle">
    <uix:table 
      name="advPatchsetsTable"
      id="advPatchsetsTable"
      width="100%"
      summary="LBL_PATCHSETS_TO_APPLY@patchResourceBundle"	
      partialRenderMode="self"
      showAll="yes"
      valueBinding="currentValue@patchsetsBean@servletRequest"
      minValueBinding="minValue@patchsetsBean@servletRequest"
      blockSizeBinding="blockSize@patchsetsBean@servletRequest"
      maxValueBinding="maxValue@patchsetsBean@servletRequest" 
      alternateTextBinding="NO_PATCHSETS_FOUND@patchResourceBundle"
      tableDataBinding="rows@patchsetsBean@servletRequest"
      columnHeaderDataBinding="columnHeaders@patchsetsBean@servletRequest">
       
      <uix:tableFormat tableBanding="rowBanding"/>
      <uix:columnHeaderStamp>
        <uix:sortableHeader 
            textBinding="text"
            sortableBinding="sortable">
        </uix:sortableHeader>
      </uix:columnHeaderStamp>

      <uix:styledText textBinding="patchset" destinationBinding="patchWizardLink"/>
      <uix:styledText textBinding="product"/>
      <uix:styledText textBinding="release"/>
      <uix:styledText textBinding="platform"/>
      <uix:rawText textBinding="advisory"/>
      <uix:column>
       <uix:contents>
        <uix:columnFormat 
          cellNoWrapFormat="true"
          columnDataFormat="numberFormat" />
        <uix:styledText 
          textBinding="homes" destinationBinding="patchWizardLink"/>
       </uix:contents>
      </uix:column>
    </uix:table>
  </uix:header>

  <uix:header textBinding="LBL_PATCHES_TO_APPLY@patchResourceBundle">
    <uix:table 
      name="advPatchesTable"
      id="advPatchesTable"
      width="100%"
      summary="LBL_PATCHES_TO_APPLY@patchResourceBundle"	
      partialRenderMode="self"
      showAll="yes"
      valueBinding="currentValue@patchesBean@servletRequest"
      minValueBinding="minValue@patchesBean@servletRequest"
      blockSizeBinding="blockSize@patchesBean@servletRequest"
      maxValueBinding="maxValue@patchesBean@servletRequest" 
      alternateTextBinding="NO_PATCHES_FOUND@patchResourceBundle"
      tableDataBinding="rows@patchesBean@servletRequest"
      columnHeaderDataBinding="columnHeaders@patchesBean@servletRequest">
       
      <uix:tableFormat tableBanding="rowBanding"/>
      <uix:columnHeaderStamp>
        <uix:sortableHeader 
            textBinding="text"
            sortableBinding="sortable">
        </uix:sortableHeader>
      </uix:columnHeaderStamp>

      <uix:styledText textBinding="patches" destinationBinding="patchWizardLink"/>
      <uix:styledText textBinding="product"/>
      <uix:styledText textBinding="release"/>
      <uix:styledText textBinding="platform"/>
      <uix:rawText textBinding="advisory"/>
      <uix:column>
       <uix:contents>
        <uix:columnFormat 
          cellNoWrapFormat="true"
          columnDataFormat="numberFormat" />
        <uix:styledText 
          textBinding="homes" destinationBinding="patchWizardLink"/>
       </uix:contents>
      </uix:column>
    </uix:table>
  </uix:header>

</uix:buildTree>

<%@ include file="cpftemplate.jspf" %>

