<%--
  - FILE
  -   remedies.jsp
  - 
  - DESCRIPTION
  -   jsp file for the remedies tab
  -   Its controller must provide getPageHeader() method
  -   Its default bean must provide getSubTabSelIdx() method
  -
  - MODIFIED  (MM/DD/YY)
  - somukher  06/28/05 - Bug-4442864
  - mningomb  06/03/05 - Make subtabs names locale-aware 
  - mningomb  09/22/04 - Adding taglib url to oem 
  - mningomb  09/20/04 - mningomb_final
  - apbharga  09/02/04 - 
  - mningomb  08/02/04 - created
  -
  --%>

<%@ taglib uri= "http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="java.util.Vector,
                 java.util.Hashtable,
                 oracle.cabo.ui.data.DataObject,
                 oracle.cabo.ui.data.DataObjectList,
                 oracle.sysman.eml.ecm.patch.critical.uidata.RemediesByHome,
                 oracle.sysman.eml.ecm.patch.critical.db.OracleHome,
                 oracle.sysman.eml.ecm.patch.PatchConsts" %>

<uix:buildTree nodeID="timestamp" scope="request">
	<%@ include file="timestamp.jspf" %>
</uix:buildTree>


<uix:buildTree nodeID="pageContent" scope="request">

	<uix:spacer height="6"/>
            <uix:subTabLayout>

              <uix:subTabs>
                <uix:subTabBar selectedIndex="0">
                  <uix:link textBinding="SUBTAB_HEADER_BY_HOMES@patchResourceBundle"
                            destination="remedies"/>
                  <uix:link textBinding="SUBTAB_HEADER_BY_ADVISORIES@patchResourceBundle"
                            destination="remediesAdvisories"/>
                </uix:subTabBar>
              </uix:subTabs>

	<uix:script id="cpf_script" source="/em/ecm/patch/cpf/lov/cpf.js"/>
	<noscript>""</noscript>
	<%--
	<uix:header textBinding="REMEDIES_HEADER_LBL@patchResourceBundle">
	<uix:styledText styleClass="OraInstructionText"
		 textBinding="REMEDIES_INFO_LBL@patchResourceBundle"/>
	<uix:separator> <uix:spacer width="10"/> </uix:separator>
	--%>
 	<uix:form name="remediesForm" destination="remedies" method="get">

	<%
	String searchBy = (String)request.getAttribute("searchBy");
	boolean searchByHome = true;
	if (searchBy != null && searchBy.trim().equals("alerts")) {
		searchByHome = false;
	}
	Vector remediesByHomes = (Vector) request.getAttribute(PatchConsts.REMEDIES_BY_HOME_LIST);
	boolean showAlerts = remediesByHomes != null && remediesByHomes.size() > 0;
	%>

   <% if (searchByHome) { %>
     <%@ include file="remedies_homes.jspf" %>
   <%} else { %>
     <%@ include file="remedies_alerts.jspf" %>
   <% } %>

    <uix:formValue name="contextPath" valueBinding="contextPath@servletRequest"/>
    <uix:formValue name="imagePath" valueBinding="imagePath@servletRequest"/>
    <uix:formValue name="event"/>

  </uix:form>
 <%--
 </uix:header>
 --%>

	</uix:subTabLayout>
	<uix:spacer height="6"/>
</uix:buildTree>

<%@ include file="cpftemplate.jspf" %>

