<%@ taglib uri= "http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:buildTree nodeID="timestamp" scope="request">
	<%@ include file="timestamp.jspf" %>
</uix:buildTree>

<uix:buildTree nodeID="pageContent" scope="request">

	<uix:spacer height="6"/>

            <uix:subTabLayout>

              <uix:subTabs>
                <uix:subTabBar selectedIndex="1">
                  <uix:link textBinding="SUBTAB_HEADER_BY_HOMES@patchResourceBundle"
                            destination="remedies"/>
                  <uix:link textBinding="SUBTAB_HEADER_BY_ADVISORIES@patchResourceBundle"
                            destination="remediesAdvisories"/>
                </uix:subTabBar>
              </uix:subTabs>

  <uix:form name="remediesAdvisoriesForm" destination="remediesAdvisories" method="get">
	<uix:script id="cpf_script" source="/em/ecm/patch/cpf/lov/cpf.js"/>
	<noScript>""</noScript>
    <uix:formValue name="contextPath" valueBinding="contextPath@servletRequest"/>
    <uix:formValue name="imagePath" valueBinding="imagePath@servletRequest"/>
    <uix:formValue name="event"/>
	
<uix:tableLayout width="100%" cellSpacing="6">
	<uix:rowLayout>
		<uix:cellFormat width="35%" hAlign="left" vAlign="top">
			<uix:stackLayout>
                                <%--
				<uix:contentContainer background="light" width="100%">
					<uix:flowLayout>
						<uix:styledText styleClass="OraInstructionText" textBinding="RBA_REMEDIES_ALERT@patchResourceBundle"/>
						<uix:formValue name="search_option" value="alerts" />
						<uix:submitButton name="event" value="switchSearchBy" textBinding="RBA_REMEDIES_ALERT1@patchResourceBundle"/>
					</uix:flowLayout>
				</uix:contentContainer>
                                --%>
				<uix:contentContainer background="light" width="100%">
				<uix:spacer height="18"/>
				   <uix:messageLovField name="alertLov"
								   textBinding="alertLov@servletRequest"
								   columns="39"
								   promptBinding="LBL_SEARCH_ALERT@patchResourceBundle"
								   shortDescBinding="LBL_SEARCH_ALERT@patchResourceBundle"
								   searchDescBinding="LBL_SEARCH_ALERT@patchResourceBundle"
								   onClick= "   setAlertRedirValue();
												openWindow(top,
												document.remediesAdvisoriesForm.alertRedir.value,
												'lovWindow',
												{width:600, height:200},
												true,
												'dialog',
												alertCallBack); " />
				<%--<uix:spacer height="12"/>--%>
				<uix:submitButton name="event" textBinding="RBA_SHOW_HOMES@patchResourceBundle" value="showAdvHomes"/>
				</uix:contentContainer>
				   <uix:formValue name="alertRedir"/>
				   <uix:formValue name="alertLovPage" valueBinding="alertLovPage@cpfDefaultBean@servletRequest"/>
			</uix:stackLayout>
		</uix:cellFormat>
		<uix:cellFormat width="65%" hAlign="left">
			<uix:contentContainer background="light" width="100%">
				<uix:header textBinding="RBA_REMEDIES_HEADER@patchResourceBundle">
					<uix:stackLayout>
						<uix:styledText styleClass="OraInstructionText" textBinding="RBA_REMEDIES_INFO@patchResourceBundle"/>
						<uix:spacer height="6"/>
						<uix:styledText styleClass="OraInstructionText" textBinding="RBA_REMEDIES_POINTS@patchResourceBundle"/>
						<uix:bulletedList>
							<uix:styledText styleClass="OraInstructionText" textBinding="RBA_REMEDIES_POINT1@patchResourceBundle"/>
							<uix:styledText styleClass="OraInstructionText" textBinding="RBA_REMEDIES_POINT2@patchResourceBundle"/>
							<uix:styledText styleClass="OraInstructionText" textBinding="RBA_REMEDIES_POINT3@patchResourceBundle"/>
						</uix:bulletedList>
					</uix:stackLayout>
				</uix:header>
			</uix:contentContainer>
		</uix:cellFormat>
	</uix:rowLayout>
</uix:tableLayout>

<uix:tableLayout width="100%">
	<uix:rowLayout>
		<uix:contents>
			<uix:header textBinding="REMEDIES@patchResourceBundle">

<uix:hideShow	id="homes"
				disclosedBinding="showTable@advHomesBean@servletRequest" 
				undisclosedTextBinding="undisclosedText@advHomesBean@servletRequest" 
				disclosedTextBinding="HIDE_AFFECTED_HOMES@patchResourceBundle"
				partialRenderMode="self">
<uix:tableLayout width="60%">
	<uix:rowLayout>
		<uix:contents>
			<uix:header textBinding="HOMES_AFFECTED_BY_ADVISORY@patchResourceBundle">
				<uix:table 
				 name="advHomesTable"
				 id="advHomesTable"
				 width="100%"
				 summary="advHomesTable"
				 partialRenderMode="self"
				 showAll="yes"
				 valueBinding="currentValue@advHomesBean@servletRequest"
				 minValueBinding="minValue@advHomesBean@servletRequest"
				 blockSizeBinding="blockSize@advHomesBean@servletRequest"
				 maxValueBinding="maxValue@advHomesBean@servletRequest" 
				 alternateTextBinding="NO_AFFECTED_HOMES_FOUND@patchResourceBundle"
				 tableDataBinding="rows@advHomesBean@servletRequest"
				 columnHeaderDataBinding="columnHeaders@advHomesBean@servletRequest">
				  
				 <uix:tableSelection>
				   <uix:multipleSelection  selectionBinding="selectList@advHomesBean@servletRequest" shortDescBinding="SD_SELECT_LIST@patchResourceBundle" 
										   selectedBinding="selection">
					  <uix:submitButton name="event"
					                    textBinding="LBL_SHOW_REMEDIES@patchResourceBundle" 
										value="showRemediesForAdvHomes"/>
				   </uix:multipleSelection>
				 </uix:tableSelection>
				
				 <uix:tableFormat tableBanding="rowBanding"/>
				 
				 <uix:columnHeaderStamp>
				   <uix:sortableHeader 
					   textBinding="text"
					   sortableBinding="sortable">
				   </uix:sortableHeader>
				 </uix:columnHeaderStamp>
				
				 <uix:styledText textBinding="host" />
				 <uix:styledText textBinding="directory" />
				
				</uix:table>
			</uix:header>
	
	</uix:contents>
	</uix:rowLayout>
</uix:tableLayout>
</uix:hideShow>
<uix:spacer height="10"/>
<%--
<uix:tableLayout width="100%">
	<uix:rowLayout>
		<uix:contents>
			<uix:header text="Remedies">
--%>
				<uix:table	name="advHomesRemediesTable"
							id="advHomesRemediesTable"
							width="100%"
							summary="advHomesRemediesTable"
							partialRenderMode="self"
							showAll="yes"
							valueBinding="currentValue@advHomesRemediesBean@servletRequest"
							minValueBinding="minValue@advHomesRemediesBean@servletRequest"
							blockSizeBinding="blockSize@advHomesRemediesBean@servletRequest"
							maxValueBinding="maxValue@advHomesRemediesBean@servletRequest" 
							alternateTextBinding="NO_REMEDIES_FOUND@patchResourceBundle"
							tableDataBinding="rows@advHomesRemediesBean@servletRequest"
							columnHeaderDataBinding="columnHeaders@advHomesRemediesBean@servletRequest"
							detailDisclosureBinding="detailsState@advHomesRemediesBean@servletRequest"
							allDetailsEnabledBinding="allDetailsEnabled@servletRequest">
				  
				 <uix:tableSelection>
				   <uix:singleSelection selectedIndexBinding="index@advHomesRemediesBean@servletRequest" shortDescBinding="SD_SELECT_LIST@patchResourceBundle">
					  <uix:submitButton name="event"  
						textBinding="SHOW_REMEDY_DETAILS@patchResourceBundle" value="showRemedyDetails"/>
				   </uix:singleSelection>
				 </uix:tableSelection>
				
				 <uix:tableFormat tableBanding="rowBanding"/>
				 
				 <uix:columnHeaderStamp>
				   <uix:sortableHeader 
					   textBinding="text"
					   sortableBinding="sortable">
				   </uix:sortableHeader>
				 </uix:columnHeaderStamp>
				
				 <uix:column>
				 <uix:flowLayout> 
				 	<uix:styledText textBinding="patchset" destinationBinding="patchsetLink"/>
					<uix:switcher childNameBinding="isPatchSetValid">
						<uix:case name="no">
							<uix:messagePrompt messageType="info" />
						</uix:case>
					</uix:switcher>
				 </uix:flowLayout>
				 </uix:column>
				 
				 <uix:column>
				 <uix:flowLayout>
				 	<uix:contents childDataBinding="patches">
						<uix:styledText textBinding="patch" destinationBinding="patchDetailLink" />
						<uix:switcher childNameBinding="isValid">
							<uix:case name="no">
								<uix:messagePrompt messageType="info" />
							</uix:case>
						</uix:switcher>
						<uix:spacer width="10" />
					</uix:contents>
				</uix:flowLayout>
				</uix:column>
				 
				 <uix:styledText textBinding="platform" />
				 
				 <uix:column>
				 	<uix:flowLayout>
						<uix:styledText textBinding="count" />
						<uix:styledText text=" / " />
						<uix:styledText textBinding="selectedHomesCount@advHomesBean@servletRequest" />
					</uix:flowLayout>
				</uix:column>
				 
				 <uix:detail>
				 	<uix:header size="2" textBinding="AFFECTED_HOMES_TABLE_HEADER@patchResourceBundle">
					<uix:contents>
						<uix:tableLayout width="80%" cellSpacing="3">
							<uix:rowLayout>
								<uix:cellFormat hAlign="left" width="15%">
									<uix:styledText styleClass="OraDataText" textBinding="NAME@patchResourceBundle"/>
								</uix:cellFormat>
								<uix:cellFormat hAlign="left" width="35%">
									<uix:styledText styleClass="OraDataText" textBinding="LBL_SEARCH_HOST@patchResourceBundle"/>
								</uix:cellFormat>
								<uix:cellFormat hAlign="left" width="35%">
									<uix:styledText styleClass="OraDataText" textBinding="LBL_SEARCH_DIRECTORY@patchResourceBundle"/>
								</uix:cellFormat>
								<uix:cellFormat hAlign="left" width="15%">
									<uix:styledText styleClass="OraDataText" textBinding="LBL_SEARCH_VERSION@patchResourceBundle"/>
								</uix:cellFormat>
							</uix:rowLayout>
						</uix:tableLayout>
						<uix:tableLayout width="80%" cellSpacing="3">
							<uix:contents childDataBinding="affectedHomes">
								<uix:rowLayout>
									<uix:cellFormat hAlign="left" width="15%">
										<uix:styledText styleClass="OraInstructionText" textBinding="name"/>
									</uix:cellFormat>
									<uix:cellFormat hAlign="left" width="35%">
										<uix:styledText styleClass="OraInstructionText" textBinding="host"/>
									</uix:cellFormat>
									<uix:cellFormat hAlign="left" width="35%">
										<uix:styledText styleClass="OraInstructionText" textBinding="dir"/>
									</uix:cellFormat>
									<uix:cellFormat hAlign="left" width="15%">
										<uix:styledText styleClass="OraInstructionText" textBinding="ver"/>
									</uix:cellFormat>
								</uix:rowLayout>
							</uix:contents>
						</uix:tableLayout>
					</uix:contents>
					</uix:header>
				 </uix:detail>
				</uix:table>
				<uix:spacer height="10" />
				<uix:switcher childNameBinding="isTableValid@servletRequest">
				<uix:case name="no">
					<uix:tip styleClass="OraTipText">
						<uix:styledText styleClass="OraTipText" textBinding="VALIDATION_TIP_1@patchResourceBundle" />
						<uix:messagePrompt messageType="info" />
						<uix:styledText styleClass="OraTipText" textBinding="VALIDATION_TIP_2@patchResourceBundle" />
						<uix:link destination="../patchValidation$caller=remedy">
							<uix:styledText styleClass="OraTipText" textBinding="VALIDATION_TIP_3@patchResourceBundle" />
						</uix:link>
					</uix:tip>
					<%--
					<uix:link destination="../patchValidation$caller=remedy">
						<uix:tip styleClass="OraTipText" textBinding="TIP_NOT_VALID@patchResourceBundle"/>
					</uix:link>
					--%>
				</uix:case>
				</uix:switcher>
				<uix:spacer height="10" />
			</uix:header>
		</uix:contents>
	</uix:rowLayout>
</uix:tableLayout>

  </uix:form>
	</uix:subTabLayout>
	<uix:spacer height="6"/>
</uix:buildTree>

<%@ include file="cpftemplate.jspf" %>
