<%@ taglib uri= "http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:buildTree nodeID="timestamp" scope="request">
	<%@ include file="timestamp.jspf" %>
</uix:buildTree>

<uix:buildTree nodeID="pageContent" scope="request">
  <uix:form name="remediesHomesForm" destination="remediesAdvisories" method="get">
	<uix:script id="cpf_script" source="/em/ecm/patch/cpf/lov/cpf.js"/>
   	<noscript>""</noscript>
	 <uix:formValue name="contextPath" valueBinding="contextPath@servletRequest"/>
    <uix:formValue name="imagePath" valueBinding="imagePath@servletRequest"/>
    <uix:formValue name="event"/>

<uix:tableLayout width="100%" cellSpacing="6">
	<uix:rowLayout>
		<uix:cellFormat width="35%" hAlign="left" vAlign="top">
			<uix:stackLayout>
				<uix:contentContainer background="light" width="100%">
					<uix:flowLayout>
						<uix:styledText styleClass="OraInstructionText" textBinding="RBH_REMEDIES_ALERT@patchResourceBundle"/>
						<uix:formValue name="search_option" value="homes" />
						<uix:submitButton name="event" value="switchSearchBy" textBinding="RBH_REMEDIES_ALERT1@patchResourceBundle" />
					</uix:flowLayout>
				</uix:contentContainer>
				<uix:spacer height="18"/>
				<uix:messageLovField name="hostLov"
									 textBinding="hostLov@servletRequest"
									 columns="39"
									 promptBinding="LBL_SEARCH_HOST@patchResourceBundle"
									 shortDescBinding="LBL_SEARCH_HOST@patchResourceBundle"
									 searchDescBinding="LBL_SEARCH_HOST@patchResourceBundle"
									 onClick= "setHostRedirValue();
											   openWindow(top,
											   hostRedir.value,
											   'lovWindow',
											   {width:600, height:200},
											   true,
											   'dialog',
											   hostCallBack); " />
				<uix:messageLovField name="dirLov"
									 textBinding="dirLov@servletRequest"
									 columns="39"
									 promptBinding="LBL_SEARCH_DIRECTORY@patchResourceBundle"
									 shortDescBinding="LBL_SEARCH_DIRECTORY@patchResourceBundle"
									 onClick= " setDirRedirValue();
												openWindow(top,
												dirRedir.value,
												'lovWindow',
												{width:600, height:200},
												true,
												'dialog',
												dirCallBack); " />
				<uix:formValue name="hostRedir"/>
				<uix:formValue name="dirRedir"/>
				<uix:formValue name="hostLovPage" valueBinding="hostLovPage@cpfDefaultBean@servletRequest"/>
				<uix:formValue name="dirLovPage" valueBinding="dirLovPage@cpfDefaultBean@servletRequest"/>
				<uix:styledText styleClass="OraInstructionText" textBinding="HOMES_REMEDIES_SEARCH_MESSAGE@patchResourceBundle"/>
				<uix:spacer height="12"/>
				<uix:submitButton name="event" textBinding="LBL_SHOW_ALERTS@patchResourceBundle" value="getAlerts"/>
			</uix:stackLayout>
		</uix:cellFormat>
		<uix:cellFormat width="65%" hAlign="left">
			<uix:contentContainer background="light" width="100%">
				<uix:header textBinding="RBH_REMEDIES_HEADER@patchResourceBundle">
					<uix:stackLayout>
						<uix:styledText styleClass="OraInstructionText" textBinding="RBH_REMEDIES_INFO@patchResourceBundle"/>
						<uix:spacer height="6"/>
						<uix:styledText styleClass="OraInstructionText" textBinding="RBH_REMEDIES_POINTS@patchResourceBundle"/>
						<uix:bulletedList>
							<uix:styledText styleClass="OraInstructionText" textBinding="RBH_REMEDIES_POINT1@patchResourceBundle"/>
							<uix:styledText styleClass="OraInstructionText" textBinding="RBH_REMEDIES_POINT2@patchResourceBundle"/>
							<uix:styledText styleClass="OraInstructionText" textBinding="RBH_REMEDIES_POINT3@patchResourceBundle"/>
						</uix:bulletedList>
					</uix:stackLayout>
				</uix:header>
			</uix:contentContainer>
		</uix:cellFormat>
	</uix:rowLayout>
</uix:tableLayout>

</uix:form>
</uix:buildTree>
