<%--
  - FILE
  -   remedyDetails.jsp
  - 
  - DESCRIPTION
  -   jsp file for showing the details of a remedy
  -   Its controller must provide getPageHeader() method
  -   Its default bean must provide getSubTabSelIdx() method
  -
  - MODIFIED  (MM/DD/YY)
  - srukumar  04/17/07 - bugfix 5710435
  - somukher  07/09/05 - 
  - somukher  06/28/05 - Bug - 4442849 
  - pdasika   04/15/05 - Remove destinationBinding from table tags 
  - apbharga  10/13/04 - 
  - mningomb  09/22/04 - Adding taglib url to oem 
  - mningomb  09/20/04 - mningomb_final
  - apbharga  08/30/04 - providing link to patch validation page 
  - apbharga  08/26/04 - Patch Validation integration 
  - mningomb  08/02/04 - created
  -
  --%>

<%@ taglib uri= "http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

	<%@ include file="/oemNoscript.jspf" %>
<uix:buildTree nodeID="timestamp" scope="request">
  <%@ include file="timestamp.jspf" %>
</uix:buildTree>

<uix:buildTree nodeID="pageContent" scope="request">

	<uix:tableLayout>
		<uix:rowLayout>
			<uix:contents>
				<uix:spacer height="10"/>
			</uix:contents>
		</uix:rowLayout>
		<uix:rowLayout>
			<uix:breadCrumbs>
				<uix:contents>
					<uix:link textBinding="remedyText@servletRequest" destinationBinding="remedyLink@servletRequest"/>
					<uix:link textBinding="selectedRemedyText@servletRequest"/>
				</uix:contents>
			</uix:breadCrumbs>
		</uix:rowLayout>
		<uix:rowLayout>
			<uix:contents>
				<uix:spacer height="10"/>
			</uix:contents>
		</uix:rowLayout>
	</uix:tableLayout>
	
	<uix:form name="remedyDetails" method="get" destination="remedyDetails">
	<uix:header size="1" textBinding="REMEDY_DETAIL_HEADER@patchResourceBundle">
	<uix:tableLayout>
		<uix:rowLayout>
			<uix:contents>
				<uix:styledText styleClass="oraInstructionText" textBinding="REMEDY_DETAIL_MESSAGE@patchResourceBundle"/>
			</uix:contents>
		</uix:rowLayout>
		<uix:rowLayout>
			<uix:contents>
				<uix:spacer height="10"/>
			</uix:contents>
		</uix:rowLayout>
	</uix:tableLayout>
	</uix:header>
  
  <uix:header size="2"  textBinding="PATCH_DETAIL_HEADER@patchResourceBundle">
    <uix:table 
      name="remedy_detail_table"
      id="remedy_detail_table"
      width="60%"
      summary="remedy_detail_table"
      partialRenderMode="self"
      valueBinding="currentValue@remedyDetailsBean@servletRequest"
      minValueBinding="minValue@remedyDetailsBean@servletRequest"
      blockSizeBinding="blockSize@remedyDetailsBean@servletRequest"
      maxValueBinding="maxValue@remedyDetailsBean@servletRequest" 
      alternateTextBinding="NO_PATCHES_FOUND@patchResourceBundle"
      tableDataBinding="rows@remedyDetailsBean@servletRequest"
      columnHeaderDataBinding="columnHeaders@remedyDetailsBean@servletRequest">
       
      <uix:tableFormat tableBanding="rowBanding"/>
      <uix:columnHeaderStamp>
        <uix:sortableHeader 
            textBinding="text"
            sortableBinding="sortable">
        </uix:sortableHeader>
      </uix:columnHeaderStamp>

     <uix:tableSelection>
     <uix:singleSelection selectedIndexBinding="index@remedyDetailsBean@servletRequest" shortDescBinding="SD_SELECT_LIST@patchResourceBundle">
      <uix:submitButton name="event" formName="remedyDetails"
                    textBinding="APPLY_PATCH_LBL@patchResourceBundle"
                     value="applyPatch"/>
     </uix:singleSelection>
     </uix:tableSelection>

      <uix:column>
		 <uix:flowLayout>
		    <uix:styledText textBinding="patchNumber" destinationBinding="patchLink"/>
		 	<uix:switcher childNameBinding="isPatchValid">
				<uix:case name="false">
					<uix:messagePrompt messageType="info" vAlign="top" />
				</uix:case>
			</uix:switcher>
            <uix:formValue name="rowkey" valueBinding="rowkey"/>
         </uix:flowLayout>
      </uix:column>
     <uix:styledText textBinding="patchType"/>
    </uix:table>
	<uix:spacer height="10" />
	<uix:switcher childNameBinding="isRemedyValid@servletRequest">
		<uix:case name="false">
		    <uix:tip styleClass="OraTipText">
						<uix:styledText styleClass="OraTipText" textBinding="VALIDATION_TIP_1@patchResourceBundle" />
						<uix:messagePrompt messageType="info" />
						<uix:styledText styleClass="OraTipText" textBinding="VALIDATION_TIP_2@patchResourceBundle" />
						<uix:link destination="../patchValidation$caller=remedy">
							<uix:styledText styleClass="OraTipText" textBinding="VALIDATION_TIP_3@patchResourceBundle" />
						</uix:link>
			</uix:tip>
		</uix:case>
	</uix:switcher>
	<uix:spacer height="20" />
  </uix:header>

  <uix:header size="2" textBinding="ORACLE_HOMES_HEADER_LBL@patchResourceBundle">
    <uix:table 
      name="oracle_homes_table"
      id="oracle_homes_table"
      width="80%"
      summary="oracle_homes_table"
      partialRenderMode="self"
      valueBinding="currentValue@oracleHomesBean@servletRequest"
      minValueBinding="minValue@oracleHomesBean@servletRequest"
      blockSizeBinding="blockSize@oracleHomesBean@servletRequest"
      maxValueBinding="maxValue@oracleHomesBean@servletRequest" 
      alternateTextBinding="NO_HOMES_FOUND@patchResourceBundle"
      tableDataBinding="rows@oracleHomesBean@servletRequest"
      columnHeaderDataBinding="columnHeaders@oracleHomesBean@servletRequest">
       
      <uix:tableFormat tableBanding="rowBanding"/>
      <uix:columnHeaderStamp>
        <uix:sortableHeader 
            textBinding="text"
            sortableBinding="sortable">
        </uix:sortableHeader>
      </uix:columnHeaderStamp>

     <uix:tableSelection>
     <uix:multipleSelection selectionBinding="selectList@oracleHomesBean@servletRequest"
                            selectedBinding="selection"
			    shortDescBinding="SD_SELECT_LIST@patchResourceBundle"	>
      <uix:submitButton name="event" formName="remedyDetails" 
             textBinding="APPLY_PATCH_LBL@patchResourceBundle" value="applyPatch"/>
     </uix:multipleSelection>
     </uix:tableSelection>

     <uix:styledText textBinding="host" />
     <uix:styledText textBinding="directory" />

    </uix:table>
	<uix:spacer height="10" />
  </uix:header>

</uix:form>
</uix:buildTree>

<%@ include file="cpftemplate2.jspf" %>

