<%--
 * Copyright (c) 2003, 2006, Oracle. All rights reserved.  
 *
 * NAME
 *   patchSummary.jsp
 *
 * NOTES
 *   result page of patch wizard.
 *
 * MODIFIED
 *    hmodawel   03/06/06 - fix compilation, 
 *    pdasika    06/10/05 - removing show all option 
 *    kchiasso   06/27/03 - kchiasso_patchsummary_updates
 *    kchiasso   06/27/03 - 
 *    kchiasso   06/16/2003 - Creation
--%>

<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:dataScope>
  <uix:bundle name="patchResourceBundle"
              class="oracle.sysman.eml.ecm.patch.util.PatchResourceBundle"/>
 
    <uix:contents>
    <uix:switcher childNameBinding="status@patchSummaryBean@servletRequest">
    <uix:case name="success">

      <uix:stackLayout>
       <uix:header
         textBinding="tableHdr@patchSummaryBean@servletRequest">

        <uix:tableLayout width="100%">
        <uix:rowLayout> 
        
                      <uix:table name="stageResultsTable"
                            id="summaryid"
                            partialRenderMode="self"
                            width="100%"
                            formSubmitted="true"
                            alternateTextBinding="SUM_TBLALT@patchResourceBundle@servletRequest"
                            columnHeaderDataBinding="columnHeaders@patchSummaryBean@servletRequest"                  
                            blockSizeBinding="blockSize@servletRequest"
                            maxValueBinding="maxValue@servletRequest"
                            valueBinding="value@servletRequest"
                            minValue="1"
                            showAll="no"
                            summary="SUMMARY_STAGERESULTSTABLE@patchResourceBundle"
                            tableDataBinding="rows@tableResultsData@patchSummaryBean@servletRequest">
                          <uix:tableFormat tableBanding="rowBanding"/>

                          <uix:columnHeaderStamp>
                            <uix:sortableHeader textBinding="text" 
                                                sortableBinding="sortable"/>
                          </uix:columnHeaderStamp>

                          <uix:contents>
                           <uix:styledText textBinding="stageLoc"/>
                           <uix:styledText textBinding="hostName"/>

                           <uix:dataScope renderedBinding="renderDBTargets@patchSummaryBean@servletRequest">
                            <uix:contents>
                              <uix:styledText textBinding="addTargets"/>
                            </uix:contents>
                           </uix:dataScope>

                           <uix:dataScope renderedBinding="renderListeners@patchSummaryBean@servletRequest">
                            <uix:contents>
                              <uix:styledText textBinding="addListeners"/>
                            </uix:contents>
                           </uix:dataScope>

                           <uix:dataScope rendered="true">
                            <uix:contents>
                              <uix:image sourceBinding="severityImage"/>
                              <uix:spacer width="3"/>
                              <uix:styledText textBinding="sevStatus"/>
                            </uix:contents>
                           </uix:dataScope>

                           <uix:image sourceBinding="telnetImage" destinationBinding="telnetDest"/>
                           </uix:contents>

                       </uix:table>

        </uix:rowLayout>
        </uix:tableLayout>

       </uix:header>
      </uix:stackLayout>

    </uix:case>

    <uix:case name="failure">
      <uix:messageBox messageBinding="errMsg@patchSummaryBean@servletRequest"
                      messageType="error"
                      shortDescBinding="ERR_OCCUR@patchResourceBundle"
                      textBinding="errHdr@patchSummaryBean@servletRequest">
      </uix:messageBox>
    </uix:case>
  </uix:switcher>


</uix:contents>
</uix:dataScope>
