<%--
  -- Page:        policyAddPolicies.jsp
  -- Controller:  oracle.sysman.eml.ecm.jsp.PolicyAddPoliciesController
  --
  -- Description: Launched when user selects "Add Poicies" action
  --
  --  MODIFIED    (MM/DD/YY)
  --   kchiasso    07/21/05 - add btn sd
  --   kchiasso    05/02/05 - render tip
  --   kchiasso    04/27/05 - button name continue
  --   kchiasso    04/20/05 - save ipmsg context
  --   kchiasso    04/07/05 - render multisel tip
  --   kchiasso    02/17/05 - render desc img
  --   kchiasso    01/25/05 - render context info
  --   kchiasso    01/11/05 - preserve targetname
  --   kchiasso    01/07/05 - shortdesc
  --   kchiasso    12/29/04 - set prompt target type 
  --   kchiasso    12/08/04 - set pagestatus context
  --   kchiasso    12/06/04 - incl msgHeader 
  --   kchiasso    11/22/04 - msgboxes
  --   kchiasso    10/29/04 - add instr
  --   kchiasso    10/27/04 - remove separator 
  --   kchiasso    10/22/04 - confirm add
  --   kchiasso    10/19/04 - set pageHeader and title
  --   kchiasso    10/06/04 - multisel
  --   kchiasso    10/05/04 - ppr; showall
  --   kchiasso    09/24/04 - hidden params
  --   kchiasso    09/09/04 - hide guid
  --   kchiasso    09/06/04 - kchiasso_policyeditsettings
  --   kchiasso    08/24/04 - Creation
  --%>
  <%@ page contentType="text/html; charset=UTF-8"%>
  <%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
  <%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
  <%-- Imports --%>
  <%@ page import="oracle.sysman.eml.ecm.policy.PolicyJspConstants"%>
  <%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
  <uix:renderingContext id="renderingContext">
    
    <oem:setURLEncoder id="renderingContext"/>
    
    <uix:bundle name="policyBundle" class="oracle.sysman.eml.ecm.policy.util.PolicyJspMsg"/>
    <uix:document>
      <%@ include file="/oemTitle.jspf"%>
      <%@ include file="/enablePPR.jspf"%>
         
     <uix:body>
     <uix:dataScope currentDataBinding="policyAddPoliciesJspBean@servletRequest">
      <uix:form nameBinding="eml_ecm_sc_formName@servletRequest" method="post">
    
<%-- unique identifier for this page --%>  
        <uix:formValue name="ipContext" valueBinding="ipContext@@policyAddPoliciesJspBean@servletRequest"/>
        <uix:pageLayout 
              titleBinding="pageTitle@policyAddPoliciesJspBean@servletRequest">
          
        <%@ include file="msgHeader.jspf" %>
<%--
  -- include the setup subtabs if in setup
  <uix:styledText text="<%= \"inSetup=\" + request.getAttribute(\"inSetup\") %>"/>
--%>
          <%
            String inSetup =  (String)request.getAttribute("inSetup"); 
            if(inSetup != null && inSetup.equals("true"))
             {
          %>
        			<%@ include file="../../health/header.jsp" %>
          <%
             }
          %>
  
           <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="5%" columns="2" width="100%">
                <uix:messageStyledText
                    renderedBinding="renderTarget@policyAddPoliciesJspBean@servletRequest"
                    contentStyleClass="OraDataText"
                    promptBinding="LBL_TARGETNAME@policyBundle"
                    textBinding="targetName@policyAddPoliciesJspBean@servletRequest"/>
                <uix:messageStyledText
                    renderedBinding="renderTemplate@policyAddPoliciesJspBean@servletRequest"
                    contentStyleClass="OraDataText"
                    promptBinding="LBL_TEMPLATE@policyBundle"
                    textBinding="templateName@policyAddPoliciesJspBean@servletRequest"/>
                <uix:messageStyledText
                    contentStyleClass="OraDataText"
                    promptBinding="LBL_TARGETTYPE@policyBundle"
                    textBinding="typeDisplay@policyAddPoliciesJspBean@servletRequest"/>
               </uix:labeledFieldLayout>
          </uix:pageStatus>


          <uix:tableLayout width="100%">            
            <uix:rowLayout>
              <uix:separator/>
            </uix:rowLayout>            
            <uix:rowLayout>
                <uix:styledText styleClass="OraInstructionText"
                                textBinding="INSTR_ADDPOLICIES@policyBundle"/>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:spacer height="15"/>
            </uix:rowLayout>
          </uix:tableLayout>

          <uix:include nodeBinding="eml_ecm_sc_uiNode@servletRequest"/>
                 
            <uix:stackLayout>            
                     
              <uix:table 
                width="100%"
                formSubmitted="true"
                name="policyAddPoliciesList"
                id="policyAddPoliciesList"
                partialTargets="pptip"
                partialRenderMode="multiple"
                showAll="yes"
                tableDataBinding="<%=UIXDataSource.S_ROW_DATA_ATTR%>"
                valueBinding="<%=UIXDataSource.S_START_INDEX_ATTR%>"
                maxValueBinding="<%=UIXDataSource.S_NUM_ROWS_ATTR%>"
                blockSizeBinding="<%=UIXDataSource.S_BLOCK_SIZE_ATTR%>"
                alternateTextBinding="NO_RESULTS_FOUND@policyBundle"
                summaryBinding="TBLSUM_RESULTSTABLE@policyBundle">

                <uix:tableFormat tableBanding="rowBanding"/>
 
                <uix:tableSelection>
                  <uix:multipleSelection
                    selectedBinding="selected"
                    shortDescBinding="MLTSEL_RESULTSTABLE@policyBundle"
                    selectionBinding="selection@policyAddPoliciesJspBean@servletRequest">
                  </uix:multipleSelection>
                </uix:tableSelection>       
                 
                  <%-- Policy Rule column --%>
                  <uix:column> 
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_POLICYRULE@policyBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_POLICYRULE %>" />
                    </uix:columnHeader> 
                    <uix:columnFormat columnDataFormat="textFormat"/>
                  <uix:link name="<%= PolicyJspConstants.S_LBL_POLICYRULE %>"
                            textBinding="<%= PolicyJspConstants.S_LBL_POLICYRULE %>"
                            destinationBinding="<%= PolicyJspConstants.S_DEST_POLICYRULE  %>" />
                  </uix:column>                 
                  
                   <%-- Severity column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_SEVERITY@policyBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_SEVERITY %>"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="<%= PolicyJspConstants.S_LBL_SEVERITY %>"/>
                  </uix:column>
                  
                  <%-- Category column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_CATEGORY@policyBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_CATEGORY %>"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="<%= PolicyJspConstants.S_LBL_CATEGORY %>"/>
                  </uix:column>
                  
               
                 <%-- Description column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_DESCRIPTION@policyBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_DESCRIPTION %>"/>
                    </uix:columnHeader>
                    <uix:columnFormat width="10" cellNoWrapFormat="false" columnDataFormat="textFormat"/>
                  <uix:styledList>
                    <uix:styledText textBinding="<%= PolicyJspConstants.S_LBL_DESCRIPTION %>"/>
                    <uix:spacer width="3" />
                    <uix:image renderedBinding = "<%= PolicyJspConstants.S_RENDER_HELPICON %>"
                               sourceBinding="<%= PolicyJspConstants.S_IMG_INFORMATION %>" 
                               shortDescBinding="SHORTDESC_HELPICON@policyBundle"
                               destinationBinding="<%= PolicyJspConstants.S_HELP_DESCRIPTION %>"/>
                  </uix:styledList>
                  </uix:column>
                                    
                  <%-- Disabled column --%>
                  <uix:column renderedBinding="<%= PolicyJspConstants.S_RENDER_DISABLED %>"> 
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_DISABLED@@policyBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_DISABLED %>" />
                    </uix:columnHeader> 
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="<%= PolicyJspConstants.S_LBL_DISABLED %>"/>
                   <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                    <uix:image sourceBinding="<%= PolicyJspConstants.S_IMG_DISABLED %>" 
                             shortDescBinding="SHORTDESC_POLICYDISABLED@policyBundle"
                             destinationBinding="<%= PolicyJspConstants.S_LBL_DISABLED %>"/>
                  </uix:column>
                  
                  <%-- Hidden policy guid --%>
                  <formValue name="policyGuid"
                             valueBinding = "<%= PolicyJspConstants.S_HIDDEN_POLICYGUID %>" />

                  <%-- Hidden object guid --%>
                  <formValue name="objectGuid"
                             valueBinding = "<%= PolicyJspConstants.S_HIDDEN_OBJECTGUID %>" />

                  <%-- Hidden object type --%>
                  <formValue name="objectType"
                             valueBinding = "<%= PolicyJspConstants.S_HIDDEN_OBJECTTYPE %>" />

                  <%-- Hidden targetName if search by target --%>
                  <formValue name="searchTargetName"
                             valueBinding = "<%= PolicyJspConstants.S_HIDDEN_TARGETNAME %>" />

                 </uix:table>
 
                 <uix:styledText id="pptip" styleClass="OraTipLabel"
                        textBinding = "<%= PolicyJspConstants.S_TIP_MULTISEL %>" />

              </uix:stackLayout>
              
          <%-------------------------
           -  Page Buttons
           ---------------------------%>
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button textBinding="BTN_CANCEL@policyBundle" 
                          destinationBinding="<%= PolicyJspConstants.S_DEST_CANCELURL %>"
                          shortDescBinding="BTN_CANCEL@policyBundle"/>
                           
              <uix:submitButton textBinding="BTN_CONTINUE@policyBundle" 
                                shortDescBinding="BTN_CONTINUE@policyBundle"
                                name="event" value="doConfirmAdd" />                          

            </uix:pageButtonBar>
          </uix:pageButtons>
               
            </uix:pageLayout>
         </uix:form>
        </uix:dataScope>              
      </uix:body>
    </uix:document>
  </uix:renderingContext>
  </body>
</html>
