<%--
  -- Page:        policyAssociations.jsp
  -- Controller:  oracle.sysman.eml.ecm.jsp.PolicyAssocController
  --
  -- Description: Launched when user selects "search" action
  --
  --  MODIFIED    (MM/DD/YY)
  --   sthiruna    08/01/06 - Copying 10.2.0.3 Config Standard changes from
  --                          EMCORE_MAIN_LINUX
  --   kchiasso    02/10/06 - rmv PageStatus
  --   kchiasso    01/11/06 - new subtabs
  --   kchiasso    07/21/05 - add btn sd
  --   kchiasso    06/09/05 - shortdesc
  --   kchiasso    02/17/05 - render desc img
  --   groyal      02/04/05 - Change policyMsgBundle to msgBundle
  --   kchiasso    01/24/05 - add table tip
  --   kchiasso    01/18/05 - combine severity and date
  --   kchiasso    01/07/05 - shortdesc
  --   kchiasso    01/05/05 - 'post' req'd as of 2.2.15 upgrade
  --   kchiasso    12/22/04 - set hidden guid / get for bookmarking
  --   kchiasso    12/06/04 - incl msgHeader 
  --   kchiasso    11/22/04 - hdr; alttext
  --   akskumar    11/24/04 - licensing work, disable links on rows 
  --   kchiasso    11/22/04 - init selidx 0
  --   kchiasso    11/08/04 - remove edit column
  --   kchiasso    10/27/04 - remove separator 
  --   kchiasso    10/20/04 - add confirm msg
  --   kchiasso    10/05/04 - ppr; showall
  --   groyal      09/23/04 - Change order of columns; make severity an icon
  --   groyal      09/22/04 - Add refreshed 
  --   groyal      09/21/04 - Add separator
  --   kchiasso    09/16/04 - add editSettings column
  --   groyal      08/18/04 - Remove reference to PolicyMsg 
  --   groyal      08/06/04 - groyal_pv_0804
  --   groyal      08/04/04 - Creation
  --%>
  <%@ page contentType="text/html; charset=UTF-8"%>
  <%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
  <%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
  <%-- Imports --%>
  <%@ page import="oracle.sysman.eml.ecm.policy.PolicyJspConstants"%>
  <%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
  <uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/>
    <uix:bundle name="msgBundle" class="oracle.sysman.eml.ecm.policy.util.PolicyJspMsg"/>
    <uix:document>
      <%@ include file="/oemTitle.jspf"%>
      <%@ include file="/enablePPR.jspf"%>
     
    	<uix:body>
        <uix:pageLayout titleBinding="PAGE_TITLE_ASSOC@msgBundle">
        <%@ include file="msgHeader.jspf" %>

         <uix:dataScope currentDataBinding="policyAssocJspBean@servletRequest">

         <uix:subTabLayout>
          <uix:subTabs>
              <uix:subTabBar selectedIndex="2">
              <uix:contents>
                   <uix:link textBinding="TAB_VIOLATIONS@msgBundle"
                              destinationBinding="<%= PolicyJspConstants.S_TAB_VIOLATIONS %>" />
                   <uix:link textBinding="TAB_LIBRARY@msgBundle"
                              destinationBinding="<%= PolicyJspConstants.S_TAB_LIBRARY %>" />
                   <uix:link textBinding="TAB_ASSOCIATIONS@msgBundle"
                              destinationBinding="<%= PolicyJspConstants.S_TAB_ASSOCIATIONS %>" />
                   <uix:link textBinding="TAB_ERRORS@msgBundle"
                              destinationBinding="<%= PolicyJspConstants.S_TAB_ERRORS %>" />
                  </uix:contents>
              </uix:subTabBar>
          </uix:subTabs>
          <uix:contents>

        <uix:form nameBinding="eml_ecm_sc_formName@servletRequest" 
                    method="post"> 

                <uix:tableLayout width="100%">
                 <uix:contents>                     
                  <uix:cellFormat width="60%">
                   <uix:rowLayout>
                    <uix:styledText styleClass="OraInstructionText" textBinding="INSTR_SEARCH_ASSOC@msgBundle"/>
                   </uix:rowLayout>
                  </uix:cellFormat>
                  <uix:cellFormat width="40%" vAlign="top">
                   <uix:rowLayout hAlign="right">
                    <oem:pageRefreshed/>
                   </uix:rowLayout>
                  </uix:cellFormat> 
                 </uix:contents>
                </uix:tableLayout>
  
              <uix:stackLayout>
                  <uix:spacer/>
              </uix:stackLayout>
 
              <uix:include nodeBinding="eml_ecm_sc_uiNode@servletRequest"/>
                                
              <uix:stackLayout>
                <uix:spacer height="10"/>
                <uix:table name="PolicyAssocList" 
                           id = "PolicyAssocList"
                           partialRenderMode="self"
                           showAll="yes"
                           formSubmitted="true" 
                           width="100%" 
                           minValue="1" 
                           tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                           valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                           maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                           blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                           alternateTextBinding="<%= PolicyJspConstants.S_ALT_TEXT_ATTR %>"
                           summaryBinding="TBLSUM_RESULTSTABLE@msgBundle">
                  <uix:tableFormat tableBanding="rowBanding"/>

                  <uix:tableSelection>
                    <uix:singleSelection selectedIndex="0">
			              <uix:contents>
                      <uix:submitButton textBinding="BTN_MANAGESETTINGS@msgBundle" 
                                        shortDescBinding="BTN_MANAGESETTINGS@msgBundle"
                                        name="event" value="doManageSettings" />                          
                    </uix:contents>
                  </uix:singleSelection>
                  </uix:tableSelection>       
                   
                  <%-- Target column --%>
                  <uix:column> 
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_TARGET@msgBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_TARGET %>" />
                    </uix:columnHeader> 
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:link textBinding="<%= PolicyJspConstants.S_LBL_TARGET %>"
                              destinationBinding="<%= PolicyJspConstants.S_DEST_TARGET %>" />
                  </uix:column>

                  <%-- Type column --%>
                  <uix:column> 
                    <uix:columnHeader>
                     <uix:sortableHeader textBinding="LBL_TYPE@msgBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_TYPE %>" />
                    </uix:columnHeader> 
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="<%= PolicyJspConstants.S_LBL_TYPE %>"/>
                  </uix:column>

                  <%-- Policy Rule column --%>
                  <uix:column> 
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_POLICYRULE@msgBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_POLICYRULE %>" />
                    </uix:columnHeader> 
                    <uix:columnFormat columnDataFormat="textFormat"/>
                  <oem:license>
                      <uix:link textBinding="<%= PolicyJspConstants.S_LBL_POLICYRULE %>"
                                destinationBinding="<%= PolicyJspConstants.S_DEST_POLICYRULE  %>" />
                  </oem:license>
                  </uix:column>                 
                  

              <%-- Last Evaluation group column --%>
              <uix:columnGroup>
              
                <uix:columnHeader>
                  <uix:sortableHeader 
                  textBinding="LBL_LASTEVAL@msgBundle"/>
                </uix:columnHeader>
              
                <uix:contents>             
                  <%-- Severity column --%>
                  <uix:column useSeparateRows="true">
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="LBL_SEVERITY@msgBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_SEVERITY %>" />
                  </uix:columnHeader> 
                 <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                  <uix:image sourceBinding="<%= PolicyJspConstants.S_IMG_SEVERITY %>" 
                             shortDescBinding="<%= PolicyJspConstants.S_SHORT_SEVERITY %>"/>
                  </uix:column>
  
                  <%-- Timestamp column --%>
                  <uix:column> 
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="EXEMPT_DATE@msgBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_LASTEVAL %>" />
                    </uix:columnHeader> 
                    <uix:columnFormat columnDataFormat="dateFormat"/>
                    <uix:styledText textBinding="<%= PolicyJspConstants.S_LBL_LASTEVAL %>"/>
                  </uix:column>
                </uix:contents>
                
                </uix:columnGroup>
            
            
                  <%-- Category column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_CATEGORY@msgBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_CATEGORY %>"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="<%= PolicyJspConstants.S_LBL_CATEGORY %>"/>
                  </uix:column>
                                  
                 <%-- Description column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_DESCRIPTION@msgBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_DESCRIPTION %>"/>
                    </uix:columnHeader>
                    <uix:columnFormat width="10" cellNoWrapFormat="false" columnDataFormat="textFormat"/>
                  <uix:styledList>
                    <uix:styledText textBinding="<%= PolicyJspConstants.S_LBL_DESCRIPTION %>"/>
                    <uix:spacer width="3" />
                    <uix:image renderedBinding = "<%= PolicyJspConstants.S_RENDER_HELPICON %>"
                               sourceBinding="<%= PolicyJspConstants.S_IMG_INFORMATION %>" 
                               shortDescBinding="SHORTDESC_HELPICON@msgBundle"
                               destinationBinding="<%= PolicyJspConstants.S_HELP_DESCRIPTION %>"/>
                  </uix:styledList>
                  </uix:column>
                              
                  <%-- Disabled column --%>
                  <uix:column> 
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_DISABLED@@msgBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_DISABLED %>" />
                    </uix:columnHeader> 
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="<%= PolicyJspConstants.S_LBL_DISABLED %>"/>
                   <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                    <uix:image sourceBinding="<%= PolicyJspConstants.S_IMG_DISABLED %>" 
                               shortDescBinding="SHORTDESC_POLICYDISABLED@msgBundle"
                               destinationBinding="<%= PolicyJspConstants.S_LBL_DISABLED %>"/>
                  </uix:column>
  
                  <uix:formValue id="policyGuid" name="policyGuid" 
                                 valueBinding="<%= PolicyJspConstants.S_HIDDEN_POLICYGUID %>"/>
  
                 </uix:table>
                 
                 <uix:tip textBinding="TIP_SEARCH_ASSOC@msgBundle"/>

              </uix:stackLayout>


          <%------------------------
           -  Related Links
           ------------------------%>

          <uix:header 
            textBinding="RELATED_LINK@msgBundle">         

          <uix:tableLayout>

            <uix:rowLayout>
              <%---  Edit Policy Settings  ---%>
              <uix:cellFormat hAlign="left">
                  <uix:link textBinding="LBL_SETUPMONITORINGTEMPLATES@msgBundle" 
                            destinationBinding="<%= PolicyJspConstants.S_DEST_USEDINTEMPLATES %>"/>
              </uix:cellFormat>
            </uix:rowLayout>     
            
          </uix:tableLayout> 
          
          </uix:header>         

              
          <%-------------------------
           -  Page Buttons
           ---------------------------%>
          <uix:pageButtons>
            <uix:pageButtonBar>

            </uix:pageButtonBar>
          </uix:pageButtons>
 
          </uix:form>
             
           </uix:contents>
          </uix:subTabLayout>
           
        </uix:dataScope>       
      </uix:pageLayout>

      </uix:body>

   </uix:document>
  </uix:renderingContext>
<%------------------------------  End of File  -------------------------------%>
