<%--
  -- Page:        policyConfirmation.jsp
  -- Controller:  oracle.sysman.eml.ecm.policy.PolicyRemoveConfirmationController
  --
  -- Description: Launched when user selects "remove" action from policiesSegment
  --              Launched when user selects "addPolicies" action from policyAddPolicies
  --
  --  MODIFIED    (MM/DD/YY)
  --   kchiasso    07/21/05 - add btn sd
  --   kchiasso    06/10/05 - incl oem
  --   groyal      02/04/05 - Change policyMsgBundle to msgBundle
  --   kchiasso    11/22/04 - hdr
  --   kchiasso    10/25/04 - kchiasso_policyaddremoveconfirm
  --   kchiasso    10/20/04 - Creation
--%>
<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/>
    <uix:bundle name="msgBundle" 
                class="oracle.sysman.eml.ecm.policy.util.PolicyJspMsg"/>
    <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/oemNoscript.jspf" %>     
   
     <uix:body>
     <uix:form name="policyConfirmation" method="GET" destination="/em/console/ecm/policy/policyConfirmation">

        <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf"%>

            <uix:stackLayout>
              <uix:header iconBinding="confirmIcon@policyRemoveConfirmationJspBean@servletRequest" 
                          textBinding="HDR_CONFIRMATION@msgBundle">

                <uix:contents>
                  <uix:rowLayout>
                    <uix:spacer width="10"/>
                    <uix:styledText textBinding="confirmMsg@policyRemoveConfirmationJspBean@servletRequest" 
                                   styleClass="OraInstructionTextStrong"/>
                  </uix:rowLayout>
                  <uix:spacer height="10"/>
                  <uix:rowLayout>
                    <uix:spacer width="10"/>
                    <uix:styledText textBinding="confirmInstr@policyRemoveConfirmationJspBean@servletRequest" styleClass="OraInstructionText"/>
                  </uix:rowLayout>
                </uix:contents>

              </uix:header>
            </uix:stackLayout>
          
          <%-------------------------
           -  Page Buttons
           ---------------------------%>
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="BTN_NO@msgBundle"
                                shortDescBinding="BTN_NO@msgBundle"
                                name="event" value="cancel"/>
              <uix:submitButton textBinding="BTN_YES@msgBundle" 
                                shortDescBinding="BTN_YES@msgBundle"
                                name="event" value="accept"/>
 
            </uix:pageButtonBar>
          </uix:pageButtons>
            
            
        
        </uix:pageLayout>

     </uix:form>
     </uix:body>
    </uix:document>
</uix:renderingContext>
