<%--
  -- Page:        policyEditSettings.jsp
  -- Controller:  oracle.sysman.eml.ecm.policy.PolicyEditSettingsController
  --
  --  MODIFIED    (MM/DD/YY)
  --   ramalhot    03/07/06 - 
  --   kchiasso    07/21/05 - add btn sd
  --   jaysmith    06/22/05 - remove droplist 
  --   kchiasso    03/02/05 - enforce to eval
  --   kchiasso    02/17/05 - render desc img
  --   kchiasso    01/21/05 - add ok button support; header outside table;
  --   groyal      01/20/05 - UI Exit review comments 
  --   kchiasso    01/14/05 - template or target context
  --   kchiasso    01/07/05 - shortdesc
  --   kchiasso    12/30/04 - done render template override in setup
  --   kchiasso    12/29/04 - set prompt target type 
  --   kchiasso    12/09/04 - rmv ok button
  --   kchiasso    12/03/04 - add pageStatus
  --   kchiasso    11/22/04 - hdr
  --   kchiasso    11/10/04 - add render 
  --   kchiasso    11/01/04 - add CA
  --   kchiasso    10/08/04 - set values
  --   kchiasso    10/04/04 - template override
  --   kchiasso    09/29/04 - apply event
  --   kchiasso    09/22/04 - add import
  --   kchiasso    09/16/04 - set names for input data
  --   djoly       09/09/04 - 
  --   kchiasso    09/06/04 - kchiasso_policyeditsettings
  --   kchiasso    06/18/04 - Creation
--%>
  <%@ page contentType="text/html; charset=UTF-8"%>
  <%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
  <%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<script language="javascript">
function submitChoice()
{
  // if false cancel the submit
  doSubmit = true;
  choiceList = document.forms[0].policyCAChoice;
  selChoice = choiceList.options[choiceList.selectedIndex].value;
  
  if (selChoice == "noAction")
  {
    alert(document.forms[0].messageSelectChoice.value);
    doSubmit = false;
  }  
  return doSubmit;
}

</script>

  <%-- Imports --%>
  <%@ page import="oracle.sysman.eml.ecm.policy.PolicyJspConstants" %>
  <%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>

  <uix:renderingContext id="renderingContext">   
    <oem:setURLEncoder id="renderingContext"/>
    <uix:bundle name="mntrResourceBundle"
                class="oracle.sysman.resources.MntrResourceBundle"/>
    <uix:bundle name="policyJspBundle" 
                class="oracle.sysman.eml.ecm.policy.util.PolicyJspMsg" />
    <uix:bundle name="sdkUIMsg"
                class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
    <uix:bundle name="jobsResource"
              class="oracle.sysman.resources.eml.jobs.JobsResource"/>

    <uix:document>
      <%@ include file="/oemTitle.jspf"%>
      <%-- used in parametersTableEdit and exclusionsTableEdit --%>
      <%@ include file="/enablePPR.jspf"%>
      
      <uix:body>
 
       <oem:form 
        copyParams="target,type,cancelURL,oname,otype"
        name="policyEditSettingsForm" 
        method="post"
        destination="/console/ecm/policy/policyEditSettings">
  
        <uix:formValue 
          name="pageName" 
          value="/ecm/policy/policyEditSettings"/>

        <uix:formValue 
          name="messageSelectChoice" 
          valueBinding="MESSAGESELECTCHOICE@policyJspBundle"/>
          
        <uix:pageLayout
          titleBinding="title@policyEditSettingsJspBean@servletRequest">

          <%@ include file="msgHeader.jspf" %>
<%--
  -- include the setup subtabs if in setup
  <uix:styledText text="<%= \"inSetup=\" + request.getAttribute(\"inSetup\") %>"/>
--%>
          <%
            String inSetup =  (String)request.getAttribute("inSetup"); 
            if(inSetup != null && inSetup.equals("true"))
             {
          %>
        			<%@ include file="../../health/header.jsp" %>
          <%
             }
          %>
   
           <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="5%" columns="2" width="100%">
                <uix:messageStyledText
                    renderedBinding="renderTarget@policyEditSettingsJspBean@servletRequest"
                    contentStyleClass="OraDataText"
                    promptBinding="LBL_TARGETNAME@policyJspBundle"
                    textBinding="targetName@policyEditSettingsJspBean@servletRequest"/>
                <uix:messageStyledText
                    renderedBinding="renderTemplate@policyEditSettingsJspBean@servletRequest"
                    contentStyleClass="OraDataText"
                    promptBinding="LBL_TEMPLATE@policyJspBundle"
                    textBinding="templateName@policyEditSettingsJspBean@servletRequest"/>
                <uix:messageStyledText
                    contentStyleClass="OraDataText"
                    promptBinding="LBL_TARGETTYPE@policyJspBundle"
                    textBinding="typeDisplay@policyEditSettingsJspBean@servletRequest"/>
               </uix:labeledFieldLayout>
          </uix:pageStatus>

         <uix:tableLayout width="100%">            
            <uix:rowLayout>
              <uix:separator/>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:spacer height="15"/>
            </uix:rowLayout>
          </uix:tableLayout>


            
  <uix:tableLayout>
  <uix:contents>

     <uix:cellFormat vAlign="top">
      <uix:contents>

        <uix:tableLayout >
       
            <%------------------------
             -  Category
             ------------------------%>
            <uix:rowLayout>
              <%---  Prompt  ---%>
              <uix:cellFormat width="144" hAlign="right" wrappingDisabled="true">
                <uix:styledText
                  styleClass="OraPromptText"
                  textBinding="LBL_CATEGORY@policyJspBundle" />
              </uix:cellFormat>

              <%---  Field  ---%>
              <uix:spacer width="8"/>
              <uix:cellFormat>
                <uix:styledText
                  styleClass="OraDataText"
                  textBinding="categoryName@policyEditSettingsJspBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>

            <%------------------------
             -  Description
             ------------------------%>
            <uix:rowLayout>
              <%---  Prompt  ---%>
              <uix:cellFormat width="144" hAlign="right" wrappingDisabled="true">
                <uix:styledText styleClass="OraPromptText"
                                textBinding="LBL_DESCRIPTION@policyJspBundle" />
              </uix:cellFormat>

              <%---  Field  ---%>
             <uix:spacer width="8"/>
              <uix:cellFormat>
              <uix:styledList>
                <uix:styledText styleClass="OraDataText"
                                textBinding="description@policyEditSettingsJspBean@servletRequest"/>
                <uix:spacer width="3" />
                <uix:image renderedBinding ="renderHelpIcon@policyEditSettingsJspBean@servletRequest"
                           sourceBinding="descrImg@policyEditSettingsJspBean@servletRequest" 
                           shortDescBinding="SHORTDESC_HELPICON@policyJspBundle"
                           destinationBinding="descrDest@policyEditSettingsJspBean@servletRequest"/>
              </uix:styledList>
              </uix:cellFormat>
            </uix:rowLayout>
 
            <%------------------------
             -  Policy Evaluation
             ------------------------%>
            <uix:rowLayout>
              <uix:spacer height="1"/>
            </uix:rowLayout>
            <uix:rowLayout>
              <%---  Prompt  ---%>
              <uix:cellFormat width="144" hAlign="right" vAlign="top" wrappingDisabled="true">
                <uix:styledText
                  styleClass="OraPromptText"
                  textBinding="LBL_POLICYEVAL@policyJspBundle" />
              </uix:cellFormat>

              <%---  Field  ---%>
              <uix:spacer width="8"/>
              <uix:cellFormat>
               <uix:messageChoice name="selPolicyEval"
                            id="selPolicyEval"
                            tipBinding="TIP_DISABLE@policyJspBundle"
                            selectedValueBinding="selPolicyEval@policyEditSettingsJspBean@servletRequest">
                <uix:contents>
                    <uix:option value = "enabled"  
                                textBinding="LBL_ENABLED@policyJspBundle" />
                    <uix:option value = "disabled"
                                textBinding="LBL_DISABLED@policyJspBundle" />
                </uix:contents>
               </uix:messageChoice>
              </uix:cellFormat>
            </uix:rowLayout>

         </uix:tableLayout >
           
      </uix:contents>
      </uix:cellFormat>
 
  </uix:contents>
  </uix:tableLayout>

  <%------------------------
   - Compliance Score Setting
   ------------------------%>             

  <uix:header textBinding="HDR_VIOLATIONSETTING@policyJspBundle">        

  <uix:tableLayout>
  <uix:contents>
     
      <uix:cellFormat vAlign="top">
      <uix:contents>

        <uix:rowLayout>
            <uix:styledText
              styleClass="OraFieldText"
              textBinding="DESC_VIOLATIONSETTING@policyJspBundle"/>
        </uix:rowLayout>  
        <uix:spacer height="10"/>
 
        <uix:tableLayout >
            <%------------------------
             - Severity
            ------------------------%>             
            <uix:rowLayout>
             
              <%---  Prompt  ---%>             
              <uix:cellFormat width="125" hAlign="right" wrappingDisabled="true">
                <uix:styledText
                  styleClass="OraPromptText"
                  textBinding="LBL_SEVERITY@policyJspBundle" />
              </uix:cellFormat>

              <%---  Field  ---%>
              <uix:spacer width="8"/>
              <uix:cellFormat>
                 <uix:styledText
                    styleClass="OraDataText"
                    textBinding="severityImageAltText@policyEditSettingsJspBean@servletRequest" />
<%---    
                  <uix:image 
                    sourceBinding="severityImageSrc@policyEditSettingsJspBean@servletRequest"
                    shortDescBinding="severityImageAltText@policyEditSettingsJspBean@servletRequest"
                    />
---%>
              </uix:cellFormat>
            </uix:rowLayout>

            <%------------------------
             - Importance
             ------------------------%>
            <uix:rowLayout>
              <uix:spacer height="1"/>
            </uix:rowLayout>
            <uix:rowLayout>
              <%---  Prompt  ---%>
              <uix:cellFormat width="125" hAlign="right" vAlign="top" wrappingDisabled="true">
                <uix:styledText
                  styleClass="OraPromptText"
                  textBinding="LBL_IMPORTANCE@policyJspBundle" />
              </uix:cellFormat>

              <%---  Field  ---%>
<%-- 
valueBinding="<%= PolicyJspConstants.S_OP_NORMAL %>" 
doing valueBinding does not map the value???  
so it needs to be hardcoded as value="somevalue"
--%>
              <uix:spacer width="8"/>
              <uix:cellFormat>
                <uix:messageChoice name="selImportance"
                            id="selImportance"
                            tipBinding="TIP_IMPORTANCE@policyJspBundle"
                            selectedValueBinding="selImportance@policyEditSettingsJspBean@servletRequest">
                <uix:contents>
                    <uix:option value = "normal" 
                                textBinding="RISK_NORMAL@policyJspBundle" />                               
                    <uix:option value = "high"
                                textBinding="RISK_HIGH@policyJspBundle" />
                    <uix:option value = "low"
                                textBinding="RISK_LOW@policyJspBundle" />
                 </uix:contents>
               </uix:messageChoice>
              </uix:cellFormat>
            </uix:rowLayout>

         </uix:tableLayout >

      </uix:contents>
      </uix:cellFormat>
           
  </uix:contents>
  </uix:tableLayout >
  </uix:header>

<!-- Parameters -->

  <%@ include file="parametersTableEdit.jspf" %>

<!-- Exclusions -->

  <%@ include file="exclusionsTableEdit.jspf" %>
    
  
<!-- Corrective Action -->


  <%------------------------
    -  Corrective Action
    ------------------------%>     

  <uix:header textBinding="HDR_CORRECTIVEACTION@policyJspBundle">
  <uix:tableLayout >
  <uix:contents> 
  
      <uix:cellFormat vAlign="top">
      <uix:contents>
 
            <uix:rowLayout>
                <uix:styledText
                  styleClass="OraFieldText"
                  textBinding="DESC_CORRECTIVEACTION@policyJspBundle"/>
            </uix:rowLayout>  

            <uix:rowLayout>
              <uix:spacer width="5" />
            </uix:rowLayout>  
                                 
            <uix:rowLayout >
                <uix:cellFormat width="125" hAlign="right"  wrappingDisabled="true">
                  <uix:styledText styleClass="OraFieldText"
                                  textBinding="HDR_CORRECTIVEACTION@policyJspBundle"/>
                </uix:cellFormat>
                <uix:spacer width="8"/>
                <uix:cellFormat>

                  <uix:link textBinding="policyCAName@policyEditSettingsJspBean@servletRequest"
                            destinationBinding="policyCAURL@policyEditSettingsJspBean@servletRequest"
                            renderedBinding="policyCASet@policyEditSettingsJspBean@servletRequest"/>

                  <uix:spacer width="4" renderedBinding="policyCASet@policyEditSettingsJspBean@servletRequest"/>

                  <%-- if set show Remove --%>
                  <uix:submitButton textBinding="REMOVE@sdkUIMsg"
                                    shortDescBinding="REMOVE@sdkUIMsg"
                                    name="event"
                                    value="removePolicyCA"
                                    renderedBinding="policyCASet@policyEditSettingsJspBean@servletRequest"/>

                  <%-- if no CA set, display <none> and maybe ADD --%>
                  <uix:styledText styleClass="OraDataText"
                                  textBinding="SHOW_NONE@jobsResource"
                                  renderedBinding="policyCAUnset@policyEditSettingsJspBean@servletRequest"/>

                  <uix:spacer width="4" renderedBinding="policyCAUnset@policyEditSettingsJspBean@servletRequest"/>

                  <uix:submitButton textBinding="ADD@sdkUIMsg"
                                    shortDescBinding="ADD@sdkUIMsg"
                                    name="event"
                                    value="createPolicyCA"
                                    renderedBinding="policyCAUnset@policyEditSettingsJspBean@servletRequest"/>

                </uix:cellFormat>
            </uix:rowLayout>

             <uix:rowLayout>
              <uix:cellFormat width="125" hAlign="right" wrappingDisabled="true">
              </uix:cellFormat>
              <uix:spacer width="5"/>
              <uix:cellFormat>
              <uix:messageCheckBox name="checkBoxCA" 
                        prompt=""  
                        value="true"
                        textBinding="LBL_PREVENTMULTIPLECA@policyJspBundle"
                        checkedBinding="checkBoxCAChecked@policyEditSettingsJspBean@servletRequest" />                  
              </uix:cellFormat>
           </uix:rowLayout>
            

    </uix:contents>
    </uix:cellFormat >
    
  </uix:contents>
  </uix:tableLayout >
  </uix:header>


  <%------------------------
    -  Prevent Template Override
    ------------------------%>     
  <uix:header 
      renderedBinding = "renderTemplateOverride@policyEditSettingsJspBean@servletRequest"
      textBinding="HDR_TEMPLATE_OVERRIDE@policyJspBundle">
 
  <uix:tableLayout >
  <uix:contents> 
  
      <uix:cellFormat vAlign="top">
      <uix:contents>
 
            <uix:rowLayout>
                <uix:styledText
                  renderedBinding="renderTemplateOverride@policyEditSettingsJspBean@servletRequest"
                  styleClass="OraFieldText"
                  textBinding="INSTR_TEMPLATEOVERRIDE@policyJspBundle"/>
            </uix:rowLayout>  
 
            <uix:rowLayout>
              <uix:spacer width="5" />
            </uix:rowLayout>  
              <%------------------------
             -  Prevent Template Override
             ------------------------%>
            <uix:rowLayout>
              <uix:cellFormat width="125" hAlign="right">
              </uix:cellFormat>
              <uix:spacer width="5"/>
              <uix:cellFormat hAlign="left">
             <uix:messageCheckBox name="templateOverride" 
                      prompt=""
                      value="true"
                      renderedBinding="renderTemplateOverride@policyEditSettingsJspBean@servletRequest"
                      textBinding="LBL_PREVENTOVERRIDE@policyJspBundle"
                      checkedBinding="templateOverrideChecked@policyEditSettingsJspBean@servletRequest" />
              </uix:cellFormat>
           </uix:rowLayout>


    </uix:contents>
    </uix:cellFormat >
    
  </uix:contents>
  </uix:tableLayout >
  </uix:header>
 
          <%-------------------------
           -  Page Buttons
           ---------------------------%>
          <uix:pageButtons >
            <uix:pageButtonBar >
              <uix:button textBinding="BTN_CANCEL@policyJspBundle" 
                          destinationBinding="cancelDest@policyEditSettingsJspBean@servletRequest" 
                          shortDescBinding="BTN_CANCEL@policyJspBundle"/>
                           
              <uix:submitButton renderedBinding="renderOKButton@policyEditSettingsJspBean@servletRequest"
                                textBinding="BTN_OK@policyJspBundle" 
                                shortDescBinding="BTN_OK@policyJspBundle"
                                formName="policyEditSettingsForm"                         
                                name="event" value="doApply" />                          

              <uix:submitButton renderedBinding="renderContinueButton@policyEditSettingsJspBean@servletRequest"
                                textBinding="BTN_CONTINUE@policyJspBundle" 
                                shortDescBinding="BTN_CONTINUE@policyJspBundle" 
                                formName="policyEditSettingsForm"                         
                                name="event" value="doContinue" />                          

            </uix:pageButtonBar>
          </uix:pageButtons>


        </uix:pageLayout>    
      </oem:form>
    </uix:body>
  </uix:document> 
</uix:renderingContext>
