<%-- 
  -- Page: policyErrors.jsp 
  -- Controller: oracle.sysman.eml.ecm.jsp.PolicyEvaluationErrorsController 
  -- 
  -- Description: Launched when user selects "search" action 
  -- 
  -- MODIFIED (MM/DD/YY) 
  -- sthiruna 08/01/06 - Copying 10.2.0.3 Config Standard changes from
  --                     EMCORE_MAIN_LINUX
  -- kchiasso 02/10/06 - rmv PageStatus  
  -- kchiasso 01/11/06 - new subtabs
  -- kchiasso 06/02/05 - add link
  -- groyal   02/08/05 - Rework table layout 
  -- groyal   02/04/05 - Change policyMsgBundle to msgBundle
  -- kchiasso 01/10/05 - instr text
  -- kchiasso 01/05/05 - 'post' req'd as of 2.2.15 upgrade
  -- groyal   12/22/04 - Fix problem with display of policy rule column 
  -- kchiasso 12/22/04 - get for bookmarking
  -- kchiasso 12/06/04 - incl msgHeader 
  -- kchiasso 11/22/04 - hdr
  -- akskumar 11/24/04 - licensing work, disable links on rows 
  -- kchiasso 10/27/04 - remove separator 
  -- kchiasso 10/05/04 - ppr; showall
  -- groyal   09/30/04 - Update
  -- groyal   09/22/04 - Add refreshed 
  -- groyal   09/21/04 - Add separator 
  -- groyal   08/18/04 - Remove reference to PolicyMsg 
  -- kchiasso 08/17/04 - kchiasso_policyviolationsincontext
  -- kchiasso 08/16/04 - Creation 
--%>
  <%@ page contentType="text/html; charset=UTF-8"%>
  <%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
  <%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
  <%-- Imports --%>
  <%@ page import="oracle.sysman.eml.ecm.policy.PolicyJspConstants"%>
  <%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource"%>
  <uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/>
    <uix:bundle name="msgBundle" class="oracle.sysman.eml.ecm.policy.util.PolicyJspMsg"/>
    <uix:document>
      <%@ include file="/oemTitle.jspf"%>
      <%@ include file="/enablePPR.jspf"%>
   
       	<uix:body>
        <uix:pageLayout titleBinding="PAGE_TITLE_ERRORS@msgBundle">
         <%@ include file="msgHeader.jspf" %>

         <uix:dataScope currentDataBinding="policyEvaluationErrorsJspBean@servletRequest">
 
         <uix:subTabLayout>
          <uix:subTabs>
              <uix:subTabBar selectedIndex="3">
              <uix:contents>
                   <uix:link textBinding="TAB_VIOLATIONS@msgBundle"
                              destinationBinding="<%= PolicyJspConstants.S_TAB_VIOLATIONS %>" />
                   <uix:link textBinding="TAB_LIBRARY@msgBundle"
                              destinationBinding="<%= PolicyJspConstants.S_TAB_LIBRARY %>" />
                   <uix:link textBinding="TAB_ASSOCIATIONS@msgBundle"
                              destinationBinding="<%= PolicyJspConstants.S_TAB_ASSOCIATIONS %>" />
                   <uix:link textBinding="TAB_ERRORS@msgBundle"
                              destinationBinding="<%= PolicyJspConstants.S_TAB_ERRORS %>" />
                  </uix:contents>
              </uix:subTabBar>
          </uix:subTabs>
          <uix:contents>

          <uix:form nameBinding="eml_ecm_sc_formName@servletRequest" 
                    method="post"> 
   
              <uix:tableLayout width="100%">
                 <uix:contents>                     
                  <uix:cellFormat width="60%">
                   <uix:rowLayout>
                    <uix:styledText styleClass="OraInstructionText" 
                                    textBinding="INSTR_SEARCH_ERRORS@msgBundle"/>
                   </uix:rowLayout>
                  </uix:cellFormat>
                  <uix:cellFormat width="40%" vAlign="top">
                   <uix:rowLayout hAlign="right">
                    <oem:pageRefreshed/>
                   </uix:rowLayout>
                  </uix:cellFormat> 
                 </uix:contents>                
              </uix:tableLayout>
              
              <uix:stackLayout>
                  <uix:spacer/>
              </uix:stackLayout>
 
              <uix:include nodeBinding="eml_ecm_sc_uiNode@servletRequest"/>
              
              <uix:stackLayout>
                <uix:spacer height="10"/>
                <uix:table name="PolicyEvaluationErrorsList" 
                           id = "PolicyEvaluationErrorsList"
                           partialRenderMode="self"
                           showAll="yes"
                           alternateTextBinding="NO_RESULTS_FOUND@msgBundle"
                           formSubmitted="true" 
                           width="100%" 
                           minValue="1" 
                           tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>" 
                           valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>" 
                           maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>" 
                           blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                           summaryBinding="TBLSUM_RESULTSTABLE@msgBundle">
                  <uix:tableFormat tableBanding="rowBanding"/>
                  <%-- Target column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_TARGET@msgBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_TARGET %>"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:link textBinding="<%= PolicyJspConstants.S_LBL_TARGET %>"
                              destinationBinding="<%= PolicyJspConstants.S_DEST_TARGET %>" />
                  </uix:column>
                  <%-- Type column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_TYPE@msgBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_TYPE %>"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="<%= PolicyJspConstants.S_LBL_TYPE %>"/>
                  </uix:column>
                  <%-- Policy Rule column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_POLICYRULE@msgBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_POLICYRULE %>"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:link textBinding="<%= PolicyJspConstants.S_LBL_POLICYRULE %>" destinationBinding="<%= PolicyJspConstants.S_DEST_DETAILS %>"/>
                  </uix:column>
                  <%-- Metric column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_METRIC@msgBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_METRIC %>"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="<%= PolicyJspConstants.S_LBL_METRIC %>"/>
                  </uix:column>                                    
                  <%-- Timestamp column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_TIMESTAMP@msgBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_TIMESTAMP %>"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="dateFormat"/>
                    <uix:styledText textBinding="<%= PolicyJspConstants.S_LBL_TIMESTAMP %>"/>
                  </uix:column>
                  <%-- Error Type column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_ERRORTYPE@msgBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_ERRORTYPE %>"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="<%= PolicyJspConstants.S_LBL_ERRORTYPE %>"/>
                  </uix:column>
                  <%-- Message column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_MESSAGE@msgBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_MESSAGE %>"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:link textBinding="<%= PolicyJspConstants.S_LBL_MESSAGE %>" />
                  </uix:column>
                </uix:table>
              </uix:stackLayout>
 
           </uix:form>

           </uix:contents>
          </uix:subTabLayout>
           
        </uix:dataScope>       
      </uix:pageLayout>

      </uix:body>

   </uix:document>
  </uix:renderingContext>
<%------------------------------  End of File  -------------------------------%>
