<%--
  -- Page:        policyRuleLibrary.jsp
  -- Controller:  oracle.sysman.eml.ecm.jsp.PolicyRuleLibraryController
  --
  -- Description: Launched when user selects "search" action
  --
  --  MODIFIED    (MM/DD/YY)
  --   sthiruna    08/01/06 - Copying 10.2.0.3 Config Standard changes from
  --                          EMCORE_MAIN_LINUX
  --   kchiasso    02/10/06 - rmv PageStatus
  --   kchiasso    01/11/06 - new subtabs
  --   kchiasso    03/02/05 - add related link
  --   kchiasso    02/17/05 - render desc img
  --   groyal      02/04/05 - Change msgBundle to msgBundle
  --   kchiasso    01/07/05 - shortdesc
  --   kchiasso    01/05/05 - 'post' req'd as of 2.2.15 upgrade
  --   kchiasso    12/22/04 - get for bookmarking
  --   kchiasso    12/06/04 - incl msgHeader 
  --   kchiasso    11/22/04 - hdr
  --   kchiasso    10/27/04 - remove separator 
  --   kchiasso    10/05/04 - ppr; showall
  --   groyal      09/23/04 - Add tip 
  --   groyal      09/22/04 - Add refreshed 
  --   groyal      09/21/04 - Add separator 
  --   groyal      08/18/04 - Remove reference to PolicyMsg 
  --   kchiasso    07/28/04 - uix constants
  --   groyal      06/29/04 - Add Jsp to bean 
  --   kchiasso    06/24/04 - kchiasso_newpolicyrulelibrary
  --   kchiasso    06/08/04 - Creation
  --%>
  <%@ page contentType="text/html; charset=UTF-8"%>
  <%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
  <%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
  <%-- Imports --%>
  <%@ page import="oracle.sysman.eml.ecm.policy.PolicyJspConstants"%>
  <%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
  <uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/>
    <uix:bundle name="msgBundle" class="oracle.sysman.eml.ecm.policy.util.PolicyJspMsg"/>
    <uix:document>
      <%@ include file="/oemTitle.jspf"%>
      <%@ include file="/enablePPR.jspf"%>
 
 
  	<uix:body>
        <uix:pageLayout titleBinding="PAGE_TITLE_RULELIBRARY@msgBundle">
        <%@ include file="msgHeader.jspf" %>

        <uix:dataScope currentDataBinding="policyRuleLibraryJspBean@servletRequest">

         <uix:subTabLayout>
          <uix:subTabs>
              <uix:subTabBar selectedIndex="1">
              <uix:contents>
                   <uix:link textBinding="TAB_VIOLATIONS@msgBundle"
                              destinationBinding="<%= PolicyJspConstants.S_TAB_VIOLATIONS %>" />
                   <uix:link textBinding="TAB_LIBRARY@msgBundle"
                              destinationBinding="<%= PolicyJspConstants.S_TAB_LIBRARY %>" />
                   <uix:link textBinding="TAB_ASSOCIATIONS@msgBundle"
                              destinationBinding="<%= PolicyJspConstants.S_TAB_ASSOCIATIONS %>" />
                   <uix:link textBinding="TAB_ERRORS@msgBundle"
                              destinationBinding="<%= PolicyJspConstants.S_TAB_ERRORS %>" />
                  </uix:contents>
              </uix:subTabBar>
          </uix:subTabs>
          <uix:contents>

     
          <uix:form nameBinding="eml_ecm_sc_formName@servletRequest" 
                    method="post">            
   
              <uix:tableLayout width="100%">
                 <uix:contents>                     
                  <uix:cellFormat width="60%">
                   <uix:rowLayout>
                    <uix:styledText styleClass="OraInstructionText" 
                                    textBinding="INSTR_SEARCH_RULELIBRARY@msgBundle"/>
                   </uix:rowLayout>
                  </uix:cellFormat>
                  <uix:cellFormat width="40%" vAlign="top">
                   <uix:rowLayout hAlign="right">
                    <oem:pageRefreshed/>
                   </uix:rowLayout>
                  </uix:cellFormat> 
                 </uix:contents>
              </uix:tableLayout>

              <uix:stackLayout>
                  <uix:spacer/>
              </uix:stackLayout>
                        
              <uix:include nodeBinding="eml_ecm_sc_uiNode@servletRequest"/>
              
              <uix:stackLayout>
                <uix:contents>
                        
                <uix:spacer height="10"/>
                <uix:table name="PolicyRuleLibraryList" 
                           id = "PolicyRuleLibraryList"
                           partialRenderMode="self"
                           showAll="yes"
                           alternateTextBinding="NO_RESULTS_FOUND@msgBundle"
                           formSubmitted="true" width="100%" 
                           minValue="1" 
                           tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                           valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                           maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                           blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                           summaryBinding="TBLSUM_RESULTSTABLE@msgBundle">
                  <uix:tableFormat tableBanding="rowBanding"/>
                  <%-- Policy Rule column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_POLICYRULE@msgBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_POLICYRULE %>"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:link textBinding="<%= PolicyJspConstants.S_LBL_POLICYRULE %>" destinationBinding="<%= PolicyJspConstants.S_DEST_DETAILS %>"/>
                  </uix:column>
                  <%-- Severity column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_SEVERITY@@msgBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_SEVERITY %>"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="<%= PolicyJspConstants.S_LBL_SEVERITY %>"/>
                  </uix:column>
                  <%-- Category column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_CATEGORY@msgBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_CATEGORY %>"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="<%= PolicyJspConstants.S_LBL_CATEGORY %>"/>
                  </uix:column>
                 <%-- Type column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_TYPE@msgBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_TYPE %>"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="<%= PolicyJspConstants.S_LBL_TYPE %>"/>
                  </uix:column>
                  <%-- Description column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_DESCRIPTION@msgBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_DESCRIPTION %>"/>
                    </uix:columnHeader>
                    <uix:columnFormat width="10" cellNoWrapFormat="false" columnDataFormat="textFormat"/>
                  <uix:styledList>
                    <uix:styledText textBinding="<%= PolicyJspConstants.S_LBL_DESCRIPTION %>"/>
                    <uix:spacer width="3" />
                    <uix:image renderedBinding = "<%= PolicyJspConstants.S_RENDER_HELPICON %>"
                               sourceBinding="<%= PolicyJspConstants.S_IMG_INFORMATION %>" 
                               shortDescBinding="SHORTDESC_HELPICON@msgBundle"
                               destinationBinding="<%= PolicyJspConstants.S_HELP_DESCRIPTION %>"/>
                  </uix:styledList>
                  </uix:column>
                  <%-- Owner --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_OWNER@msgBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_OWNER %>"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="<%= PolicyJspConstants.S_LBL_OWNER %>" />
                  </uix:column>
                  <%-- UsedIn Templates column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_USEDINTEMPLATES@msgBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_USEDINTEMPLATES %>"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="numberFormat"/>
                    <uix:link textBinding="<%= PolicyJspConstants.S_LBL_USEDINTEMPLATES %>" destinationBinding="<%= PolicyJspConstants.S_DEST_USEDINTEMPLATES %>"/>
                  </uix:column>
                  <%-- UsedBy Targets column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_USEDBYTARGETS@msgBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_USEDBYTARGETS %>"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="numberFormat"/>
                    <uix:link textBinding="<%= PolicyJspConstants.S_LBL_USEDBYTARGETS %>" destinationBinding="<%= PolicyJspConstants.S_DEST_USEDBYTARGETS %>"/>
                  </uix:column>
 
                 </uix:table>

                <uix:tip>
                    <uix:styledText textBinding="POLICY_RULELIBRARY_TIP@msgBundle"/>
                </uix:tip>

               </uix:contents>
              </uix:stackLayout>

          <%------------------------
           -  Related Links
           ------------------------%>

          <uix:header 
            textBinding="RELATED_LINK@msgBundle">         

          <uix:tableLayout>

            <uix:rowLayout>
              <%---  Monitoring Template  ---%>
              <uix:cellFormat hAlign="left">
                  <uix:link textBinding="LBL_SETUPMONITORINGTEMPLATES@msgBundle" 
                            destinationBinding="<%= PolicyJspConstants.S_DEST_CREATETEMPLATE %>"/>
              </uix:cellFormat>
            </uix:rowLayout>     
            
          </uix:tableLayout> 
          
          </uix:header>         

              
          <%-------------------------
           -  Page Buttons
           ---------------------------%>
          <uix:pageButtons>
            <uix:pageButtonBar>

            </uix:pageButtonBar>
          </uix:pageButtons>
              
         </uix:form>

           </uix:contents>
          </uix:subTabLayout>
           
        </uix:dataScope>       
      </uix:pageLayout>

      </uix:body>

   </uix:document>
  </uix:renderingContext>
<%------------------------------  End of File  -------------------------------%>
