<%--
  -- Page:        policyViewComment.jsp
  -- Controller:  oracle.sysman.eml.ecm.policy.PolicyViewCommentController
  --
  --  MODIFIED    (MM/DD/YY)  
  --   kchiasso    07/21/05 - add btn sd
  --   niramach    02/28/05 - Change Last evaluation to page refreshed. 
  --   groyal      01/20/05 - UI Exit review comments 
  --   niramach    10/29/04 - Creation
  --%>
  
<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.eml.ecm.policy.PolicyJspConstants" %>
<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="policyBundle" class="oracle.sysman.eml.ecm.policy.util.PolicyJspMsg"/>   
  <uix:bundle name="SDKUIMsg" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>   
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>    
    <%@ include file="/enablePPR.jspf"%>
    <uix:body>
      <uix:form name="viewCommentForm" method="POST">           
          <uix:pageLayout
          titleBinding="PAGE_TITLE_VIEWCOMMENT@policyBundle@servletRequest">      
          <%@ include file="msgHeader.jspf" %>
                      
            <uix:tableLayout width="100%">
              <uix:rowLayout>
                <uix:cellFormat>
                  <uix:rowLayout hAlign="right">
                    <uix:styledText
                      styleClass="OraTipText"
                      textBinding="PAGE_REFRESHED_TIME@SDKUIMsg"/>
                    <uix:spacer width="5"/>                      
                    <uix:styledText 
                      styleClass="OraTipLabel" 
                      textBinding="refreshedAt@policyViewCommentJspBean@servletRequest"/>                      
                  </uix:rowLayout>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>     
            
            <uix:tableLayout >
            <uix:contents>
  
            
           <uix:cellFormat vAlign="top" width="50%">
            <uix:contents>            
              <uix:tableLayout >       
                  <%-- Policy rule --%>       
                  <uix:rowLayout>
                    <%-- Prompt --%>        
                    <uix:spacer width="5"/>
                    <uix:cellFormat hAlign="right" wrappingDisabled="true">
                      <uix:styledText
                        styleClass="OraPromptText"
                        textBinding="LBL_POLICYRULE_DISPLAY@policyBundle@servletRequest" />
                    </uix:cellFormat>
      
                    <%-- Field --%>        
                    <uix:spacer width="8"/>
                    <uix:cellFormat>
                      <uix:styledText
                        styleClass="OraDataText"
                        textBinding="policyRuleDisplayName@policyViewCommentJspBean@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>

                  <%-- Severity --%>          
                  <uix:rowLayout>
                    <%-- Prompt --%>
                    <uix:spacer width="5"/>
                    <uix:cellFormat hAlign="right" wrappingDisabled="true">
                      <uix:styledText
                        styleClass="OraPromptText"
                        textBinding="LBL_SEVERITY@policyBundle@servletRequest" />
                    </uix:cellFormat>
      
                    <%-- Field --%>
                    <uix:spacer width="8"/>
                    <uix:cellFormat>
                        <uix:image 
                          sourceBinding="severityImageSrc@policyViewCommentJspBean@servletRequest"
                          shortDescBinding="severityImageAltText@policyViewCommentJspBean@servletRequest"
                          />
                    </uix:cellFormat>
                  </uix:rowLayout>

                  <%-- Importance --%>
                  <uix:rowLayout>          
                    <%-- Prompt --%>
                    <uix:spacer width="5"/>                    
                    <uix:cellFormat hAlign="right" wrappingDisabled="true">
                      <uix:styledText
                        styleClass="OraPromptText"
                        textBinding="LBL_IMPORTANCE@policyBundle@servletRequest" />
                    </uix:cellFormat>
      
                    <%-- Field --%>
                    <uix:spacer width="8"/>
                    <uix:cellFormat>
                      <uix:styledText
                        styleClass="OraDataText"
                        textBinding="importance@policyViewCommentJspBean@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>

                  <%-- Category --%>
                  <uix:rowLayout>                  
                    <%-- Prompt --%>
                    <uix:spacer width="5"/>
                    <uix:cellFormat hAlign="right" wrappingDisabled="true">
                      <uix:styledText
                        styleClass="OraPromptText"
                        textBinding="LBL_CATEGORY@policyBundle@servletRequest" />
                    </uix:cellFormat>
      
                    <%-- Field --%>
                    <uix:spacer width="8"/>
                    <uix:cellFormat>
                      <uix:styledText
                        styleClass="OraDataText"
                        textBinding="categoryName@policyViewCommentJspBean@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>

                  <%-- Non Compliant since --%>
                  <uix:rowLayout>                  
                    <%-- Prompt --%>
                    <uix:spacer width="5"/>
                    <uix:cellFormat hAlign="right" wrappingDisabled="true">
                      <uix:styledText
                        styleClass="OraPromptText"
                        textBinding="LBL_NONCOMPLIANTSINCE@policyBundle@servletRequest" />
                    </uix:cellFormat>
      
                    <%-- Field --%>
                    <uix:spacer width="8"/>
                    <uix:cellFormat>
                      <uix:styledText
                        styleClass="OraDataText"
                        textBinding="nonCompliantSince@policyViewCommentJspBean@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  
                  <%-- Last evaluation at --%>
                  <uix:rowLayout>                  
                    <%-- Prompt --%>
                    <uix:spacer width="5"/>
                    <uix:cellFormat hAlign="right" wrappingDisabled="true">
                      <uix:styledText
                        styleClass="OraPromptText"
                        textBinding="LBL_LASTEVAL@policyBundle@servletRequest" />
                    </uix:cellFormat>
      
                    <%-- Field --%>
                    <uix:spacer width="8"/>
                    <uix:cellFormat>
                      <uix:styledText
                        styleClass="OraDataText"
                        textBinding="lastEvaluation@policyViewCommentJspBean@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  
                  
                  <%-- Message --%>
                  <uix:rowLayout>   
                    <%-- Prompt --%>
                    <uix:spacer width="5"/>
                    <uix:cellFormat hAlign="right" wrappingDisabled="true">
                      <uix:styledText
                        styleClass="OraPromptText"
                        textBinding="LBL_MESSAGE@policyBundle@servletRequest" />
                    </uix:cellFormat>
      
                    <%-- Field --%>
                    <uix:spacer width="8"/>
                    <uix:cellFormat>
                      <uix:styledText
                        styleClass="OraDataText"
                        textBinding="message@policyViewCommentJspBean@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout >                
              </uix:contents>
              </uix:cellFormat>               
        </uix:contents>
      </uix:tableLayout>
      
      
      <uix:rowLayout hAlign="right">
       <uix:submitButton name ="event" formName="viewCommentForm" 
                textBinding="BTN_ADDCOMMENT@policyBundle@servletRequest"
                shortDescBinding="BTN_ADDCOMMENT@policyBundle@servletRequest"
                value="<%=PolicyJspConstants.ADDCOMMENT %>"/> 
      </uix:rowLayout>                
      <uix:spacer height="30"/>
      <uix:dataScope currentDataBinding="tableDataSrc@policyViewCommentJspBean@servletRequest">
        <uix:table name="policyCommentTbl" 
                       id = "policyCommentTbl"
                       nameBinding="<%= PolicyJspConstants.POLICY_VIEW_COMMENT_TBL %>"
                       partialRenderMode="self"
                       showAll="yes"
                       alternateTextBinding="NO_COMMENTS_FOUND@policyBundle@servletRequest"
                       formSubmitted="true"
                       width="100%"
                       minValue="1"
                       tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                       valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                       maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                       blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                       summaryBinding="TBLSUM_VIEWCOMMENTSTABLE@policyBundle@servletRequest">
      
        <%-- Time stamp column --%>                
        <uix:column> 
            <uix:columnHeader>
                <uix:sortableHeader 
                    textBinding="LBL_TIMESTAMP@policyBundle@servletRequest" 
                    sortableBinding="<%= PolicyJspConstants.S_SORT_TIMESTAMP %>"/>                                                
            </uix:columnHeader> 
            <uix:columnFormat columnDataFormat="dateFormat"/>                                  
            <uix:styledText textBinding="<%= PolicyJspConstants.S_LBL_TIMESTAMP %>"/>
        </uix:column>  
        
        <%-- Type column--%>
        <uix:column> 
              <uix:columnHeader>
                    <uix:sortableHeader 
                    textBinding="LBL_TYPE@policyBundle@servletRequest" 
                    sortableBinding="<%= PolicyJspConstants.S_SORT_TYPE %>"/>                                                         
              </uix:columnHeader>                   
              <uix:columnFormat columnDataFormat="textFormat"/>                  
              <uix:styledText textBinding="<%= PolicyJspConstants.S_LBL_TYPE %>"/>                                
        </uix:column>                            

          <%-- Username column--%>
        <uix:column> 
              <uix:columnHeader>
                    <uix:sortableHeader 
                    textBinding="LBL_USER_NAME@policyBundle@servletRequest" 
                    sortableBinding="<%= PolicyJspConstants.S_SORT_NAME %>"/>                                                                                               
              </uix:columnHeader>                   
              <uix:columnFormat columnDataFormat="textFormat"/>                  
              <uix:styledText textBinding="<%= PolicyJspConstants.S_LBL_NAME %>"/>                                
        </uix:column>    
        
          <%-- Message column--%>
        <uix:column> 
              <uix:columnHeader>
                    <uix:sortableHeader 
                    textBinding="LBL_MESSAGE@policyBundle@servletRequest" 
                    sortableBinding="<%= PolicyJspConstants.S_SORT_MESSAGE %>"/>                     
              </uix:columnHeader>                   
              <uix:columnFormat columnDataFormat="textFormat"/>                  
              <uix:styledText textBinding="<%= PolicyJspConstants.S_LBL_MESSAGE %>"/>                                
        </uix:column>           
       
    </uix:table>   
    </uix:dataScope>
    </uix:pageLayout>
   </uix:form>
  </uix:body>
  </uix:document>
</uix:renderingContext>
