<%--
  -- Page:        policyViewRule.jsp
  -- Controller:  oracle.sysman.eml.ecm.policy.PolicyViewRuleController
  --
  --  MODIFIED    (MM/DD/YY)
  --   kchiasso    07/26/05 - link;render Help Icon
  --   kchiasso    03/04/05 - enforce to eval
  --   kchiasso    01/24/05 - header outside table;
  --   groyal      01/20/05 - UI Exit review comments 
  --   kchiasso    01/14/05 - alignment
  --   kchiasso    01/05/05 - importance -> viewImportance
  --   kchiasso    12/29/04 - set prompt target type 
  --   kchiasso    12/14/04 - set pagestatus context
  --   kchiasso    12/03/04 - default value
  --   kchiasso    11/22/04 - hdr
  --   kchiasso    11/16/04 - context help
  --   groyal      10/01/04 - Corrective action work
  --   kchiasso    09/22/04 - add import
  --   groyal      08/04/04 - Replace author with owner 
  --   kchiasso    07/28/04 - kchiasso_newpolicyviewrule
  --   kchiasso    06/18/04 - Creation
  --%>
  <%@ page contentType="text/html; charset=UTF-8"%>
  <%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
  <%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
  <%-- Imports --%>
  <%@ page import="oracle.sysman.eml.ecm.policy.PolicyJspConstants"%>
  <%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>

  <uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/>
    <uix:bundle name="policyJspBundle" class="oracle.sysman.eml.ecm.policy.util.PolicyJspMsg" />
    <uix:document>
      <%@ include file="/oemTitle.jspf"%>
      
      <uix:body>
 
       <oem:form 
        copyParams="target,type,cancelURL,oname,otype"
        name="policyViewRuleForm" 
        method="post"
        destination="/console/ecm/policy/policyViewRule">
  
        <uix:formValue 
          name="pageName" 
          value="/ecm/policy/policyViewRule"/>
          
        <uix:pageLayout
          titleBinding="title@policyViewRuleJspBean@servletRequest">

        <%@ include file="msgHeader.jspf" %>
      
           <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="5%" columns="2" width="100%">
                <uix:messageStyledText
                    contentStyleClass="OraDataText"
                    promptBinding="LBL_POLICYRULE@policyJspBundle"
                    textBinding="ruleDisplayName@policyViewRuleJspBean@servletRequest"/>
                <uix:messageStyledText
                    contentStyleClass="OraDataText"
                    promptBinding="LBL_TARGETTYPE@policyJspBundle"
                    textBinding="typeDisplay@policyViewRuleJspBean@servletRequest"/>
               </uix:labeledFieldLayout>
          </uix:pageStatus>

          <uix:tableLayout width="100%">            
            <uix:rowLayout>
              <uix:separator/>
            </uix:rowLayout>            
            <uix:rowLayout>
              <uix:spacer height="15"/>
            </uix:rowLayout>
          </uix:tableLayout>
      
          
  <uix:tableLayout>
  <uix:contents>

     <uix:cellFormat vAlign="top">
      <uix:contents>

        <uix:tableLayout >
  
            <%------------------------
             - Owner
             ------------------------%>
            <uix:rowLayout>
              <%---  Prompt  ---%>
              <uix:cellFormat width="144" hAlign="right" wrappingDisabled="true">
                <uix:styledText
                  styleClass="OraPromptText"
                  textBinding="LBL_OWNER@policyJspBundle" />
              </uix:cellFormat>

              <%---  Field  ---%>
              <uix:spacer width="8"/>
              <uix:cellFormat>
                <uix:styledText
                  styleClass="OraDataText"
                  textBinding="ownerName@policyViewRuleJspBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>

            <%------------------------
             -  Category
             ------------------------%>
            <uix:rowLayout>
              <%---  Prompt  ---%>
              <uix:cellFormat width="144" hAlign="right" wrappingDisabled="true">
                <uix:styledText
                  styleClass="OraPromptText"
                  textBinding="LBL_CATEGORY@policyJspBundle" />
              </uix:cellFormat>

              <%---  Field  ---%>
              <uix:spacer width="8"/>
              <uix:cellFormat>
                <uix:styledText
                  styleClass="OraDataText"
                  textBinding="categoryName@policyViewRuleJspBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>


            <%------------------------
             -  Description
             ------------------------%>
            <uix:rowLayout>
              <%---  Prompt  ---%>
              <uix:cellFormat width="144" hAlign="right" wrappingDisabled="true">
                <uix:styledText
                  styleClass="OraPromptText"
                  textBinding="LBL_DESCRIPTION@policyJspBundle" />
              </uix:cellFormat>

              <%---  Field  ---%>
              <uix:spacer width="8"/>
              <uix:cellFormat>
              <uix:styledList>
                <uix:styledText styleClass="OraDataText"
                                textBinding="description@policyViewRuleJspBean@servletRequest"/>
                <uix:spacer width="3" />
                <uix:image renderedBinding ="renderHelpIcon@policyEditSettingsJspBean@servletRequest"
                           sourceBinding="descrImg@policyEditSettingsJspBean@servletRequest" 
                           shortDescBinding="SHORTDESC_HELPICON@policyJspBundle"
                           destinationBinding="descrDest@policyEditSettingsJspBean@servletRequest"/>
              </uix:styledList>
              </uix:cellFormat>
            </uix:rowLayout>

            <%------------------------
             -  Policy Evaluation
             ------------------------%>
            <uix:rowLayout>
              <%---  Prompt  ---%>
              <uix:cellFormat width="144" hAlign="right" wrappingDisabled="true">
                <uix:styledText
                  styleClass="OraPromptText"
                  textBinding="LBL_POLICYEVAL@policyJspBundle" />
              </uix:cellFormat>

              <%---  Field  ---%>
              <uix:spacer width="8"/>
              <uix:cellFormat>
                <uix:styledText
                  styleClass="OraDataText"
                  textBinding="policyEvalText@policyViewRuleJspBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>

        </uix:tableLayout >
           
      </uix:contents>
      </uix:cellFormat>
 
  </uix:contents>
  </uix:tableLayout>


  <%------------------------
    - Compliance Score Setting
    ------------------------%>             
  <uix:header textBinding="HDR_VIOLATIONSETTING@policyJspBundle">        
  <uix:tableLayout>
  <uix:contents>
     
      <uix:cellFormat vAlign="top">
      <uix:contents>

        <uix:rowLayout>
            <uix:styledText
              styleClass="OraFieldText"
              textBinding="DESC_VIOLATIONSETTING@@policyJspBundle"/>
        </uix:rowLayout>  
        <uix:spacer height="10"/>
 
        <uix:tableLayout >
  
            <%------------------------
             - Severity
            ------------------------%>             
            <uix:rowLayout>
             
              <%---  Prompt  ---%>             
              <uix:cellFormat width="125" hAlign="right" wrappingDisabled="true">
                <uix:styledText
                  styleClass="OraPromptText"
                  textBinding="LBL_SEVERITY@policyJspBundle" />
              </uix:cellFormat>

              <%---  Field  ---%>
              <uix:spacer width="8"/>
              <uix:cellFormat>
                 <uix:styledText
                  styleClass="OraDataText"
                    textBinding="severityImageAltText@policyViewRuleJspBean@servletRequest" />
 <%--
                  <uix:image 
                    sourceBinding="severityImageSrc@policyViewRuleJspBean@servletRequest"
                    shortDescBinding="severityImageAltText@policyViewRuleJspBean@servletRequest"
                    />
 --%>
              </uix:cellFormat>
            </uix:rowLayout>

            <%------------------------
             - Importance
             ------------------------%>
            <uix:rowLayout>
              <%---  Prompt  ---%>
              <uix:cellFormat width="125" hAlign="right" wrappingDisabled="true">
                <uix:styledText
                  styleClass="OraPromptText"
                  textBinding="LBL_IMPORTANCE@policyJspBundle" />
              </uix:cellFormat>

              <%---  Field  ---%>
              <uix:spacer width="8"/>
              <uix:cellFormat>
                <uix:styledText
                  styleClass="OraDataText"
                  textBinding="viewImportance@policyViewRuleJspBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>

         </uix:tableLayout >

      </uix:contents>
      </uix:cellFormat>
           
  </uix:contents>
  </uix:tableLayout >
  </uix:header>

<!-- Parameters -->

  <%@ include file="parametersTable.jspf"%>

<!-- Exclusions -->
  
  <%@ include file="exclusionsTable.jspf"%>

<!-- Corrective Action -->

  <%------------------------
    -  Corrective Action
    ------------------------%>     
  <uix:header textBinding="HDR_CORRECTIVEACTION@policyJspBundle">

  <uix:tableLayout >
  <uix:contents> 

      <uix:cellFormat vAlign="top">
      <uix:contents>

 
            <uix:rowLayout>
                <uix:styledText
                  styleClass="OraFieldText"
                  textBinding="DESC_CORRECTIVEACTION@policyJspBundle"/>
            </uix:rowLayout>  
            <uix:spacer height="10"/>

           <%------------------------
             - Corrective Action
            ------------------------%>             
            <uix:rowLayout>
             
              <%---  Prompt  ---%>             
              <uix:cellFormat width="125" hAlign="right" wrappingDisabled="true">
                <uix:styledText
                  styleClass="OraPromptText"
                  textBinding="HDR_CORRECTIVEACTION@policyJspBundle" />
              </uix:cellFormat>

              <%---  Field  ---%>            
              <uix:spacer width="8"/>
              <uix:cellFormat>
                <uix:link
                  styleClass="OraDataText"
                  textBinding="correctiveAction@policyViewRuleJspBean@servletRequest"
                  destinationBinding="correctiveActionDest@policyViewRuleJspBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>

    </uix:contents>
    </uix:cellFormat >

  </uix:contents>
  </uix:tableLayout >
  </uix:header>
 
        </uix:pageLayout>
      
      </oem:form>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 

<%------------------------------  End of File  -------------------------------%>
