  <%--
  -- Page:        policyViewSettings.jsp
  -- Controller:  oracle.sysman.eml.ecm.policy.PolicyViewRuleController
  --
  --  MODIFIED    (MM/DD/YY)
  --   ancheng     08/02/05 - title
  --   kchiasso    07/20/05 - link
  --   kchiasso    03/03/05 - enforce to eval
  --   kchiasso    02/17/05 - render desc img
  --   kchiasso    01/24/05 - hdr outside table layout
  --   groyal      01/20/05 - UI Exit review comments 
  --   kchiasso    01/13/05 - target or template context; layout
  --   kchiasso    01/05/05 - importance -> viewImportance
  --   kchiasso    12/29/04 - set prompt target type 
  --   kchiasso    12/14/04 - show severity text
  --   kchiasso    12/03/04 - add pageStatus
  --   kchiasso    11/22/04 - hdr
  --   kchiasso    11/16/04 - context help
  --   groyal      10/01/04 - Corrective action work
  --   groyal      09/27/04 - Fix template override 
  --   kchiasso    09/22/04 - add import
  --   groyal      08/05/04 - Rearrange
  --   kchiasso    07/28/04 - kchiasso_newpolicyviewrule
  --   kchiasso    06/18/04 - Creation
  --%>
  <%@ page contentType="text/html; charset=UTF-8"%>
  <%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
  <%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
  <%-- Imports --%>
  <%@ page import="oracle.sysman.eml.ecm.policy.PolicyJspConstants"%>
  <%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>

  <uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/>
    <uix:bundle name="policyJspBundle" class="oracle.sysman.eml.ecm.policy.util.PolicyJspMsg" />
    <uix:document>
      <%@ include file="/oemTitle.jspf"%>
      
      <uix:body>
 
       <oem:form 
        copyParams="target,type,cancelURL,oname,otype"
        name="policyViewSettingsForm" 
        method="post"
        destination="/console/ecm/policy/policyViewSettings">
  
        <uix:formValue 
          name="pageName" 
          value="/ecm/policy/policyViewSettings"/>
          
        <uix:pageLayout
          titleBinding="title@servletRequest">

          <%@ include file="msgHeader.jspf" %>
<%--
  -- include the setup subtabs if in setup
  <uix:styledText text="<%= \"inSetup=\" + request.getAttribute(\"inSetup\") %>"/>
--%>
          <%
            String inSetup =  (String)request.getAttribute("inSetup"); 
            if(inSetup != null && inSetup.equals("true"))
             {
          %>
        			<%@ include file="../../health/header.jsp" %>
          <%
             }
          %>
                  
          <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="5%" columns="2" width="100%">
                <uix:messageStyledText
                    renderedBinding="renderTarget@policyViewSettingsJspBean@servletRequest"
                    contentStyleClass="OraDataText"
                    promptBinding="LBL_TARGETNAME@policyJspBundle"
                    textBinding="targetName@policyViewSettingsJspBean@servletRequest"/>
                <uix:messageStyledText
                    renderedBinding="renderTemplate@policyViewSettingsJspBean@servletRequest"
                    contentStyleClass="OraDataText"
                    promptBinding="LBL_TEMPLATE@policyJspBundle"
                    textBinding="templateName@policyViewSettingsJspBean@servletRequest"/>
                <uix:messageStyledText
                    contentStyleClass="OraDataText"
                    promptBinding="LBL_TARGETTYPE@policyJspBundle"
                    textBinding="typeDisplay@policyViewSettingsJspBean@servletRequest"/>
               </uix:labeledFieldLayout>
         </uix:pageStatus>

          <uix:tableLayout width="100%">            
            <uix:rowLayout>
              <uix:separator/>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:spacer height="15"/>
            </uix:rowLayout>
          </uix:tableLayout>


<!-- view layout for policy settings -->

   <uix:tableLayout>
  <uix:contents>

     <uix:cellFormat vAlign="top">
      <uix:contents>

        <uix:tableLayout >
    
            <%------------------------
             -  Category
             ------------------------%>
            <uix:rowLayout>
              <%---  Prompt  ---%>
              <uix:cellFormat width="144" hAlign="right" wrappingDisabled="true">
                <uix:styledText
                  styleClass="OraPromptText"
                  textBinding="LBL_CATEGORY@policyJspBundle" />
              </uix:cellFormat>

              <%---  Field  ---%>
              <uix:spacer width="8"/>
              <uix:cellFormat>
                <uix:styledText
                  styleClass="OraDataText"
                  textBinding="categoryName@policyViewSettingsJspBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
  
            <%------------------------
             -  Description
             ------------------------%>
            <uix:rowLayout>
              <%---  Prompt  ---%>
              <uix:cellFormat width="144" hAlign="right" wrappingDisabled="true">
                <uix:styledText
                  styleClass="OraPromptText"
                  textBinding="LBL_DESCRIPTION@policyJspBundle" />
              </uix:cellFormat>

              <%---  Field  ---%>
              <uix:spacer width="8"/>
              <uix:cellFormat>
              <uix:styledList>
                <uix:styledText styleClass="OraDataText"
                                textBinding="description@policyViewSettingsJspBean@servletRequest"/>
                <uix:spacer width="3" />
                <uix:image renderedBinding ="renderHelpIcon@policyViewSettingsJspBean@servletRequest"
                           sourceBinding="descrImg@policyViewSettingsJspBean@servletRequest" 
                           shortDescBinding="SHORTDESC_HELPICON@policyJspBundle"
                           destinationBinding="descrDest@policyViewSettingsJspBean@servletRequest"/>
              </uix:styledList>
              </uix:cellFormat>
            </uix:rowLayout>
  
            <%------------------------
             -  Policy Evaluation
             ------------------------%>
            <uix:rowLayout>
              <%---  Prompt  ---%>
              <uix:cellFormat width="144" hAlign="right" wrappingDisabled="true">
                <uix:styledText
                  styleClass="OraPromptText"
                  textBinding="LBL_POLICYEVAL@policyJspBundle" />
              </uix:cellFormat>

              <%---  Field  ---%>
              <uix:spacer width="8"/>
              <uix:cellFormat>
                <uix:styledText
                  styleClass="OraDataText"
                  textBinding="policyEvalText@policyViewSettingsJspBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>

        </uix:tableLayout >
           
      </uix:contents>
      </uix:cellFormat>
 
  </uix:contents>
  </uix:tableLayout>

  <%------------------------
    - Compliance Score Setting
    ------------------------%>             
 
  <uix:header textBinding="HDR_VIOLATIONSETTING@policyJspBundle">        

  <uix:tableLayout>
  <uix:contents>
     
      <uix:cellFormat vAlign="top">
      <uix:contents>

        <uix:rowLayout>
            <uix:styledText
              styleClass="OraFieldText"
              textBinding="DESC_VIOLATIONSETTING@policyJspBundle"/>
        </uix:rowLayout>  
        <uix:spacer height="10"/>
 
        <uix:tableLayout >
  
            <%------------------------
             - Severity
            ------------------------%>             
            <uix:rowLayout>
             
              <%---  Prompt  ---%>             
              <uix:cellFormat width="125" hAlign="right" wrappingDisabled="true">
                <uix:styledText
                  styleClass="OraPromptText"
                  textBinding="LBL_SEVERITY@policyJspBundle" />
              </uix:cellFormat>

              <%---  Field  ---%>
              <uix:spacer width="8"/>
              <uix:cellFormat>
              <uix:styledText
                    styleClass="OraDataText"
                    textBinding="severityImageAltText@policyViewSettingsJspBean@servletRequest" />
<%---    
                  <uix:image 
                    sourceBinding="severityImageSrc@policyViewSettingsJspBean@servletRequest"
                    shortDescBinding="severityImageAltText@policyViewSettingsJspBean@servletRequest"
                    />
--%>
              </uix:cellFormat>
            </uix:rowLayout>

            <%------------------------
             - Importance
             ------------------------%>
            <uix:rowLayout>
              <%---  Prompt  ---%>
              <uix:cellFormat width="125" hAlign="right" wrappingDisabled="true">
                <uix:styledText
                  styleClass="OraPromptText"
                  textBinding="LBL_IMPORTANCE@policyJspBundle" />
              </uix:cellFormat>

              <%---  Field  ---%>
              <uix:spacer width="8"/>
              <uix:cellFormat>
                <uix:styledText
                  styleClass="OraDataText"
                  textBinding="viewImportance@policyViewSettingsJspBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>

         </uix:tableLayout >

      </uix:contents>
      </uix:cellFormat>
           
  </uix:contents>
  </uix:tableLayout >

  </uix:header>

<!-- Parameters -->

  <%@ include file="parametersTable.jspf"%>

<!-- Exclusions -->
  
  <%@ include file="exclusionsTable.jspf"%>

<!-- Corrective Action -->

  <%------------------------
    -  Corrective Action
    ------------------------%>     
  <uix:header textBinding="HDR_CORRECTIVEACTION@policyJspBundle">

  <uix:tableLayout >
  <uix:contents> 

      <uix:cellFormat vAlign="top">
      <uix:contents>

 
            <uix:rowLayout>
                <uix:styledText
                  styleClass="OraFieldText"
                  textBinding="DESC_CORRECTIVEACTION@policyJspBundle"/>
            </uix:rowLayout>  

            <uix:rowLayout>
              <uix:spacer width="5" />
            </uix:rowLayout>  

           <uix:tableLayout >

           <%------------------------
             - Corrective Action
            ------------------------%>             
            <uix:rowLayout>
             
              <%---  Prompt  ---%>             
              <uix:cellFormat width="125" hAlign="right" wrappingDisabled="true">
                <uix:styledText
                  styleClass="OraPromptText"
                  textBinding="HDR_CORRECTIVEACTION@policyJspBundle" />
              </uix:cellFormat>

              <%---  Field  ---%>            
              <uix:spacer width="8"/>
              <uix:cellFormat>
                <uix:link
                  styleClass="OraDataText"
                  textBinding="correctiveAction@policyViewSettingsJspBean@servletRequest"
                  destinationBinding="correctiveActionDest@policyViewSettingsJspBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
 
            <%------------------------
             -  Prevent Multiple CA
             ------------------------%>
            <uix:rowLayout>
              <%---  Prompt  ---%>
              <uix:cellFormat width="125" hAlign="right" wrappingDisabled="true">
                <uix:styledText
                  styleClass="OraPromptText"
                  textBinding="LBL_MULTIPLECA@policyJspBundle" />
              </uix:cellFormat>

              <%---  Field  ---%>
              <uix:spacer width="8"/>
              <uix:cellFormat>
                <uix:styledText
                  styleClass="OraDataText"
                  textBinding="preventMultipleCA@policyViewSettingsJspBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>

          </uix:tableLayout>
          

    </uix:contents>
    </uix:cellFormat >

  </uix:contents>
  </uix:tableLayout >

  </uix:header>

<!-- Template Override -->
  

  <%------------------------
    -  Prevent Template Override
    ------------------------%>     
  <uix:header 
      renderedBinding = "renderTemplateOverride@policyViewSettingsJspBean@servletRequest"
      textBinding="HDR_TEMPLATE_OVERRIDE@policyJspBundle">

  <uix:tableLayout >
  <uix:contents> 
  
      <uix:cellFormat vAlign="top">
      <uix:contents>

            <uix:rowLayout>
                <uix:styledText
                  renderedBinding = "renderTemplateOverride@policyViewSettingsJspBean@servletRequest"
                  styleClass="OraFieldText"
                  textBinding="INSTR_TEMPLATEOVERRIDEVIEW@policyJspBundle"/>
            </uix:rowLayout>  
 
            <uix:rowLayout>
              <uix:spacer width="5" />
            </uix:rowLayout>  
  
             <%------------------------
             -  Prevent Template Override
             ------------------------%>
            <uix:rowLayout>
              <%---  Prompt  ---%>
              <uix:cellFormat width="125" hAlign="right" wrappingDisabled="true">
                <uix:styledText
                  styleClass="OraPromptText"
                  textBinding="LBL_TEMPLATEOVERRIDE@policyJspBundle" />
              </uix:cellFormat>

              <%---  Field  ---%>
              <uix:spacer width="8"/>
              <uix:cellFormat>
                <uix:styledText
                  styleClass="OraDataText"
                  textBinding="preventOverride@policyViewSettingsJspBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>

    </uix:contents>
    </uix:cellFormat >
    
  </uix:contents>
  </uix:tableLayout >

  </uix:header>
 
        </uix:pageLayout>
      
      </oem:form>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 

<%------------------------------  End of File  -------------------------------%>
