<%--   
  -- Page:        policyViolDetails.jsp
  -- Controller:  oracle.sysman.eml.ecm.policy.PolicyViolDetailsController
  --
  --  MODIFIED    (MM/DD/YY)
  --   kchiasso    05/02/05 - render tip
  --   kchiasso    03/01/05 - support ppr go button
  --   kchiasso    02/17/05 - render desc img
  --   kchiasso    01/25/05 - edit settings
  --   groyal      01/20/05 - UI Exit review comments 
  --   kchiasso    01/07/05 - shortdesc
  --   kchiasso    01/05/05 - fix layout p/ exit review
  --   kchiasso    12/29/04 - set prompt target type 
  --   kchiasso    12/22/04 - change related link
  --   niramach    12/14/04 - Retain oracle home location url param.
  --   kchiasso    12/14/04 - set pagestatus context
  --   kchiasso    12/06/04 - incl msgHeader 
  --   kchiasso    11/22/04 - hdr; tip
  --   kchiasso    11/16/04 - context help
  --   kchiasso    11/09/04 - monitoring settings
  --   groyal      11/01/04 - Add oname and otype to copyParams 
  --   groyal      10/29/04 - Hide compliance score for ORACLE_HOME drilldowns 
  --   groyal      10/28/04 - 
  --   groyal      10/19/04 - Change Related Link to Edit Settings 
  --   groyal      10/01/04 - Remove Evaluation Status label 
  --   groyal      08/31/04 - Summary section rework
  --   groyal      08/19/04 - 
  --   groyal      08/18/04 - Update message id 
  --   kchiasso    08/16/04 - add pie chart; used PolicyJspMsg
  --   nigupta     07/07/04 - change db:form to oem:form 
  --   groyal      07/02/04 - groyal_pv_0629
  --   kchiasso    06/22/04 - fix labels
  --   kchiasso    06/18/04 - Creation (new rendition of ruleDrilldown)
  --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page contentType="text/html; charset=UTF-8" %>
<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:bundle name="policyBundle" class="oracle.sysman.eml.ecm.policy.util.PolicyJspMsg"/>

  <uix:document> 
<%@ include file="/oemTitle.jspf" %>
    <uix:body>

       <oem:form 
        copyParams="target,type,showExempted,rule,cancelURL,oname,otype,location"
        name="policyViolDetailsForm" 
        method="post"
        destination="/console/ecm/policy/policyViolDetails">
  
        <uix:formValue 
          name="pageName" 
          value="/ecm/policy/policyViolDetails"/>
          
        <uix:pageLayout
          titleBinding="title@policyViolDetailsJspBean@servletRequest">

        <%@include file="/enablePPR.jspf" %>
        <%@ include file="msgHeader.jspf" %>

           <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="5%" columns="2" width="100%">
                <uix:messageStyledText
                    contentStyleClass="OraDataText"
                    promptBinding="LBL_TARGETNAME@policyBundle"
                    textBinding="targetDisplay@policyViolDetailsJspBean@servletRequest"/>
                <uix:messageStyledText
                    contentStyleClass="OraDataText"
                    promptBinding="LBL_TARGETTYPE@policyBundle"
                    textBinding="typeDisplay@policyViolDetailsJspBean@servletRequest"/>
               </uix:labeledFieldLayout>
          </uix:pageStatus>

          <uix:tableLayout width="100%">            
            <uix:rowLayout vAlign="top">
              <uix:cellFormat columnSpan="2" >
              <uix:separator/>
              </uix:cellFormat>
            </uix:rowLayout> 
            
            <uix:rowLayout>
              <uix:cellFormat width="70%" hAlign="left">
                <uix:styledText styleClass="OraInstructionText"
                              textBinding="INSTR_VIOLDETAILS@policyBundle"/>                
              </uix:cellFormat>

              <uix:cellFormat width="30%" vAlign="top" hAlign="right" wrappingDisabled="true" >
                    <uix:spacer width="8"/>
                    <uix:styledText
                      styleClass="OraTipText"
                      textBinding="LBL_LASTEVAL@policyBundle"/>
                    <uix:spacer width="5"/>                      
                    <uix:styledText 
                      styleClass="OraTipLabel" 
                      textBinding="lastEvaluation@policyViolDetailsJspBean@servletRequest"/>                      
              </uix:cellFormat>
            </uix:rowLayout>
            
            <uix:rowLayout>
              <uix:spacer height="15"/>
            </uix:rowLayout>
          </uix:tableLayout>
         
  <uix:tableLayout>
  <uix:contents>
  
  <uix:rowLayout >
  <uix:contents>


     <uix:cellFormat vAlign="top" width="48%">
      <uix:contents>
        <uix:header textBinding="HDR_GENERAL@policyBundle">

        <uix:tableLayout >
        
            <%------------------------
             -  Severity
             ------------------------%>
            <uix:rowLayout>
              <%---  Prompt  ---%>
              <uix:spacer width="5"/>
              <uix:cellFormat hAlign="right" wrappingDisabled="true">
                <uix:styledText
                  styleClass="OraPromptText"
                  textBinding="LBL_SEVERITY@policyBundle" />
              </uix:cellFormat>

              <%---  Field  ---%>
              <uix:spacer width="8"/>
              <uix:cellFormat>
                  <uix:image 
                    sourceBinding="severityImageSrc@policyViolDetailsJspBean@servletRequest"
                    shortDescBinding="severityImageAltText@policyViolDetailsJspBean@servletRequest"
                    />
              </uix:cellFormat>
            </uix:rowLayout>
  
           <%------------------------
             -  Compliance Score
             ------------------------%>
            <uix:rowLayout renderedBinding="showComplianceScore@policyViolDetailsJspBean@servletRequest">
              <%---  Prompt  ---%>
              <uix:spacer width="5"/>
              <uix:cellFormat hAlign="right" wrappingDisabled="true">
                <uix:styledText
                  styleClass="OraPromptText"
                  textBinding="LBL_COMPLIANCESCORE@policyBundle" />
              </uix:cellFormat>

              <%---  Field  ---%>
              <uix:spacer width="5"/>
              <uix:cellFormat>
                <uix:styledText
                  styleClass="OraDataText"
                  textBinding="complianceScore@policyViolDetailsJspBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
            
           <%------------------------
             -  Risk Level
             ------------------------%>
            <uix:rowLayout>
              <%---  Prompt  ---%>
              <uix:spacer width="5"/>
              <uix:cellFormat hAlign="right" wrappingDisabled="true">
                <uix:styledText
                  styleClass="OraPromptText"
                  textBinding="LBL_IMPORTANCE@policyBundle" />
              </uix:cellFormat>

              <%---  Field  ---%>
              <uix:spacer width="8"/>
              <uix:cellFormat>
                <uix:styledText
                  styleClass="OraDataText"
                  textBinding="importance@policyViolDetailsJspBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>

            <%------------------------
             -  Category
             ------------------------%>
            <uix:rowLayout>
              <%---  Prompt  ---%>
              <uix:spacer width="5"/>
              <uix:cellFormat hAlign="right" wrappingDisabled="true">
                <uix:styledText
                  styleClass="OraPromptText"
                  textBinding="LBL_CATEGORY@policyBundle" />
              </uix:cellFormat>

              <%---  Field  ---%>
              <uix:spacer width="8"/>
              <uix:cellFormat>
                <uix:styledText
                  styleClass="OraDataText"
                  textBinding="categoryName@policyViolDetailsJspBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>

            <%------------------------
             -  Description
             ------------------------%>
            <uix:rowLayout>
              <%---  Prompt  ---%>
              <uix:spacer width="5"/>
              <uix:cellFormat hAlign="right" wrappingDisabled="true">
                <uix:styledText
                  styleClass="OraPromptText"
                  textBinding="LBL_DESCRIPTION@policyBundle" />
              </uix:cellFormat>

              <%---  Field  ---%>
              <uix:spacer width="8"/>
              <uix:cellFormat>
              <uix:styledList>
                <uix:styledText styleClass="OraDataText"
                                textBinding="description@policyViolDetailsJspBean@servletRequest"/>
                <uix:spacer width="3" />
                <uix:image renderedBinding ="renderHelpIcon@policyViolDetailsJspBean@servletRequest"
                           sourceBinding="descrImg@policyViolDetailsJspBean@servletRequest" 
                           shortDescBinding="SHORTDESC_HELPICON@policyBundle"
                           destinationBinding="descrDest@policyViolDetailsJspBean@servletRequest"/>
              </uix:styledList>
              </uix:cellFormat>
            </uix:rowLayout>

        </uix:tableLayout >
        </uix:header>
           
      </uix:contents>
      </uix:cellFormat>


<!-- next column (spacer btw columns) -->


      <uix:cellFormat>
      <uix:contents>
        <uix:spacer width="4%"/>
      </uix:contents>
      </uix:cellFormat>


<!-- next column -->

      <uix:cellFormat vAlign="top" width="48%">
      <uix:contents>
      <uix:header textBinding="HDR_OBJWITHVIOLATIONS@policyBundle">

        <uix:tableLayout >

           <%------------------------
             -  Objects Pie Chart
             ------------------------%>
            <uix:rowLayout>
            <oem:chart renderedBinding="showPieChart@policyViolDetailsJspBean@servletRequest"
                       chartType="pieChart"
                       width="410"
                       height="120"
                       shortDescBinding="DESC_VIOLPIECHART@policyBundle"
                       pieValuesInLegend="value"
                       showSlicePercentLabels="true"
                       pieSliceColorsBinding="pieChartColors@policyViolDetailsJspBean@servletRequest"
                       backgroundColorBinding="policyViolDetailsJspBean@policyViolDetailsJspBean@servletRequest"
                       hideZeroSlices="true"
                       legendPosition="east"
                       legendWidthFraction="0.75">
             <oem:boundChartDataSource chartDataSourceBinding="pieChartData@policyViolDetailsJspBean@servletRequest"/>

             <oem:chartColumn isKey="true"
                              displayLabel="label"
                              sourceIndex="0"/>
             <oem:chartColumn displayLabel="text"
                              sourceIndex="1"/>    

             </oem:chart>
            </uix:rowLayout>           
            
            <%------------------------
             -  Objects with Violations
             ------------------------%>
            <uix:rowLayout renderedBinding="noShowPieChart@policyViolDetailsJspBean@servletRequest">
              <%---  Prompt  ---%>
              <uix:spacer width="5"/>
              <uix:cellFormat hAlign="right" wrappingDisabled="true">
                <uix:styledText
                  styleClass="OraPromptText"
                  textBinding="LBL_OBJWITHVIOLATIONS@policyBundle" />
              </uix:cellFormat>

              <%---  Field  ---%>
              <uix:spacer width="8"/>
              <uix:cellFormat>
                <uix:styledText
                  styleClass="OraDataText"
                  textBinding="objsWithViolations@policyViolDetailsJspBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>

            <%------------------------
             -  Objects with Exempted Violations
             ------------------------%>
            <uix:rowLayout renderedBinding="noShowPieChart@policyViolDetailsJspBean@servletRequest">
              <%---  Prompt  ---%>
              <uix:spacer width="5"/>
              <uix:cellFormat hAlign="right" wrappingDisabled="true">
                <uix:styledText
                  styleClass="OraPromptText"
                  textBinding="LBL_OBJWITHEXEMPTEDVIOLATIONS@policyBundle" />
              </uix:cellFormat>

              <%---  Field  ---%>
              <uix:spacer width="8"/>
              <uix:cellFormat>
                <uix:styledText
                  styleClass="OraDataText"
                  textBinding="objsWithExemptedViolations@policyViolDetailsJspBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
            
            
        </uix:tableLayout >
        </uix:header>

      </uix:contents>
      </uix:cellFormat>

  </uix:contents>
  </uix:rowLayout >
  

<!-- Impact and recommendation -->

  <uix:rowLayout >
  <uix:contents> 

            <%------------------------
             -  Impact of Problem
             ------------------------%>     
            <uix:cellFormat vAlign="top" width="48%">               
            <uix:header textBinding="LBL_IMPACT@policyBundle">
 
            <uix:rowLayout>
                <uix:styledText
                  styleClass="OraFieldText"
                  textBinding="impactOfProblem@policyViolDetailsJspBean@servletRequest"/>
            </uix:rowLayout>  

            </uix:header>
            </uix:cellFormat>
 

<!-- next column (spacer btw columns) -->

      <uix:cellFormat>
      <uix:contents>
        <uix:spacer width="4%"/>
      </uix:contents>
      </uix:cellFormat>


<!-- next column -->

            <%------------------------
             -  Recommendation
             ------------------------%>
            <uix:cellFormat vAlign="top" width="48%">
            <uix:header textBinding="LBL_RECOMMENDATION@policyBundle">
              
            <uix:rowLayout>
                <uix:styledText
                  styleClass="OraFieldText"
                  textBinding="recommendation@policyViolDetailsJspBean@servletRequest"/>
            </uix:rowLayout>

            </uix:header>
            </uix:cellFormat>            


  </uix:contents>
  </uix:rowLayout >
  
  </uix:contents>
  </uix:tableLayout >

                       
          <%------------------------
           -  Violations Table Header
           ------------------------%>
          <uix:header 
            textBinding="HDR_VIOLATIONS@policyBundle">
          
            <%--------------------------
             - Violations Shown Choice 
             ---------------------------%>
            <uix:spacer height="10"/>
            <uix:tableLayout width="100%">
              <uix:rowLayout>
                <uix:cellFormat>
                  <uix:rowLayout>

                    <uix:styledText
                      styleClass="OraPromptText"
                      labeledNodeId="violationsShownSetting"
                      textBinding="VIEW@policyBundle"
                      />
                    <uix:spacer width="5"/>
                    <uix:choice 
                      primaryClientActionBinding="choiceAction@servletRequest"                   
                      id="ppviolationsShownSetting"
                      name="violationsShownSetting" 
                      selectedValueBinding="violationsShownSetting@policyViolDetailsJspBean@servletRequest"
                      >
                      <uix:option
                        textBinding="VIOLATIONS@policyBundle"
                        value="N"
                        />
                      <uix:option
                        textBinding="VIOLATIONS_INCLUDEEXEMPTED@policyBundle"
                        value="Y"
                        />
                    </uix:choice>
                   

                  </uix:rowLayout>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout> 
            
            <uix:spacer height="5"/>

            <uix:tableLayout width="100%">
            <uix:rowLayout>

              <%------------------------
              -  Violations Table
              ------------------------%>
              <uix:include nodeBinding="tableBean@policyViolDetailsJspBean@servletRequest"/>
              <%--uix:table 
                width="100%"
                blockSize="25"
                formSubmitted="true"
                name="ruleDrilldownTable" 
                tableDataBinding="violationListData@policyViolDetailsJspBean@servletRequest"
                columnHeaderDataBinding="violationListColHeaderData@policyViolDetailsJspBean@servletRequest"
                alternateTextBinding="NO_RESULT_FOUND@policyBundle"
                <uix:tableFormat tableBanding="rowBanding"/>
                <uix:columnHeaderStamp>
                  <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
                </uix:columnHeaderStamp>  
                <uix:contents>
                </uix:contents>
              </uix:table--%>  
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:styledText id="pptip" styleClass="OraTipLabel"
                    textBinding = "multiSelTip@policyViolDetailsJspBean@servletRequest" />
            </uix:rowLayout>


          </uix:tableLayout> 
          </uix:header>

          <%------------------------
           -  Related Links
           ------------------------%>

          <uix:header 
            textBinding="RELATED_LINK@policyBundle">         

          <uix:tableLayout>

            <uix:rowLayout>
              <%---  Edit Policy Settings  ---%>
              <uix:cellFormat hAlign="left">
                  <uix:link textBinding="BTN_MANAGESETTINGS@policyBundle" 
                      destinationBinding="editSettingsDest@servletRequest" />                                              
              </uix:cellFormat>
            </uix:rowLayout>     
            
          </uix:tableLayout> 
          
          </uix:header>         

          <%-------------------------
           -  Page Buttons
           ---------------------------%>
          <uix:pageButtons>
            <uix:pageButtonBar>

            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </oem:form>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 

<%------------------------------  End of File  -------------------------------%>
