<%--
  -- Page:        policyViolExempt.jsp
  -- Controller:  oracle.sysman.eml.ecm.policy.PolicyAddCommentExemptController
  --
  --  MODIFIED    (MM/DD/YY)
  --   kchiasso    07/21/05 - add btn sd
  --   kchiasso    12/13/04 - set pagestatus context
  --   kchiasso    12/06/04 - incl msgHeader 
  --   kchiasso    11/15/04 - comment
  --   niramach    09/28/04 - Creation
  --%>
<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.eml.ecm.policy.PolicyJspConstants" %>

<uix:renderingContext id="renderingContext">
 <oem:setURLEncoder id="renderingContext"/>
 <uix:bundle name="policyBundle" class="oracle.sysman.eml.ecm.policy.util.PolicyJspMsg"/>   
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>  
    <uix:body>
      <uix:form name="exemptViolForm" method="post">           
        <uix:pageLayout
            titleBinding="PAGE_TITLE_ADDEXEMPTION@policyBundle@servletRequest">
        <uix:formValue 
          name="pageName" 
          value="/ecm/policy/policyViolDetails"/>
        
        <%@ include file="msgHeader.jspf" %>
        
        <uix:pageStatus>
            <uix:styledText styleClass="OraInstructionText"
                              textBinding="INSTR_EXEMPTVIOLATION@policyBundle"/>
        </uix:pageStatus> 
        <uix:tableLayout width="100%">            
            <uix:rowLayout>
                <uix:tip styleClass="OraInstructionText"
                              textBinding="INSTR_EXEMPTHELP@policyBundle"/>
            </uix:rowLayout>
        </uix:tableLayout>
      
  <uix:tableLayout>
  <uix:contents>

     <uix:cellFormat vAlign="top">
      <uix:contents>
      
        <uix:spacer height = "8"/>

        <uix:tableLayout >
            
           <%------------------------
             - Exempt Until
            ------------------------%>             
            <uix:rowLayout>
             
              <%---  Prompt  ---%>             
              <uix:spacer width="20"/>
              <uix:cellFormat hAlign="right" wrappingDisabled="true">
                <uix:styledText
                  styleClass="OraPromptText"
                  textBinding="LBL_EXEMPTUNTIL@policyBundle" />
              </uix:cellFormat>

              <%---  Choice  ---%>            
              <uix:spacer width="5"/>
              <uix:cellFormat>
                  <uix:radioButton
                      name="exemptOption"                      
                      value="1"
                      selectedBinding="explicitlyRemovedOpt@policyViolExemptJspBean@servletRequest"
                      selectedValue="explicitlyRemoved"
                      textBinding="EXEMPT_MANUAL@policyBundle@servletRequest"/>                      
               </uix:cellFormat>
            </uix:rowLayout>
               
            <uix:rowLayout>
             <uix:spacer width="20"/>
              <uix:cellFormat hAlign="right" wrappingDisabled="true">
                <uix:spacer width="10" />
              </uix:cellFormat>

              <%---  Choice  ---%>            
             <uix:spacer width="5"/>
              <uix:cellFormat>
                  <uix:radioButton
                      name="exemptOption"
                      value="3"
                      selectedBinding="nextEvalOpt@policyViolExemptJspBean@servletRequest"
                      textBinding="EXEMPT_NEXTEVAL@policyBundle@servletRequest"/>                      
               </uix:cellFormat>
            </uix:rowLayout>
              
            <uix:rowLayout>

             <uix:spacer width="20"/>
              <uix:cellFormat hAlign="right" wrappingDisabled="true">
                <uix:spacer width="10" />
              </uix:cellFormat>

             <%---  Choice  ---%>            
              <uix:spacer width="5"/>
              <uix:cellFormat>
                       <uix:radioButton
                          name="exemptOption"
                          value="2"
                          selectedBinding="specificDateOpt@policyViolExemptJspBean@servletRequest"
                          textBinding="EXEMPT_DATE@policyBundle@servletRequest"
                          />  
                         <uix:dateField name="specificDate"
                            valueBinding="specificDate@policyViolExemptJspBean@servletRequest"/>                  
              </uix:cellFormat>
            </uix:rowLayout>


        </uix:tableLayout >
           
      </uix:contents>
      </uix:cellFormat>
 
  </uix:contents>
  </uix:tableLayout>
               
    <uix:stackLayout>
    
              <uix:header styleClass="OraFieldText" 
                              textBinding="BTN_ADDCOMMENT@policyBundle@servletRequest">                        
              <uix:contents>
                <uix:textInput name="comment" 
                               rows="10" 
                               textBinding="comment@policyViolExemptJspBean@servletRequest"                               
                               maximumLength="4000"
                               columns="120"/>
              </uix:contents>
              </uix:header>                         
              
    </uix:stackLayout>
               
            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton name ="event" formName="exemptViolForm" 
                  textBinding="BTN_CANCEL@policyBundle@servletRequest"
                  shortDescBinding="BTN_CANCEL@policyBundle@servletRequest"
                  value="cancel"/>
                <uix:submitButton name ="event" formName="exemptViolForm" 
                  textBinding="BTN_OK@policyBundle@servletRequest"
                  shortDescBinding="BTN_OK@policyBundle@servletRequest"
                  value="ok"/>
              </uix:pageButtonBar>
            </uix:pageButtons>          
        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>