<%--
  -- Page:        policyViolations.jsp
  -- Controller:  oracle.sysman.eml.ecm.policy.PolicyViolationsController
  --
  -- Description: Launched when user selects "search" action
  --
  --  MODIFIED    (MM/DD/YY)
  --   vivsharm    05/19/06 - oc4j 1013 
  --   sthiruna    08/01/06 - Copying 10.2.0.3 Config Standard changes from
  --                          EMCORE_MAIN_LINUX
  --   kchiasso    01/11/06 - new subtabs
  --   kchiasso    08/23/05 - dont set width count
  --   kchiasso    08/17/05 - rmv object for performance
  --   kchiasso    05/05/05 - set no search conducted if progress cancel
  --   groyal      02/04/05 - Change policyMsgBundle to msgBundle
  --   kchiasso    01/18/05 - rmv last eval
  --   kchiasso    01/07/05 - reorder per UI review
  --   kchiasso    01/05/05 - 'post' req'd as of 2.2.15 upgrade
  --   akskumar    12/28/04 - oem:license for violation count column 
  --   kchiasso    12/22/04 - set hidden guid / get for bookmarking
  --   kchiasso    12/15/04 - include msgHeader
  --   kchiasso    11/22/04 - hdr
  --   akskumar    11/24/04 -  licensing work, disable links on rows 
  --   kchiasso    10/27/04 - remove separator 
  --   kchiasso    10/05/04 - ppr; showall
  --   groyal      09/23/04 - Fix severity label
  --   groyal      09/22/04 - Add refreshed 
  --   groyal      09/21/04 - 
  --   groyal      09/02/04 - Fix violation count column
  --   groyal      08/18/04 - Update mesage id 
  --   groyal      08/12/04 - Add tooltip for severity 
  --   groyal      08/06/04 - Fix policy rule link 
  --   kchiasso    07/30/04 - add view rule link
  --   kchiasso    07/28/04 - uix constants
  --   groyal      07/02/04 - groyal_pv_0629
  --   kchiasso    06/21/04 - add dest_details
  --   groyal      06/22/04 - 
  --   kchiasso    06/09/04 - kchiasso_newpolicyviolations
  --   kchiasso    06/08/04 - Creation
  --%>

<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%-- Imports --%>
<%@ page import="oracle.sysman.eml.ecm.policy.PolicyJspConstants" %>
<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="msgBundle"
    class="oracle.sysman.eml.ecm.policy.util.PolicyJspMsg" />
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/enablePPR.jspf"%>

    <uix:body>
        <uix:pageLayout titleBinding="PAGE_TITLE_VIOL@msgBundle">
        <%@ include file="msgHeader.jspf" %>

    <uix:dataScope currentDataBinding="policyViolationsJspBean@servletRequest"> 

         <uix:subTabLayout>
          <uix:subTabs>
              <uix:subTabBar selectedIndex="0">
              <uix:contents>
                   <uix:link textBinding="TAB_VIOLATIONS@msgBundle"
                              destinationBinding="<%= PolicyJspConstants.S_TAB_VIOLATIONS %>" />
                   <uix:link textBinding="TAB_LIBRARY@msgBundle"
                              destinationBinding="<%= PolicyJspConstants.S_TAB_LIBRARY %>" />
                   <uix:link textBinding="TAB_ASSOCIATIONS@msgBundle"
                              destinationBinding="<%= PolicyJspConstants.S_TAB_ASSOCIATIONS %>" />
                   <uix:link textBinding="TAB_ERRORS@msgBundle"
                              destinationBinding="<%= PolicyJspConstants.S_TAB_ERRORS %>" />
                  </uix:contents>
              </uix:subTabBar>
          </uix:subTabs>
          <uix:contents>

     
    <uix:form nameBinding="eml_ecm_sc_formName@servletRequest" 
              method="post">


          <uix:pageButtons>
            <uix:pageButtonBar>
             </uix:pageButtonBar>
          </uix:pageButtons>


              <uix:pageStatus>
                <uix:tableLayout width="100%">
                 <uix:contents>                     
                  <uix:cellFormat width="60%">
                   <uix:rowLayout>
                    <uix:styledText styleClass="OraInstructionText" 
                                    textBinding="INSTR_SEARCH_VIOL@msgBundle" /> 
                   </uix:rowLayout>
                  </uix:cellFormat>
                  <uix:cellFormat width="40%" vAlign="top">
                   <uix:rowLayout hAlign="right">
                    <oem:pageRefreshed/>
                   </uix:rowLayout>
                  </uix:cellFormat> 
                 </uix:contents>
                </uix:tableLayout>
              </uix:pageStatus>

<uix:include nodeBinding="eml_ecm_sc_uiNode@servletRequest"/>

          <uix:stackLayout>

            <uix:spacer height="10"/>
            
            <uix:table name="policyViolationsList" 
                       id = "policyViolationsList"
                       partialRenderMode="self"
                       showAll="yes"
                       alternateTextBinding="<%= PolicyJspConstants.S_ALT_TEXT_ATTR %>"
                       formSubmitted="true"
                       width="100%"
                       minValue="1"
                       tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                       valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                       maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                       blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                       summaryBinding="TBLSUM_RESULTSTABLE@msgBundle">
               
                <uix:tableFormat tableBanding="rowBanding"/>

                <%-- Severity column --%>
                <uix:column> 
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="LBL_SEVERITY@msgBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_SEVERITY %>" />
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="textFormat"/>
                  <uix:styledText textBinding="<%= PolicyJspConstants.S_LBL_SEVERITY %>"/>
                 <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                  <uix:image sourceBinding="<%= PolicyJspConstants.S_IMG_SEVERITY %>" 
                             shortDescBinding="<%= PolicyJspConstants.S_SHORT_SEVERITY %>"/>

                </uix:column>
                
               <%-- Violation Count column --%>
                <uix:column> 
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="LBL_VIOLATIONCOUNT@msgBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_VIOLATIONCOUNT %>" />
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="numberFormat"/>
                  <uix:flowLayout>
                      <oem:license>
                          <uix:link textBinding= "<%= PolicyJspConstants.S_LBL_VIOLATIONCOUNT %>"
                                      destinationBinding= "<%= PolicyJspConstants.S_DEST_DETAILS %>" />
                      </oem:license>            
                      <uix:spacer width="3"
                                    renderedBinding= "<%= PolicyJspConstants.S_RENDER_EXEMPTCOUNT %>"/>
                        <uix:styledText textBinding= "<%= PolicyJspConstants.S_LBL_EXEMPTCOUNT %>" 
                                        renderedBinding= "<%= PolicyJspConstants.S_RENDER_EXEMPTCOUNT %>" />
                  </uix:flowLayout>
                </uix:column>

                <%-- Objects column --%>
<%-- remove for performance

                <uix:column> 
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="LBL_OBJECTS@msgBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_OBJTYPE %>" />
                  </uix:columnHeader> 
                  <uix:columnFormat width="10" cellNoWrapFormat="false" columnDataFormat="textFormat"/>
                  <uix:styledList>
                    <uix:styledText textBinding="<%= PolicyJspConstants.S_LBL_OBJTYPE %>"/>

<%
              for (int idx = 0; idx <= 10; idx++)
              {
                  String lbl = "LBL_OBJECT__"+idx;
                  String dest = "DEST_OBJECT__"+idx;
                  String render = "RENDER_OBJECT__"+idx;
%>
                   <uix:spacer width="3" 
                                renderedBinding= "<%= render %>"/>
                    <uix:link textBinding="<%= lbl %>"
                            destinationBinding="<%= dest %>"
                            renderedBinding= "<%= render %>" />

<%
              } // for
%>
                  </uix:styledList>
                </uix:column>
--%>

                <%-- Policy Rule column --%>
                <uix:column> 
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="LBL_POLICYRULE@msgBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_POLICYRULE %>" />
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="textFormat"/>
                  <oem:license>
                      <uix:link textBinding="<%= PolicyJspConstants.S_LBL_POLICYRULE %>"
                                destinationBinding="<%= PolicyJspConstants.S_DEST_POLICYRULE  %>" />
                  </oem:license>
                </uix:column>

                <%-- Target column --%>
                <uix:column> 
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="LBL_TARGET@msgBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_TARGET %>" />
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="textFormat"/>
                  <uix:link textBinding="<%= PolicyJspConstants.S_LBL_TARGET %>"
                            destinationBinding="<%= PolicyJspConstants.S_DEST_TARGET %>" />
                </uix:column>

                <%-- Type column --%>
                <uix:column> 
                  <uix:columnHeader>
                   <uix:sortableHeader textBinding="LBL_TYPE@msgBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_TYPE %>" />
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="textFormat"/>
                  <uix:styledText textBinding="<%= PolicyJspConstants.S_LBL_TYPE %>"/>
                </uix:column>

                <%-- Most Recent Violation  column--%>
                <uix:column> 
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="LBL_RECENTVIOLATION@msgBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_RECENTVIOLATION %>" />
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="linkFormat"/>
                  <uix:styledText textBinding="<%= PolicyJspConstants.S_LBL_RECENTVIOLATION %>"/>
                </uix:column>

                <%-- Category column --%>
                <uix:column> 
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="LBL_CATEGORY@msgBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_CATEGORY %>" />
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="textFormat"/>
                  <uix:styledText textBinding="<%= PolicyJspConstants.S_LBL_CATEGORY %>"/>
                </uix:column>

                <%-- Compliance Score column --%>
                <uix:column> 
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="LBL_COMPLIANCESCORE@msgBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_CSCORE  %>" />
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="numberFormat"/>
                  <uix:styledText textBinding="<%= PolicyJspConstants.S_LBL_CSCORE %>"/>
                </uix:column>

                <%-- Non Compliant Since column --%>
                <uix:column> 
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="LBL_NONCOMPLIANTSINCE@msgBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_NONCOMPLIANTSINCE %>" />
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="dateFormat"/>
                  <uix:styledText textBinding="<%= PolicyJspConstants.S_LBL_NONCOMPLIANTSINCE %>"/>
                </uix:column>

                <%--  hidden policyGuid --%>
                <uix:formValue id="policyGuid" name="policyGuid" 
                                 valueBinding="<%= PolicyJspConstants.S_HIDDEN_POLICYGUID %>"/>


              </uix:table>
              
          </uix:stackLayout>
          
         
    </uix:form>

           </uix:contents>
          </uix:subTabLayout>
           
   </uix:dataScope>
      </uix:pageLayout>

   </uix:body>
  </uix:document>
</uix:renderingContext>
<%------------------------------  End of File  -------------------------------%>
