<%--
  -- Page:        policyGroupTrendOverview.jsp
  -- Controller:  oracle.sysman.eml.ecm.policy.trend.PolicyTrendOverviewController
  --
  --  MODIFIED    (MM/DD/YY)  
  --   niramach    08/23/05 - Fix for bug 4563113.Increase the pie chart width and height
  --                        - to work for more number of slices. 
  --                        - Set the tool tips for data points
  --   kchiasso    07/21/05 - add btn sd
  --   niramach    06/17/05 - Fix for bug 4096329. 
  --   niramach    05/27/05 - Set yaxis min and max values for comp score 
  --                          chart as 0 and 100.
  --   groyal      02/14/05 - Increase width of violation count by severity 
  --                          chart 
  --   groyal      01/20/05 - UI Exit review comments 
  --   niramach    12/28/04 - chart conversions as per UI review comments
  --%>
  
<%@ include file="/sdk/oemTop.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import="oracle.sysman.eml.ecm.policy.PolicyJspConstants" %>

<jsp:useBean id="trendOverviewBean" scope="request" type="oracle.sysman.eml.ecm.policy.trend.PolicyGroupTrendOverviewJspBean"/>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="policyBundle"
    class="oracle.sysman.eml.ecm.policy.util.PolicyJspMsg" />
  <uix:document>
    <%@ include file="/oemTitle.jspf"%>
    <%@ include file="/enablePPR.jspf" %>
    <uix:body>    
    <uix:form name="groupTrendOverviewForm" method="get"> 
      <uix:pageLayout>
      <%@ include file="/oemGlobal.jspf" %>
        <uix:header textBinding="HDR_VIOL_TRENDOVERVIEW@policyBundle">                      
            <uix:stackLayout>             
             <uix:rowLayout width="100%">
                <uix:cellFormat hAlign="right">
                <uix:styledText
                  styleClass="OraTipText"
                  textBinding="collectedDataLabel@trendOverviewBean@servletRequest"/>
                <uix:spacer width="5"/>                      
                <uix:styledText 
                  styleClass="OraTipLabel" 
                  textBinding="latestCollectedDate@trendOverviewBean@servletRequest"/>                                      
                </uix:cellFormat>                  
               </uix:rowLayout> 
               
              <uix:rowLayout width="100%">                              
                <uix:cellFormat hAlign="right">
                    <%-- Time period pull down menu --%>                        
                  <uix:styledText styleClass="OraFieldText" 
                    textBinding="LBL_VIEWDATA@policyBundle"/>
                  <uix:spacer width="10"/>
                    <uix:choice name="timePeriod" onChange="submitForm('groupTrendOverviewForm', true, {'event':'timePeriodChg'})"
                            selectedValueBinding="selectedViewData@servletRequest">
                            <uix:contents childDataBinding="viewDataDataSrc@trendOverviewBean@servletRequest">
                                <uix:option textBinding="text" valueBinding="value" />
                            </uix:contents>
                    </uix:choice>  
                      <uix:spacer width="5"/>
                      <uix:switcher childNameBinding="editCustom@trendOverviewBean@servletRequest">
                          <uix:case name="true">
                              <uix:submitButton name="event" value="timePeriodChg" 
                                    shortDescBinding="BTN_EDIT@policyBundle"
                                    textBinding="BTN_EDIT@policyBundle" />
                           </uix:case>                         
                       </uix:switcher>             
                   </uix:cellFormat>
            </uix:rowLayout>                 
            
            <uix:tableLayout>
              <%-- New violations by category pie chart --%>
              <uix:rowLayout>
                <uix:contents>
                <uix:cellFormat width="50%" vAlign="top" hAlign="left">
                <uix:header textBinding="violByCategoryHeader@trendOverviewBean@servletRequest">                                                
                <uix:switcher childNameBinding="newViolByCategoryFlag@trendOverviewBean@servletRequest">
                <uix:case name="true">
                  <oem:chart                       
                        chartType="pieChart" 
                        width="500" 
                        height="150" 
                        legendWidthFraction="0.75"    
                        shortDescBinding="violByCategoryHeader@trendOverviewBean@servletRequest"
                        pieValuesInLegend="value" 
                        showSlicePercentLabels="true" 
                        hideZeroSlices="true"
                        >
                    <oem:boundChartDataSource 
                        chartDataSourceBinding="categoryPieChartDataSource@trendOverviewBean@servletRequest"/>
                    <oem:imageMap imageMapItemsBinding="pieChartImageMap@trendOverviewBean@servletRequest"/>
                    <oem:chartColumn 
                        isKey="true"                      
                        displayLabel="Category"
                        sourceIndex="0"/>
                    <oem:chartColumn                         
                        sourceIndex="1"/>
                  </oem:chart>
                  </uix:case>
                  <uix:case name="false">
                        <uix:rowLayout>
                            <uix:styledText
                                styleClass="OraFieldText"
                                textBinding="noNewViolMsg@trendOverviewBean@servletRequest"/>
                        </uix:rowLayout>                    
                 </uix:case>
                 </uix:switcher>
                </uix:header>
                </uix:cellFormat>
                <uix:spacer width="10"/>
                 <uix:cellFormat hAlign="right" width="50%" vAlign="top">
                    <uix:header textBinding="violByTargetHeader@trendOverviewBean@servletRequest"> 
                    <uix:switcher childNameBinding="newViolByTargetFlag@trendOverviewBean@servletRequest">
                        <uix:case name="true">
                            <oem:chart 
                                chartType="pieChart" 
                                width="500" 
                                height="150" 
                                legendWidthFraction="0.75"
                                shortDescBinding="violByTargetHeader@trendOverviewBean@servletRequest"                     
                                pieValuesInLegend="value" 
                                showSlicePercentLabels="true" 
                                hideZeroSlices="true">
                            <oem:boundChartDataSource 
                                chartDataSourceBinding="targetTypePieChartDS@trendOverviewBean@servletRequest"/>
                            <oem:imageMap 
                                imageMapItemsBinding="targetPieChartImageMap@trendOverviewBean@servletRequest"/>
                            <oem:chartColumn 
                                isKey="true"                        
                                displayLabel="Target Type"
                                sourceIndex="0"/>
                            <oem:chartColumn sourceIndex="1"/>
                            </oem:chart>
                        </uix:case>                  
                        <uix:case name="false">
                        <uix:rowLayout >
                            <uix:styledText
                                styleClass="OraFieldText"
                                textBinding="noNewViolMsg@trendOverviewBean@servletRequest"/>
                        </uix:rowLayout>                    
                        </uix:case>
                    </uix:switcher>                        
                </uix:header>     
                </uix:cellFormat>
                </uix:contents>
              </uix:rowLayout>
              </uix:tableLayout>
              
              <uix:tableLayout>
              <%-- Trend overview header--%>
              <uix:rowLayout>
                <uix:header textBinding="violHeader@trendOverviewBean@servletRequest">     
                
                   <%-- Category filter --%>
                  <uix:rowLayout>     
                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                    <uix:styledText styleClass="OraFieldText" textBinding="LBL_CATEGORY@policyBundle"/>
                  </uix:cellFormat>
                  <uix:spacer width="10"/>
                  <uix:choice name="category"                     
                    selectedValueBinding="selectedCategoryData@servletRequest">
                    <uix:contents childDataBinding="categoryDataSrc@trendOverviewBean@servletRequest">
                    <uix:option textBinding="text" valueBinding="value" />
                    </uix:contents>
                  </uix:choice>         
                  
                  <uix:spacer width="10"/>                                
                  
                  <%-- Target type filter --%>
                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                    <uix:styledText styleClass="OraFieldText" textBinding="LBL_MEMBERTARGETTYPE@policyBundle"/>
                  </uix:cellFormat>  
                  <uix:spacer width="10"/>
                  <uix:choice name="targetTypeFilter"                     
                    selectedValueBinding="selectedTargetTypeData@servletRequest">
                    <uix:contents childDataBinding="targetTypeDataSrc@trendOverviewBean@servletRequest">
                    <uix:option textBinding="text" valueBinding="value" />
                    </uix:contents>
                  </uix:choice>                      
                             
                  <uix:spacer width="10"/>
                  
                  <%-- Go button --%>                 
                  <uix:cellFormat>
                    <uix:submitButton name="event" value="Refresh"
                        shortDescBinding="BTN_GO@policyBundle"
                        textBinding="BTN_GO@policyBundle" />
                  </uix:cellFormat>                        
                  </uix:rowLayout>
                  
                  <uix:separator/>
                   <uix:rowLayout>                    
                    <uix:cellFormat hAlign="left" vAlign="top" width="50%">
                    <%-- Policy violations Summary Table -rollup by severity--%>                        
                      <uix:ref refID="POLICY_VIOLATIONS_SUMMARY_rollupBySeverity"/>                                              
                    </uix:cellFormat>                  
                      <uix:cellFormat hAlign="right" vAlign="top" width="50%">
                        <%-- Violation count by Severity chart --%>
                        <uix:header textBinding="HDR_VIOL_COUNT_BY_SEVERITY@policyBundle">                                                                        
                          <oem:chart 
                            chartType="timeSeriesBarChart" 
                            width="480" 
                            height="220" 
                            orientation="vertical"                             
                            seriesSymbolsAutomatic="true"                      
                            legendPosition="east"
                            legendWidthFraction="0.75"
                            xAxisMinBinding="violCountXAxisMin@trendOverviewBean@servletRequest" 
                            xAxisMaxBinding="violCountXAxisMax@trendOverviewBean@servletRequest" 
                            timeGranularity="HOUR"     
                            timeLabelAlignment="wholeXAxis" 
                            barWidthFraction="0.25"
                            stacked="true"                                                                        
                            shortDescBinding="HDR_VIOL_COUNT_BY_SEVERITY@policyBundle">
                            <uix:contents>
                              <oem:boundChartDataSource chartDataSourceBinding="violCountChartDataSource@trendOverviewBean@servletRequest"/>                             
                              <oem:imageMap 
                                imageMapItemsBinding="violCountChartImageMap@trendOverviewBean@servletRequest"/>                                                                                                                        
                              <oem:chartColumn isTimeColumn="true" displayLabel="Date" 
                                sourceIndex="3"/>
                                
                               <%-- Item colors are as per the severity level icon colors used in
                               violations pages.Colors are picked up from oracle.sysman.eml.mntr.target.TargetData
                                --%>                                  
                              <oem:chartColumn 
                                displayLabelBinding="criticalViolLegend@trendOverviewBean@servletRequest" 
                                sourceIndex="2"
                                itemColor="#FF0000"/>                                                                                                
                              
                              <oem:chartColumn 
                                displayLabelBinding="warningViolLegend@trendOverviewBean@servletRequest" 
                                sourceIndex="1"
                                itemColor="yellow"/>                                
                              
                              <oem:chartColumn 
                                displayLabelBinding="infoViolLegend@trendOverviewBean@servletRequest" 
                                sourceIndex="0"
                                itemColor="#6699CC"/>
                            </uix:contents>
                          </oem:chart>
                        </uix:header>
                      </uix:cellFormat>                                      
                   </uix:rowLayout>                       
                   
                   <uix:rowLayout>
                   <uix:cellFormat hAlign="left" vAlign="top" width="50%">
                    <%-- Compliance score --%>
                     <uix:header textBinding="LBL_COMPLIANCESCORE@policyBundle">  
                      <oem:chart 
                        chartType="timeSeriesChart" 
                        width="420" 
                        height="220" 
                        orientation="vertical" 
                        seriesColorsAutomatic="true" 
                        seriesSymbolsAutomatic="true"                         
                        legendVisible="false"
                        xAxisMinBinding="compScoreXAxisMin@trendOverviewBean@servletRequest" 
                        xAxisMaxBinding="compScoreXAxisMax@trendOverviewBean@servletRequest"                         
                        axisMin="0"
                        axisMax="100"
                        timeGranularity="HOUR"
                        shortDescBinding="LBL_COMPLIANCESCORE@policyBundle">
                        <uix:contents>
                          <oem:boundChartDataSource chartDataSourceBinding="complianceScoreDataSource@trendOverviewBean@servletRequest"/>                          
                          <oem:imageMap 
                            imageMapItemsBinding="compScoreChartImageMap@trendOverviewBean@servletRequest"/>                                              
                          <oem:chartColumn isTimeColumn="true" displayLabel="Date" sourceIndex="1"/>
                          <oem:chartColumn sourceIndex="0"/>
                        </uix:contents>
                      </oem:chart>
                    </uix:header>
                    </uix:cellFormat>                                                
                     <uix:cellFormat hAlign="right" vAlign="top" width="50%">
                        <%-- Number of member targets by compliance score chart --%>
                        <uix:header textBinding="HDR_TARGETS_BY_COMPSCORE@policyBundle">                                                                        
                          <oem:chart 
                            chartType="timeSeriesBarChart" 
                            width="480" 
                            height="220" 
                            orientation="vertical"                             
                            seriesSymbolsAutomatic="true"   
                            legendPosition="east"
                            legendWidthFraction="0.75"
                            xAxisMinBinding="targetsByCompScoreXAxisMin@trendOverviewBean@servletRequest" 
                            xAxisMaxBinding="targetsByCompScoreXAxisMax@trendOverviewBean@servletRequest"                         
                            timeGranularity="HOUR"                             
                            timeLabelAlignment="wholeXAxis" 
                            shortDescBinding="HDR_TARGETS_BY_COMPSCORE@policyBundle"
                            barWidthFraction="0.25"
                            stacked="true">
                            <uix:contents>
                              <oem:boundChartDataSource chartDataSourceBinding=
                                "targetsByCompScoreDataSource@trendOverviewBean@servletRequest"/>  
                              <oem:imageMap 
                                    imageMapItemsBinding="targetsByCompScoreImageMap@trendOverviewBean@servletRequest"/>                                 
                              <oem:chartColumn isTimeColumn="true" displayLabel="Date" 
                                sourceIndex="5"/>
                               
                              <oem:chartColumn 
                                displayLabelBinding="level1CompScoreLegend@trendOverviewBean@servletRequest" 
                                sourceIndex="0"
                                itemColor="red"/>                                                                                                
                              
                              <oem:chartColumn 
                                displayLabelBinding="level2CompScoreLegend@trendOverviewBean@servletRequest" 
                                sourceIndex="1"
                                itemColor="yellow"/>                                                                                                
                              
                              <oem:chartColumn 
                                displayLabelBinding="level3CompScoreLegend@trendOverviewBean@servletRequest" 
                                sourceIndex="2"
                                itemColor="green"/>                                                                                                
                                
                               <oem:chartColumn 
                                displayLabelBinding="level4CompScoreLegend@trendOverviewBean@servletRequest" 
                                sourceIndex="3"
                                itemColor="blue"/> 
                                
                               <%--#00FF99 is for cyan.Since cyan is not accepted by chart, color code value is given--%> 
                               <oem:chartColumn 
                                displayLabelBinding="level5CompScoreLegend@trendOverviewBean@servletRequest" 
                                sourceIndex="4"
                                itemColor="#00FF99"
                                />                                 
                            </uix:contents>
                          </oem:chart>
                        </uix:header>
                      </uix:cellFormat>
                  </uix:rowLayout>              
              
             <%-- Policy violations summary --Rollup by target--%>
             <uix:rowLayout width="100%">
                <uix:header textBinding="HDR_MEMBER_TARGETS@policyBundle">                  
                    <uix:ref refID="POLICY_VIOLATIONS_SUMMARY_rollupByTarget"/>
                </uix:header>
              </uix:rowLayout>             
               </uix:header>
              </uix:rowLayout>
            </uix:tableLayout>            
          </uix:stackLayout>         
        </uix:header> 
      </uix:pageLayout>
      </uix:form>      
    </uix:body>
  </uix:document>
</uix:renderingContext>
