<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="ResourceBundle" class="oracle.sysman.eml.ecm.resources.TrackResourceBundle"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf"%>
    <uix:metaContainer>
      <uix:head titleBinding="searchPageTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
      <!-- This is the form definition for search page. -->
      <uix:form nameBinding="eml_ecm_sc_formName@servletRequest" method="get">
        <uix:pageLayout>
          <%@ include file="/oemGlobal.jspf"%>
          <!-- See if Search Types are correct, if not play an error message -->
          <uix:switcher childNameBinding="SearchTypeError@servletRequest">
            <uix:case name="true">
              <uix:header messageType="error">
                <uix:styledText styleClass="OraInstructionTextStrong" textBinding="ErrorMessage@servletRequest"/>
                <uix:rowLayout width="100%">
                  <uix:cellFormat hAlign="right">
                    <uix:pageButtonBar>
                      <uix:button textBinding="BTN_OK@ResourceBundle" destinationBinding="functionsTab@servletRequest"/>
                    </uix:pageButtonBar>
                  </uix:cellFormat>
                </uix:rowLayout>
								</uix:header>
        </uix:case>
        <uix:default>
              <!-- Get Page Title from Default Bean at run-time since this is single Search Page.-->
              <uix:header textBinding="searchPageHeader@defaultBean@servletRequest">
                <!-- if there is an exception this should be used to show up the errors and exceptions -->
                <oem:messageBox messageTypeBinding="messageType@servletRequest" titleTextKey="titleText" 
																mainTextKey="mainText" errorTableBinding="errors@servletRequest"/>
                <!-- Include Sql button node from the Bean. this will check the rendering flags -->
                <uix:include nodeBinding="sqlButtonNode@defaultBean@servletRequest"/>
                <!-- Include Search Component Node from the Request.-->
                <uix:include nodeBinding="eml_ecm_sc_uiNode@servletRequest"/>
                <uix:stackLayout>
                  <!-- Include Save To File Button Node from the Bean. This would also check for flags to render.-->
                  <uix:include nodeBinding="saveButtonNode@defaultBean@servletRequest"/>
                  <!-- aragarwa -- adding Table UI Node from Bean. This is transparent to 
										Integrator UI Node Implementation vs. default Implementationi of framework. -->
                  <uix:include nodeBinding="resultTable@defaultBean@servletRequest"/>
                </uix:stackLayout>
              </uix:header>
            </uix:default>
          </uix:switcher>
        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
<!-- End of Search Page Framework JSP File. -->
