<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="sqlPageTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>


    <uix:body>

      
      <%--
        The form on this page does a POST request to the URL em/console/ecm/search/sqlSearch,
        which is controlled by oracle.sysman.eml.ecm.sql.SearchSqlPageController. The
        controller attempts to re-direct the user to ecm/sql/sqlQueryResultDestination,
        which is the URL from which the end user will see this JSP page. The
        SearchSqlPageController will attempt to put all of the parameters of the POST
        request, including the sql query and any table sorting or navigation data,
        on the redirection URL. However, if this URL is too long, the controller will
        instead store the query in an Inter-Page Message, and send the IP message
        ID instead of the query itself. 
        
        The controller for ecm/sql/sqlQuery* is oracle.sysman.eml.ecm.sql.SqlQueryControl.
        The controller looks for an IP message ID on the URL. If it finds one, it uses
        this ID to read the query out of the session. If the controller does not
        find an IP message ID, the it tries to read the query off the URL directly.
        SqlQueryControl is also responsible for handing all sorting and navigation
        events on the table.
        
        Example 1: Suppose the user enters a very small query and clicks Search.
        This small query will be posted to ecm/search/sqlSearch, and the controller
        will construct the URL 
        em/console/ecm/sql/sqlQueryResultDestination?event=doSQL&sqlQueryText=<query>
        and redirect the user to this URL. SqlQueryControl will see that this URL
        has no message ID, but that it does have a query, so it will execute the
        query from the URL.
        
        Example 2: The user enters a very large query. The controller SearchSqlPageController
        will attempt to construct the URL
        em/console/ecm/sql/sqlQueryResultDestination?event=doSQL&sqlQueryText=<query>
        But this URL is too long, since the query is too big. So instead the controller
        will redirect the user to
        em/console/ecm/sql/sqlQueryResultDestination?event=doSQL&ipMsgID=<id>
        SqlQueryControl will use the message ID to find the query from the session.
        
        The only way for both the message ID and the query text to be null is
        if the user clicked Search without entering anything. In this case,
        nothing will happen
      --%>
      <uix:form name="loginForm" method="post" destination="/em/console/ecm/search/sqlSearch">

        <uix:formValue name="pageName" value="/ecm/sql/sqlQueryResultDestination"/>

        <uix:pageLayout
            titleBinding="HDR_SQLSEARCH@searchResourceBundle@servletRequest">

        <%@ include file="/oemGlobal.jspf" %>

          <oem:messageBox messageTypeBinding="messageType@servletRequest"
              titleTextKey="titleText" mainTextKey="mainText"
              errorTableBinding="errors@servletRequest"/>

          <uix:stackLayout>
              <%--- Page Refreshed MMM d, yyyy h:mm:ss a Text ---%>
               <uix:rowLayout hAlign="right">
                <uix:cellFormat>
                    <uix:styledText
                      styleClass="OraTipText"
                      textBinding="PAGE_REFRESHED_TIME@sdkbundle@servletRequest"/>
												<uix:spacer width="5"/>
												<uix:styledText
                      styleClass="OraTipLabel"
                      textBinding="refreshedAt@defaultBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>

            <uix:header
                textBinding="HDR_SQLQUERY@searchResourceBundle@servletRequest">

              <uix:tableLayout width="80%">

                <uix:rowLayout hAlign="left">
                  <uix:textInput name="sqlQueryText"
                      shortDescBinding="SHORTDESC_SQLQUERY@searchResourceBundle@servletRequest"      
                      textBinding="sqlQueryText@defaultBean@servletRequest"
                      rowsBinding="textRows@defaultBean@servletRequest"
                      columnsBinding="textColumns@defaultBean@servletRequest"
                      styleClass="OraFieldText"
                      wrap="soft"/>
                </uix:rowLayout>

                <uix:rowLayout hAlign="right">
                  <uix:submitButton name="event" value="doSql"
                      textBinding="BTN_SEARCH@searchResourceBundle@servletRequest"/>
                </uix:rowLayout>

              </uix:tableLayout>

            </uix:header>

            <uix:header
                textBinding="HDR_RESULTS@searchResourceBundle@servletRequest">

              <uix:tableLayout width="100%">

                <uix:rowLayout hAlign="right">
                  <uix:cellFormat>
                    <uix:button
                        textBinding="BTN_SAVETOFILE@searchResourceBundle@servletRequest"
                        destinationBinding="exportSearch@defaultBean@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:spacer height="5"/>
                </uix:rowLayout>

                <oem:table name="sqlQueryResult" width="100%"
                    blockSize="25"
                    formSubmitted="true"
                    alternateTextBinding="ALT_NODATA@searchResourceBundle@servletRequest"
                    summaryBinding="TBLSUM_RESULTSTABLE@searchResourceBundle@servletRequest"
                    dataSourceProp="sqlQueryResult"
		    showAll="yes"/>

              </uix:tableLayout>

            </uix:header>

          </uix:stackLayout>
        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
<%------------------------------  End of File  -------------------------------%>
