<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head title="Reference Config test page"/>
    </uix:metaContainer>
    <uix:body>
      <uix:pageLayout title="Reference Config test page">

          <uix:pageButtons>
            <uix:pageButtonBar>
             </uix:pageButtonBar>
          </uix:pageButtons>

          <uix:pageStatus>
            <uix:styledText styleClass="OraInstructionText" 
                            textBinding="INSTR_SEARCH@jspBundle" /> 
          </uix:pageStatus>

          <%@ include file="/oemGlobal.jspf" %>

          <oem:messageBox messageType="error"
              titleTextKey="titleText" mainTextKey="mainText"
              errorTableBinding="errors@servletRequest"/>

      <uix:form name="rcForm" method="post">                      
       <uix:messageStyledText prompt="rc list:"
         textBinding="rcNameList@servletRequest"
         labeledNodeId="availableId" />
       <uix:spacer height="5"/>
       <uix:messageTextInput name="rcName" prompt="rc name"
                      textBinding="rcName@servletRequest"/>
       <uix:messageTextInput name="rcXml" prompt="rc xml"
                      rows="20"
                      columns="80"
                      textBinding="rcXmlContent@servletRequest"/>
       <uix:spacer height="5"/>

       <uix:submitButton name="event" value="saveRc"
                      text="save"/>
       <uix:spacer width="5"/>
       <uix:submitButton name="event" value="getRc"
                      text="get"/>
       <uix:spacer width="5"/>
       <uix:submitButton name="event" value="evaluateRc"
                      text="evaluate"/>
       <uix:messageTextInput name="rcTargetName" prompt="target name"
                      textBinding="rcTargetName@servletRequest"/>

       <uix:spacer height="20"/>
<%--       <uix:messageStyledText prompt="status:"
         textBinding="rcStatus@servletRequest"
         labeledNodeId="statusId"  styleClass="OraDataText" /> --%>
       <uix:messageTextInput name="status" prompt="status:"
                      rows="10"
                      columns="80"
                      textBinding="rcStatus@servletRequest"
                      readOnly="true"
                      />
      </uix:form>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
