<%--
 * Copyright (c) 2003, Oracle Corporation.  All rights reserved.  
 *
 * NAME
 *   multiHostsComparisonSummary.jsp
 *
 * NOTES
 *   result page of multiple hosts comparison job.
 *
 * MODIFIED
 *    awarkar    11/13/03 - Bug Fix For Issue#3250371 
 *    rmenon     06/10/03 - rmenon_1_to_n_and_1_to_1_checkin
 *    rmenon   06/09/2003 - Creation
--%>


<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:stackLayout>
  <uix:contents>
    <uix:header textBinding="pageHeader@multiHostsComparisonSummaryBean@servletRequest" >
      <uix:spacer height="5" />
        <uix:rowLayout width="100%">
          <uix:contents>
            <uix:cellFormat hAlign="left" vAlign="top" width="60%">
              <uix:contents>
                <uix:rowLayout  styleClass="OraInstructionText">
                  <uix:labeledFieldLayout labelWidth="0" fieldWidth="0">
                    <uix:contents>
                      <uix:styledText 
                        textBinding="comparedHostNameLabel@multiHostsComparisonSummaryBean@servletRequest" />
                    </uix:contents>
                    <uix:contents>
                      <uix:styledText styleClass="OraInstructionTextStrong"
                        textBinding="comparedHostName@multiHostsComparisonSummaryBean@servletRequest" />
                    </uix:contents>
                  </uix:labeledFieldLayout>
                </uix:rowLayout  styleClass="OraInstructionText">
              </uix:contents>
            </uix:cellFormat>
          </uix:contents>
        </uix:rowLayout>
      </uix:header>
      <uix:spacer height="5" />
      <uix:tableLayout width="80%">
        <uix:contents>
          <uix:rowLayout hAlign="right">
            <uix:contents>
              <uix:table name="multiHostsComparisonSummaryTable"
                tableDataBinding="rows@multiHostsComparisonSummaryInfo@multiHostsComparisonSummaryBean@servletRequest"
                columnHeaderDataBinding="multiHostsComparisonSummaryColumnHeaders@multiHostsComparisonSummaryBean@servletRequest"
                blockSizeBinding="size@rows@multiHostsComparisonSummaryInfo@multiHostsComparisonSummaryBean@servletRequest"
                maxValueBinding="max@rows@multiHostsComparisonSummaryInfo@multiHostsComparisonSummaryBean@servletRequest"
                valueBinding="start@rows@multiHostsComparisonSummaryInfo@multiHostsComparisonSummaryBean@servletRequest"
                minValue="1"
                width="100%"
                alternateTextBinding="NO_DIFFERENCES_FOUND@TrackResourceBundle"
                formSubmitted="true" >
                       
                <uix:tableFormat tableBanding="rowBanding"/>
                       
                <uix:columnHeaderStamp>
                  <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
                </uix:columnHeaderStamp>
          
                <uix:contents>
                  <uix:link textBinding="result"
                    destinationBinding="resultURL"/>
                  <uix:styledText textBinding="hostName"/>
                  <uix:link textBinding="hwResult"
                    destinationBinding="hwResultURL"/>
                  <uix:link textBinding="osResult"
                    destinationBinding="osResultURL"/>
                  <uix:link textBinding="oracleResult"
                    destinationBinding="oracleResultURL"/>
                  <uix:link textBinding="osRegisteredSwResult"
                    destinationBinding="osRegisteredSwResultURL"/>
                </uix:contents>
              </uix:table>
            </uix:contents>
          </uix:rowLayout>
        </uix:contents>
      </uix:tableLayout>
  </uix:contents>
</uix:stackLayout>
<uix:formValue name="jobType" value="HostComparison"/>
