<%--
  -- Page:        missingConfig.jsp
  -- Controller:  oracle.sysman.eml.ecm.track.MissingConfigController
  --
  --  MODIFIED    (MM/DD/YY)  
  --   niramach    06/30/05 - Showall support for oem table. 
  --   niramach    05/10/05 - Add error message boxes. 
  --   niramach    05/04/05 - 
  --   kchiasso    04/15/05 - set summary
  --   niramach    03/04/05 - Fix bug 3240546 
  --   niramach    01/12/05 - Fixed the table width issue
  --   niramach    06/01/04 - enhancement
  --%>
  
<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <uix:form name="missingConfigForm" method="post">      
        <uix:formValue name="pageName" value="/ecm/track/missingConfig"/>
        <uix:pageLayout
            titleBinding="HDR_COLLECTION_STATUS@missingConfigBundle@servletRequest">

        <%@ include file="/oemGlobal.jspf" %>

        <uix:messages>        
        <uix:switcher childNameBinding="msgType@servletRequest" defaultCase="error">
         <uix:case name="confirmation">
          <oem:messageBox messageType="confirmation"
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText"
                          mainTextKey="mainText"/>
         </uix:case> 
        <uix:case name="error">
          <oem:messageBox messageType="error"
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText"
                          mainTextKey="mainText"/>
         </uix:case>
        </uix:switcher>
        </uix:messages>
          <uix:stackLayout>
            <uix:tableLayout cellSpacing="5" width="100%">

              <%--- Page Refreshed MMM d, yyyy h:mm:ss a Text ---%>
              <uix:rowLayout>
                <uix:cellFormat>
                  <uix:rowLayout hAlign="right">
                    <uix:styledText
                      styleClass="OraTipText"
                      textBinding="LBL_PAGE_REFRESHED_AT@missingConfigBundle@servletRequest"/>
                    <uix:spacer width="5"/>
                    <uix:styledText
                      styleClass="OraTipLabel"
                      textBinding="refreshedAt@missingConfigBean@servletRequest"/>
                  </uix:rowLayout>
                </uix:cellFormat>
              </uix:rowLayout>

              <%--- Configuration Collection Status Text ---%>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left">
                  <uix:styledText
                      styleClass="OraFieldText"
                      textBinding="MSG_COLLECTION_STATUS@missingConfigBundle@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              
              <%-- Added spacer fo better readability --%>
              <uix:rowLayout>
                <uix:spacer height="25"/>
              </uix:rowLayout>   
              <%--- Subtab layout ---%>
              <uix:subTabLayout>
                <uix:subTabs> 
                    <uix:subTabBar selectedIndex="0">
                        <uix:link textBinding="COLLECTION_ERROR_WARNING@missingConfigBundle@servletRequest"/>                            
                        <uix:link textBinding="MISSING_TARGET@missingConfigBundle@servletRequest"
                            destinationBinding="missingTargets@missingConfigBean@servletRequest"/>
                    </uix:subTabBar>
                </uix:subTabs>                   
            
                  <%--- Missing Configuration Information  ---%>
                  <uix:rowLayout width="100%">
                    <uix:cellFormat hAlign="left">                     
                        <uix:stackLayout>
                          <uix:tableLayout cellSpacing="5">
                          
                            <%--- Missing Configuration Information Text ---%>
                            <uix:rowLayout>
                              <uix:cellFormat hAlign="left">
                                  <uix:styledText
                                      styleClass="OraFieldText"
                                      textBinding="MSG_MISSING_CONFIGURATION@missingConfigBundle@servletRequest"/>
                              </uix:cellFormat>
                            </uix:rowLayout>  
                            
                            <uix:include nodeBinding="eml_ecm_sc_uiNode@servletRequest"/>                                                         
    
                            <%--- Refresh Multiple Hosts Button ---%>
                            <uix:tableLayout cellSpacing="1" width="99%">
                              <uix:rowLayout hAlign="right">
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:switcher childNameBinding="enableButtons@servletRequest">
                                      <uix:case name="true">
                                        <uix:submitButton
                                          textBinding="BTN_REFRESH_ALL_HOSTS@missingConfigBundle@servletRequest"
                                          name="event"
                                          value="refreshAll"
                                          formName="missingConfigForm"
                                        />
                                      </uix:case>
                                    </uix:switcher>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:rowLayout>
                            </uix:tableLayout>                          
    
                            <%--- Missing Configuration Information Table ---%>
                            <uix:rowLayout>
                              <uix:cellFormat hAlign="left">
                                <oem:table name="missingConfigResult" blockSize="25" width="98%"
                                    dataSourceProp="missingConfigResultUI"
                                    alternateTextBinding="MSG_NO_ITEMS_FOUND@missingConfigBundle@servletRequest"
                                    summaryBinding="SUMMARY_MISSINGCONFIGINFO@missingConfigBundle@servletRequest"
                                    showAll = "yes">
                                  <uix:tableSelection>
                                    <uix:singleSelection
                                        shortDescBinding="MSG_SELECT_ROW@missingConfigBundle@servletRequest">
                                      <uix:submitButton name="event" value="refresh"
                                          formName="missingConfigForm"
                                          textBinding="BTN_REFRESH_HOST_CONFIGURATION@missingConfigBundle@servletRequest"/>
                                    </uix:singleSelection>
                                  </uix:tableSelection>
                                </oem:table>
                              </uix:cellFormat>
                            </uix:rowLayout>
    
                          </uix:tableLayout>
                        </uix:stackLayout>                     
                    </uix:cellFormat>
                  </uix:rowLayout>
                 <uix:rowLayout>
                    <uix:spacer height="25"/>
                </uix:rowLayout>   

                </uix:subTabLayout>  
            </uix:tableLayout>

            <%--- Related Links Header ---%>
            <uix:rowLayout>
              <uix:cellFormat hAlign="left" width="40%">
                <uix:header
                    textBinding="HDR_RELATED_LINKS@missingConfigBundle@servletRequest">
                  <uix:stackLayout>
                    <uix:tableLayout cellSpacing="5">

                      <%--- System Errors Link ---%>
                      <uix:rowLayout>
                        <uix:link
                            destinationBinding="loaderErrors@missingConfigBean@servletRequest"
                            textBinding="LNK_LOADER_ERRORS@missingConfigBundle@servletRequest"/>
                      </uix:rowLayout>

                      <%--- Metric Errors Link ---%>
                      <uix:rowLayout>
                        <uix:link
                            destinationBinding="metricErrors@missingConfigBean@servletRequest"
                            textBinding="LNK_METRIC_ERRORS@missingConfigBundle@servletRequest"/>
                      </uix:rowLayout>

                    </uix:tableLayout>
                  </uix:stackLayout>
                </uix:header>
              </uix:cellFormat>
            </uix:rowLayout>

          </uix:stackLayout>
        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
<%------------------------------  End of File  -------------------------------%>
