<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head
          titleBinding="viewTitle@missingConfigBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>

      <uix:form name="missingConfigForm" method="get" destination="missingConfig">
        <uix:formValue name="pageName" value="/ecm/track/missingConfigView"/>
        <uix:pageLayout
            titleBinding="viewHeader@missingConfigBean@servletRequest">

        <%@ include file="/oemGlobal.jspf" %>

          <uix:stackLayout>
            <uix:tableLayout cellSpacing="5" width="100%">

              <%--- Page Refreshed MMM d, yyyy h:mm:ss a Text ---%>
              <uix:rowLayout>
                <uix:cellFormat>
                  <uix:rowLayout hAlign="right">
                    <uix:styledText
                      styleClass="OraTipText"
                      textBinding="LBL_PAGE_REFRESHED_AT@missingConfigBundle@servletRequest"/>
                    <uix:spacer width="5"/>
                    <uix:styledText
                      styleClass="OraTipLabel"
                      textBinding="refreshedAt@missingConfigBean@servletRequest"/>
                  </uix:rowLayout>
                </uix:cellFormat>
              </uix:rowLayout>

            </uix:tableLayout>

            <uix:tableLayout cellSpacing="5" width="100%">

              <%--- Host Label ---%>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true">
                  <uix:messagePrompt
                      promptBinding="LBL_NAME@missingConfigBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:styledText
                    styleClass="OraDataText"
                    textBinding="nameDetail@missingConfigBean@servletRequest"/>
              </uix:rowLayout>

              <%--- Problem Type Label ---%>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true">
                  <uix:messagePrompt
                      promptBinding="LBL_PROBLEM_TYPE@missingConfigBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:styledText
                    styleClass="OraDataText"
                    textBinding="problemTypeDetail@missingConfigBean@servletRequest"/>
              </uix:rowLayout>

              <%--- Time Label ---%>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true">
                  <uix:messagePrompt
                      promptBinding="LBL_TIME@missingConfigBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:styledText
                    styleClass="OraDataText"
                    textBinding="timeDetail@missingConfigBean@servletRequest"/>
              </uix:rowLayout>

              <%--- Message Label ---%>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true">
                  <uix:messagePrompt
                      promptBinding="LBL_MESSAGE@missingConfigBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:styledText
                    styleClass="OraDataText"
                    textBinding="messageDetail@missingConfigBean@servletRequest"/>
              </uix:rowLayout>

            </uix:tableLayout>
          </uix:stackLayout>

        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
<%------------------------------  End of File  -------------------------------%>
