<%--
  -- Page:        missingTarget.jsp
  -- Controller:  oracle.sysman.eml.ecm.track.MissingTargetController
  --
  --  MODIFIED    (MM/DD/YY)  
  --   niramach    06/30/05 - Showall support for oem table . 
  --   niramach    05/04/05 - 
  --   kchiasso    04/15/05 - set summary
  --   niramach    03/04/05 - Add tip for missing targets. 
  --   niramach    01/12/05 - Fixed the table width issue
  --   niramach    06/01/04 - enhancement
  --%>
  
<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>
    <uix:body>

        <uix:form name="missingTargetForm" method="post">       
        <uix:formValue name="pageName" value="/ecm/track/missingTarget"/>
        <uix:pageLayout
            titleBinding="HDR_COLLECTION_STATUS@missingTargetBundle@servletRequest">

        <%@ include file="/oemGlobal.jspf" %>

          <oem:messageBox messageType="error"
              titleTextKey="titleText" mainTextKey="mainText"
              errorTableBinding="errors@servletRequest"/>                      

          <uix:stackLayout>
            <uix:tableLayout width="100%">

              <%--- Page Refreshed MMM d, yyyy h:mm:ss a Text  ---%>
              <uix:rowLayout>
                <uix:cellFormat>
                  <uix:rowLayout hAlign="right">
                    <uix:styledText
                      styleClass="OraTipText"
                      textBinding="LBL_PAGE_REFRESHED_AT@missingTargetBundle@servletRequest"/>
                    <uix:spacer width="5"/>
                    <uix:styledText
                      styleClass="OraTipLabel"
                      textBinding="refreshedAt@missingTargetBean@servletRequest"/>
                  </uix:rowLayout>
                </uix:cellFormat>
              </uix:rowLayout>  
              
               <%--- Configuration Collection Status Text ---%>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left">
                  <uix:styledText
                      styleClass="OraFieldText"
                      textBinding="MSG_COLLECTION_STATUS@missingTargetBundle@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              
              <%-- Added spacer fo better readability --%>
              <uix:rowLayout>
                <uix:spacer height="25"/>
              </uix:rowLayout>   
              
              <%--- Subtab layout ---%>
              <uix:subTabLayout>
                <uix:subTabs> 
                    <uix:subTabBar selectedIndex="1">
                        <uix:link textBinding="COLLECTION_ERROR_WARNING@missingTargetBundle@servletRequest"
                            destinationBinding="collectionErrors@missingTargetBean@servletRequest"/>
                        <uix:link textBinding="HDR_MISSING_TARGET@missingTargetBundle@servletRequest"/>
                    </uix:subTabBar>
                </uix:subTabs>               
              
              <%--- Missing Targets Information ---%>
              <uix:rowLayout width="100%">
                <uix:cellFormat hAlign="left">               
                    <uix:stackLayout>
                      <uix:tableLayout cellSpacing="5" width="100%">

                        <%--- Missing Target Information Text ---%>
                        <uix:rowLayout>
                          <uix:cellFormat hAlign="left">
                              <uix:styledText
                                  styleClass="OraFieldText"
                                  textBinding="MSG1_MISSING_TARGET@missingTargetBundle@servletRequest"/>
                          </uix:cellFormat>
                        </uix:rowLayout>  
                        
                        <uix:rowLayout>
                        <uix:spacer height="5"/>
                        </uix:rowLayout>   
                        
                         <uix:rowLayout>
                          <uix:cellFormat hAlign="left">
                              <uix:styledText
                                  styleClass="OraFieldText"
                                  textBinding="MSG2_MISSING_TARGET@missingTargetBundle@servletRequest"/>
                          </uix:cellFormat>
                        </uix:rowLayout>     
                        
                         <uix:rowLayout>
                          <uix:cellFormat hAlign="left">
                              <uix:styledText
                                  styleClass="OraFieldText"
                                  textBinding="MSG3_MISSING_TARGET@missingTargetBundle@servletRequest"/>
                          </uix:cellFormat>
                        </uix:rowLayout>     
                        
                        <uix:rowLayout>
                          <uix:cellFormat hAlign="left">
                              <uix:styledText
                                  styleClass="OraFieldText"
                                  textBinding="MSG4_MISSING_TARGET@missingTargetBundle@servletRequest"/>
                          </uix:cellFormat>
                        </uix:rowLayout>
                        
                        <uix:include nodeBinding="eml_ecm_sc_uiNode@servletRequest"/>                                               
                       
                        <%--- Missing Target Information Table ---%>
                        <uix:rowLayout>
                          <uix:cellFormat hAlign="left">
                            <oem:table name="missingTargetResult" blockSize="25" width="100%"
                                dataSourceProp="missingTargetResultUI"
                                alternateTextBinding="MSG_NO_ITEMS_FOUND@missingTargetBundle@servletRequest"                          
                                summaryBinding="SUMMARY_MISSINGTARGETINFO@missingTargetBundle@servletRequest"
                                showAll = "yes">                              
                            </oem:table>
                          </uix:cellFormat>
                        </uix:rowLayout>
                      </uix:tableLayout>
                    </uix:stackLayout>               
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
              <uix:tip>
                <uix:styledText textBinding="MISSING_TARGET_TIP@missingTargetBundle@servletRequest"/>
              </uix:tip>
              </uix:rowLayout>
              
              <%-- Added spacer fo better readability --%>
              <uix:rowLayout>
                <uix:spacer height="25"/>
              </uix:rowLayout>   
            </uix:subTabLayout>  
            </uix:tableLayout>

            <%--- Related Links Header ---%>
            <uix:rowLayout>
              <uix:cellFormat hAlign="left" width="40%">
                <uix:header
                    textBinding="HDR_RELATED_LINKS@missingTargetBundle@servletRequest">
                  <uix:stackLayout>
                    <uix:tableLayout cellSpacing="5">

                      <%--- System Errors Link ---%>
                      <uix:rowLayout>
                        <uix:link
                            destinationBinding="loaderErrors@missingTargetBean@servletRequest"
                            textBinding="LNK_LOADER_ERRORS@missingTargetBundle@servletRequest"/>
                      </uix:rowLayout>

                      <%--- Metric Errors Link ---%>
                      <uix:rowLayout>
                        <uix:link
                            destinationBinding="metricErrors@missingTargetBean@servletRequest"
                            textBinding="LNK_METRIC_ERRORS@missingTargetBundle@servletRequest"/>
                      </uix:rowLayout>

                    </uix:tableLayout>
                  </uix:stackLayout>
                </uix:header>
              </uix:cellFormat>
            </uix:rowLayout>

          </uix:stackLayout>
        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
<%------------------------------  End of File  -------------------------------%>
