<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:metaContainer>
      <uix:head titleBinding="TITLE_SAVECONFIG@saveConfigBundle@servletRequest"/>
    </uix:metaContainer>

    <script>          
      function getNetscapeKey(keyStroke)
      {
         key = keyStroke.which;
         if(key == "13")
         {
           submitForm('saveConfigForm', 0, {'event':'ok'});
         }
      }
      
      function saveConfig() 
      {
        var isNav = (navigator.appName.indexOf("Netscape") != -1);
        
        if(isNav)
        {
          document.captureEvents(Event.KEYPRESS);
          document.onkeypress = getNetscapeKey;
        }
        else
        if ((window.event.which == 13) ||  
            (window.event.keyCode == 13))
        {
          submitForm('saveConfigForm',0,{'event':'ok'});
        }      
        return true;            
      }

      
      function doOnLoad()
      {
          document.saveConfigForm.descriptionName.focus();
          document.saveConfigForm.descriptionName.select();
      }
      
    </script>

    <uix:body onLoad="doOnLoad();">
      <uix:form name="saveConfigForm" method="GET">
      <uix:formValue name="pageName" value="/ecm/track/saveConfig"/>
        <uix:pageLayout
            titleBinding="HDR_SAVECONFIG@saveConfigBundle@servletRequest">

        <%@ include file="/oemGlobal.jspf" %>

          <oem:messageBox messageType="error"
              titleTextKey="titleText" 
              mainTextKey="mainText"
              errorTableBinding="errors@servletRequest"/>

          <uix:stackLayout>
            <uix:tableLayout cellSpacing="5"  width="100%">
              
              <%--- Save Config Help Text ---%>
              <uix:rowLayout>
                <uix:contents>
                  <uix:styledText
                      styleClass="OraInstructionText"
                      textBinding="MSG_SAVECONFIG@saveConfigBundle@servletRequest"/>
                </uix:contents>
              </uix:rowLayout>


              <uix:rowLayout>
                <uix:cellFormat height="20">
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout>
                  <uix:radioButton
                      name="saveUsage"
                      value="NEW_SAVETOREPOS"
                      selected="true"
                      selectedValueBinding="saveToRepos@saveConfigBundle@servletRequest"
                      textBinding="MSG_SAVECONFIG_TOREPOS@saveConfigBundle@servletRequest"/>                      
              </uix:rowLayout>


              <uix:rowLayout hAlign="left">
                <uix:contents>
              <uix:labeledFieldLayout labelWidth="1%">
                  <uix:messagePrompt 
                             labeledNodeId="forAlignmentLSID" 
                            prompt=""/>
                    <uix:styledText 
                        styleClass="OraFieldText"
                        textBinding="MSG_SAVECONFIG_TOREPOS1@saveConfigBundle@servletRequest"
			/>
              </uix:labeledFieldLayout>
                </uix:contents>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:contents>
              <uix:labeledFieldLayout labelWidth="20%">
                <uix:contents>
                  <uix:messagePrompt 
                             labeledNodeId="descriptionLID" 
                            promptBinding="MSG_DESCRIPTION@saveConfigBundle@servletRequest"/>
                  <uix:textInput id="descriptionID" name="descriptionName"
                              maximumLength="128" columns="50"  
                              onKeyDown="javascript:saveConfig();"
                              />
                </uix:contents>
              </uix:labeledFieldLayout>
                </uix:contents>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:contents>
              <uix:labeledFieldLayout labelWidth="20%">
                <uix:contents>
                  <uix:messagePrompt 
                             labeledNodeId="foralignmentID" 
                            prompt=""/>
                  <uix:checkBox id="compositeID" name="compositeConfigCheck"
                  renderedBinding="isComposite@saveConfigBean@servletRequest"
		  	checked="false"
			textBinding="saveCompositeCheckBoxString@saveConfigBean@servletRequest"
		  />
                </uix:contents>
              </uix:labeledFieldLayout>
                </uix:contents>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:cellFormat height="20">
                </uix:cellFormat>
              </uix:rowLayout>
                
              <uix:rowLayout>
                  <uix:radioButton
                      name="saveUsage"
                      value="NEW_SAVETOFILE"
                      selected="false"
                      selectedValueBinding="saveToRepos@saveConfigBundle@servletRequest"
                      textBinding="MSG_SAVECONFIG_TOFILE@saveConfigBundle@servletRequest"/>                      
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:contents>
              <uix:labeledFieldLayout labelWidth="1%">
                  <uix:messagePrompt 
                             labeledNodeId="forAlignmentLEID" 
                            prompt=""/>
                  <uix:styledText
                      styleClass="OraFieldText"
                      textBinding="MSG_SAVECONFIG_TOFILE1@saveConfigBundle@servletRequest"/>
              </uix:labeledFieldLayout>
                </uix:contents>
              </uix:rowLayout>

            </uix:tableLayout>

          </uix:stackLayout>
          
            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton name ="event" formName="saveConfigForm" 
                  textBinding="CANCEL@sdkBundle@servletRequest"
                  value="cancel"/>
                <uix:submitButton name ="event" formName="saveConfigForm" 
                  textBinding="OK@sdkBundle@servletRequest"
                  value="ok"/>
              </uix:pageButtonBar>
            </uix:pageButtons>
          
        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
