<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/enablePPR.jspf"%>
    <%@ include file="/oemTitle.jspf"%>
    <uix:metaContainer>
      <uix:head titleBinding="TITLE_SAVECONFIG@saveConfigBundle@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
      <uix:form name="saveConfigConfirmForm" destination="saveConfigConfirm" method="GET">
        <uix:formValue name="pageName" value="/ecm/track/saveConfigConfirm"/>
        <uix:pageLayout titleBinding="HDR_CONFIRMATION@saveConfigBundle@servletRequest">
          <%@ include file="/oemGlobal.jspf"%>
          <oem:messageBox messageType="error"
                          titleTextKey="titleText"
                          mainTextKey="mainText"
                          errorTableBinding="errors@servletRequest"/>
          <uix:stackLayout>
            <uix:contents>
              <uix:rowLayout width="100%">
                <uix:contents>
                  <uix:header messageType="confirmation" 
                              textBinding="confirmHideShowHeader@saveConfigConfirmBean@servletRequest" 
                              size="2">
                    <uix:hideShow id="savedDetails" 
                                  disclosedBinding="showConfirmDetails@saveConfigConfirmBean@servletRequest" 
                                  undisclosedTextBinding="TXT_SHOW_DETAILS@saveConfigBundle@servletRequest" 
                                  disclosedTextBinding="TXT_HIDE_DETAILS@saveConfigBundle@servletRequest" 
                                  partialRenderMode="self">
                      <uix:tableLayout width="100%">
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:table name="successSaveConfigTable" 
                                       id="successSaveConfigTable" width="100%" 
                                       partialRenderMode="self" showAll="yes" 
                                       valueBinding="successTableCurrentValue@saveConfigConfirmBean@servletRequest" 
                                       minValueBinding="successTableMinValue@saveConfigConfirmBean@servletRequest" 
                                       blockSizeBinding="successTableBlockSize@saveConfigConfirmBean@servletRequest" 
                                       maxValueBinding="successTableMaxValue@saveConfigConfirmBean@servletRequest" 
                                       alternateTextBinding="NO_CONFIGS_FOUND@saveConfigBundle@servletRequest" 
                                       tableDataBinding="successTableRows@saveConfigConfirmBean@servletRequest" 
                                       columnHeaderDataBinding="successTableColumnHeaders@saveConfigConfirmBean@servletRequest">
                              <uix:tableFormat tableBanding="rowBanding"/>
                              <uix:columnHeaderStamp>
                                <uix:sortableHeader textBinding="text" 
                                                    sortableBinding="sortable"/>
                              </uix:columnHeaderStamp>
                              <uix:styledText textBinding="targetName"/>
                              <uix:styledText textBinding="targetType"/>
                              <uix:styledText textBinding="collectedTime"/>
                            </uix:table>
                          </uix:contents>
                        </uix:rowLayout>
                      </uix:tableLayout>
                    </uix:hideShow>
                  </uix:header>
                </uix:contents>
              </uix:rowLayout>
              <uix:rowLayout renderedBinding="showErrorMesg@saveConfigConfirmBean@servletRequest" 
                             width="100%">
                <uix:contents>
                  <uix:header messageType="error" 
                              textBinding="errorHideShowHeader@saveConfigConfirmBean@servletRequest" 
                              size="2">
                    <uix:hideShow id="errorDetails" 
                                  disclosedBinding="showConfirmDetails@saveConfigConfirmBean@servletRequest" 
                                  undisclosedTextBinding="TXT_SHOW_DETAILS@saveConfigBundle@servletRequest" 
                                  disclosedTextBinding="TXT_HIDE_DETAILS@saveConfigBundle@servletRequest" 
                                  partialRenderMode="self">
                      <uix:tableLayout width="100%">
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:table name="errorSaveConfigTable" 
                                       id="errorSaveConfigTable" width="100%" 
                                       partialRenderMode="self" showAll="yes" 
                                       valueBinding="errorTableCurrentValue@saveConfigConfirmBean@servletRequest" 
                                       minValueBinding="errorTableMinValue@saveConfigConfirmBean@servletRequest" 
                                       blockSizeBinding="errorTableBlockSize@saveConfigConfirmBean@servletRequest" 
                                       maxValueBinding="errorTableMaxValue@saveConfigConfirmBean@servletRequest" 
                                       alternateTextBinding="NO_CONFIGS_FOUND@saveConfigBundle@servletRequest" 
                                       tableDataBinding="errorTableRows@saveConfigConfirmBean@servletRequest" 
                                       columnHeaderDataBinding="errorTableColumnHeaders@saveConfigConfirmBean@servletRequest">
                              <uix:tableFormat tableBanding="rowBanding"/>
                              <uix:columnHeaderStamp>
                                <uix:sortableHeader textBinding="text" 
                                                    sortableBinding="sortable"/>
                              </uix:columnHeaderStamp>
                              <uix:styledText textBinding="targetName"/>
                              <uix:styledText textBinding="targetType"/>
                              <uix:styledText textBinding="errorMessage"/>
                            </uix:table>
                          </uix:contents>
                        </uix:rowLayout>
                      </uix:tableLayout>
                    </uix:hideShow>
                  </uix:header>
                </uix:contents>
              </uix:rowLayout>
            </uix:contents>
          </uix:stackLayout>
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton name="event" 
                                formName="saveConfigConfirmForm" 
                                textBinding="OK@sdkBundle@servletRequest" 
                                value="ok"/>
            </uix:pageButtonBar>
          </uix:pageButtons>
        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
