<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="sdkUIMsg"
      class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <uix:form name="pageForm">
        <uix:pageLayout>
          <%@ include file="/oemGlobal.jspf" %>
          <uix:pageButtons>
            <uix:pageButtonBar
                renderedBinding="rendered@pageButtonBarData@pageData@servletRequest">
              <uix:contents childDataBinding="buttons@pageButtonBarData@pageData@servletRequest">
                <uix:submitButton
                    textBinding="text"
                    nameBinding="name"
                    disabledBinding="disabled"
                    valueBinding="value"/>
              </uix:contents>
            </uix:pageButtonBar>
          </uix:pageButtons>
          <%@ include file="/ecm/wizard/messages.jspf" %>
          <uix:tableLayout width="100%">
            <uix:rowLayout hAlign="right">
              <uix:cellFormat hAlign="right" vAlign="center">
                <oem:pageRefreshed/>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>
          <uix:header rendered="true"
              renderedBinding="rendered@pageData@servletRequest"
              textBinding="pageHeader@pageData@servletRequest">
            <uix:stackLayout>
              <uix:ref refID="pageContent"/>
            </uix:stackLayout>
          </uix:header>
        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

