<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:dataScope currentDataBinding="pageData@servletRequest">
    <uix:bundle name="sdkMsg"
        class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
    <uix:document>
      <%@ include file="/oemTitle.jspf" %>
      <uix:body>
        <uix:form nameBinding="formName@pageData@servletRequest" method="post">
          <uix:pageLayout titleBinding="pageHeader@pageData@servletRequest">
            <%@ include file="/oemGlobal.jspf" %>
            <uix:location>
              <uix:train valueBinding=
                  "value@pageData@servletRequest">
              <uix:contents childDataBinding=
                  "trainChildren@pageData@servletRequest">
                  <uix:link textBinding="text"/>
              </uix:contents>
              </uix:train>
            </uix:location>
            <uix:pageButtons>
              <uix:pageButtonBar>
              <uix:submitButton
                  textBinding="CANCEL@sdkMsg"
                  formNameBinding="formName@pageData@servletRequest"
                  name="event"
                  value="cancel"
                  renderedBinding="rendered@cancelButtonData@pageData@servletRequest"/>
              <uix:navigationBar
                  name="wizardNavigationBar"
                  formSubmitted="true"
                  maxValueBinding="maxValue@navData@pageData@servletRequest"
                  minValueBinding="minValue@navData@pageData@servletRequest"
                  valueBinding="value@pageData@servletRequest"/>
              <uix:submitButton
                  textBinding="FINISH@sdkMsg"
                  formNameBinding="formName@pageData@servletRequest"
                  name="event"
                  value="finish"
                  disabledBinding="disabled@finishButtonData@pageData@servletRequest"
                  renderedBinding="rendered@finishButtonData@pageData@servletRequest"/>
              </uix:pageButtonBar>
            </uix:pageButtons>
            <%@ include file="/ecm/wizard/messages.jspf" %>

              <uix:stackLayout>
                <uix:ref refID="pageContent"/>
              </uix:stackLayout>
          </uix:pageLayout>
        </uix:form>
      </uix:body>
    </uix:document>
  </uix:dataScope>
</uix:renderingContext>

