<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<jsp:useBean id="aboutApplication" scope="request"
             type="oracle.sysman.eml.app.about.AboutApplication"/>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
    <%@ include file="/em2go/em2goHrGlobal.jspf" %>
  <uix:document>

    <uix:body>
         <uix:styledText styleClass="OraHeaderSubSub" textBinding="header@servletRequest"/>
          <uix:tableLayout width="60%">
            <uix:rowLayout>
              <uix:styledText styleClass="OraInstructionText"
                              textBinding="productLabel@servletRequest"/>
              <uix:styledText styleClass="OraInstructionText"
                              textBinding="productVersionText@servletRequest"/>
              <uix:styledText styleClass="OraInstructionText"
                              textBinding="productionLevel@servletRequest"/>
            </uix:rowLayout>

          
            <uix:rowLayout>
              <uix:cellFormat>
                <uix:styledText styleClass="OraInstructionText"
                                textBinding="dbLabel@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat width="30%">
                <uix:stackLayout>
                  <uix:contents childDataBinding="supportedDBList@aboutApplication@servletRequest">
                    <uix:styledText styleClass="OraInstructionText"
                                    textBinding="dbVersionText"/>
                  </uix:contents>
                </uix:stackLayout>
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:styledText styleClass="OraInstructionText"
                                textBinding="dbProductionLevel@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:spacer height="5"/>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:cellFormat>
              <uix:styledText styleClass="OraInstructionText"
                              textBinding="iasLabel@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:stackLayout>
                  <uix:contents childDataBinding="supportedIASList@aboutApplication@servletRequest">
                    <uix:styledText styleClass="OraInstructionText"
                                    textBinding="iasVersionText"/>
                  </uix:contents>
                </uix:stackLayout>
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:styledText styleClass="OraInstructionText"
                                textBinding="productionLevel@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>

         

            <uix:rowLayout>
              <uix:cellFormat>
              <uix:styledText styleClass="OraInstructionText"
                              textBinding="accessLabel@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:stackLayout>
                <uix:styledText styleClass="OraInstructionText"
                                text="<%= aboutApplication.AccessibilityMode(renderingContext) %>"/>
                </uix:stackLayout>
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:cellFormat wrappingDisabled="true">
              <uix:link text="Oracle Database 10g Licensing Information"
                        destination="license"/>
              </uix:cellFormat>
            </uix:rowLayout>

          </uix:tableLayout>


          <uix:stackLayout>
     

            <uix:styledText styleClass="OraInstructionText"
                            textBinding="copyrightText@servletRequest"/>

     
            <uix:flowLayout>
                <uix:styledText styleClass="OraInstructionText"
                                textBinding="otnText@servletRequest"
                                renderedBinding="rendered@servletRequest"/>
                <uix:styledText styleClass="OraInstructionText"
                                text=" ("
                                renderedBinding="rendered@servletRequest"/>
                <uix:link text="http://otn.oracle.com/products/oem"
                          destination="http://otn.oracle.com/products/oem"
                          renderedBinding="rendered@servletRequest"/>
                <uix:styledText styleClass="OraInstructionText"
                                text=")."
                                renderedBinding="rendered@servletRequest"/>
            </uix:flowLayout>

           

            <uix:styledText styleClass="OraInstructionText"
                            textBinding="warningText@servletRequest"/>
          </uix:stackLayout>


    </uix:body>
  </uix:document>
</uix:renderingContext>
