<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">  
<oem:setURLEncoder id="renderingContext"/>
    <%@ include file="/em2go/em2goHrGlobal.jspf" %>
  <uix:document>


    <uix:body>


<uix:stackLayout>


  <uix:tableLayout width="100%">
    <uix:rowLayout>

      <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraHeaderSubSub" text="EM2Go Online help"/>
      </uix:cellFormat>

      <uix:cellFormat hAlign="left">
        <uix:spacer width="13"/>  
        <uix:styledText styleClass="OraPromptText" text="Release 4.1"/>
      </uix:cellFormat>

    </uix:rowLayout>
  </uix:tableLayout>




  <uix:tableLayout width="100%">
    <uix:rowLayout>

      <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraHeaderSubSub" text="EM2Go Features"/>
      </uix:cellFormat>


      <uix:cellFormat hAlign="right">
        <uix:link text="Previous" destination="/console/em2go/aboutEm2goHomePage"/>
        <uix:spacer width="5"/>  
        <uix:link text="Next" destination="/console/em2go/furthurInformation"/>
      </uix:cellFormat>

    </uix:rowLayout>
  </uix:tableLayout>


  <uix:tableLayout width="100%">

    <uix:rowLayout>
      <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraDataText" text="Introduction to Metrics"/>
      </uix:cellFormat>
    </uix:rowLayout>

    <uix:rowLayout>
      <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraPromptText" text="Metrics are units of measurement used to determine the health of a target. It is through the use of metrics and associated metric thresholds that Enterprise Manager sends out alerts notifying you of problems with the target."/>
      </uix:cellFormat>
    </uix:rowLayout>

    <uix:rowLayout>
      <uix:cellFormat hAlign="left">
        <uix:spacer height="6"/>  
      </uix:cellFormat>
    </uix:rowLayout>

    <uix:rowLayout>
      <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraPromptText" text="All Metrics provides an at a glance list of all the metrics being monitored for the target selected. An icon is displayed next to the metric to indicate the status i.e. if a metric threshold has been reached a severity icon will be displayed. Clicking on the metric will take you to further details including statistic information and metric severity history."/>
      </uix:cellFormat>
    </uix:rowLayout>


    <uix:rowLayout>
      <uix:cellFormat hAlign="left">
        <uix:spacer height="6"/>  
      </uix:cellFormat>
    </uix:rowLayout>








    <uix:rowLayout>
      <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraDataText" text="Execute SQL"/>
      </uix:cellFormat>
    </uix:rowLayout>

    <uix:rowLayout>
      <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraPromptText" text="EM2Go allows the administrator to run SQL queries against the database. 'Execute SQL' can be accessed from the database home page links list. To execute SQL follow the steps below: "/>
      </uix:cellFormat>
    </uix:rowLayout>

    <uix:rowLayout>
      <uix:cellFormat hAlign="left">
        <uix:spacer height="6"/>  
      </uix:cellFormat>
    </uix:rowLayout>

    <uix:rowLayout>
      <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraPromptText" text="1. Select Execute SQL from the drop down list. Click the Go button."/>
      </uix:cellFormat>
    </uix:rowLayout>

    <uix:rowLayout>
      <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraPromptText" text="2. Specify the database connection details as prompted."/>
      </uix:cellFormat>
    </uix:rowLayout>

    <uix:rowLayout>
      <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraPromptText" text="3. Type the SQL command in the empty box."/>
      </uix:cellFormat>
    </uix:rowLayout>

    <uix:rowLayout>
      <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraPromptText" text="4. Click the Execute button."/>
      </uix:cellFormat>
    </uix:rowLayout>

    <uix:rowLayout>
      <uix:cellFormat hAlign="left">
        <uix:spacer height="6"/>  
      </uix:cellFormat>
    </uix:rowLayout>


    <uix:rowLayout>
      <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraPromptText" text="The results will be displayed in a table below."/>
      </uix:cellFormat>
    </uix:rowLayout>






    <uix:rowLayout>
      <uix:cellFormat hAlign="left">
        <uix:spacer height="6"/>  
      </uix:cellFormat>
    </uix:rowLayout>








    <uix:rowLayout>
      <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraDataText" text="Top Sessions"/>
      </uix:cellFormat>
    </uix:rowLayout>

    <uix:rowLayout>
      <uix:cellFormat hAlign="left">
        <uix:spacer height="6"/>  
      </uix:cellFormat>
    </uix:rowLayout>

    <uix:rowLayout>
      <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraPromptText" text="EM2Go displays the most time and resource consuming sessions, waits, and SQL statements to help you pinpoint the most problematic areas on which to focus your database tuning efforts. You can use EM2Go to assist you in identifying performance bottlenecks within your system and database environment. TopSessions displays database sessions that are contributing most heavily to database activity. You can display various details for these sessions, including the SQL statements, and resource usage. You can obtain an overview of session activity by displaying the top sessions sorted by a statistic of your choosing. For any given session you can then drill down for more detail, or if you choose, you can terminate the session using the Kill Session option."/>
      </uix:cellFormat>
    </uix:rowLayout>





  </uix:tableLayout>







  <uix:tableLayout width="50%" hAlign="center">
    <uix:rowLayout>

      <uix:cellFormat hAlign="center">
        <uix:link text="Previous" destination="/console/em2go/aboutEm2goHomePage"/>
      </uix:cellFormat>

      <uix:cellFormat hAlign="center">
        <uix:link text="Next" destination="/console/em2go/furthurInformation"/>
      </uix:cellFormat>



    </uix:rowLayout>
  </uix:tableLayout>






</uix:stackLayout>

    </uix:body>
  </uix:document>
<%@ include file="/em2go/em2goThinFooter.jspf" %>    
</uix:renderingContext>

