<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<jsp:useBean id="toolCenterTable" scope="request"
             type="oracle.sysman.emx.ui.ToolCenterTableBean"/>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>  
  <uix:bundle name="mpBundle"
	      class="oracle.sysman.emx.ui.MPMsg"/>
  <uix:dataScope >
    <uix:document>
      <%@ include file="/enablePPR.jspf" %>
      <%@ include file="/oemTitle.jspf" %>
      <uix:body>
	<uix:form name="mpDelete">
	  <uix:pageLayout messageType="confirmation">
	    
	    <%@ include file="/oemGlobal.jspf" %>
	    <%@ include file="../health/header.jsp"%>
	    
	    <uix:pageButtons>
              <uix:switcher childNameBinding="deleteAction@servletRequest">
                <uix:case name="deleteMPs">
 	          <uix:pageButtonBar>
		    <uix:submitButton textBinding="NO@mpBundle" name="event"
                                      value="confirmCancelDelete"
  			              shortDescBinding="NO@mpBundle"/>
		    <uix:submitButton textBinding="YES@mpBundle" name="event" 
				      value="confirmDelete" 
				      shortDescBinding="DELETE_MPS@mpBundle"/>
 	          </uix:pageButtonBar>
		</uix:case>
		<uix:case name="deleteGroup">
 	          <uix:pageButtonBar>
		    <uix:submitButton textBinding="NO@mpBundle" name="event"
                                      value="confirmCancelDelete"
			              shortDescBinding="NO@mpBundle"/>
		    <uix:submitButton textBinding="YES@mpBundle" name="event" 
				      value="confirmDeleteGroup" 
				      shortDescBinding="DELETE_GROUP@mpBundle"/>
		    <uix:submitButton textBinding="YES_INCL@mpBundle" name="event" 
				      value="confirmDeleteGroupIncl" 
				      shortDescBinding="DELETE_GROUP_INCL@mpBundle"/>
	          </uix:pageButtonBar>
		</uix:case>
              </uix:switcher>
	    </uix:pageButtons>
	    
            <uix:stackLayout>
	      <uix:switcher childNameBinding="deleteAction@servletRequest">
		<uix:case name="deleteMPs">
		  <uix:styledText styleClass="OraDataText"
				  textBinding="CONFIRM_DELETE@mpBundle"/>
		</uix:case>
		<uix:case name="deleteGroup">
		  <uix:styledText styleClass="OraDataText"
				  textBinding="CONFIRM_DELETE_GROUP@mpBundle"/>
		</uix:case>
	      </uix:switcher>
              <uix:spacer height="10"/>
	      <uix:styledText styleClass="OraInstructionText" 
			      textBinding="selectedPlugins@servletRequest"/>
	    </uix:stackLayout>
	  </uix:pageLayout>
	</uix:form>
      </uix:body>
    </uix:document>
  </uix:dataScope>
</uix:renderingContext>

