<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<jsp:useBean id="toolCenterTable" scope="request"
             type="oracle.sysman.emx.ui.ToolCenterTableBean"/>
<jsp:useBean id="exportBean" scope="request"
             type="oracle.sysman.emx.ui.ExportBean"/>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>  
  <uix:bundle name="mpBundle"
              class="oracle.sysman.emx.ui.MPMsg"/>
  <uix:dataScope >
    <uix:document>
      <%@ include file="/enablePPR.jspf" %>
      <%@ include file="/oemTitle.jspf" %>
      <%@ include file="/oemNoscript.jspf" %>
      <uix:body>
        <uix:form name="mpDelete">
          <uix:pageLayout titleBinding="CONFIRM_EXPORT_TITLE@mpBundle">
            
            <%@ include file="/oemGlobal.jspf" %>
            <%@ include file="../health/header.jsp"%>
            
            <uix:pageButtons>
              <uix:switcher childNameBinding="exportAction@servletRequest">
                <uix:case name="export">
                  <uix:pageButtonBar>
                    <uix:submitButton textBinding="CANCEL@mpBundle" name="event"
                                      value="confirmCancelExport"
                                      shortDescBinding="NO@mpBundle"/>
                    <uix:submitButton textBinding="OK@mpBundle" name="event" 
                                      value="confirmExport" 
                                      shortDescBinding="EXPORT_MPS@mpBundle"/>
                  </uix:pageButtonBar>
                </uix:case>
                <uix:case name="showError">
                  <uix:pageButtonBar>
                    <uix:button textBinding="OK@mpBundle"
                                destination="home"/>
                  </uix:pageButtonBar>
                </uix:case>
              </uix:switcher>
            </uix:pageButtons>
            
            <uix:switcher childNameBinding="exportAction@servletRequest">
              <uix:case name="export">
                <uix:stackLayout>
                  <uix:styledText styleClass="OraDataText"
                                  textBinding="CONFIRM_EXPORT@mpBundle"/>
		  <uix:spacer height="10"/>
                  <uix:table id="exportTable"
                             summaryBinding="EXPORT_DATA_TABLE_SUMMARY@mpBundle"
                             alternateTextBinding="NO_MEMBERS@mpBundle"
                             formSubmitted="true"
                             width="100%"
                             tableDataBinding="tableData@exportBean@servletRequest">
                    <uix:tableFormat tableBanding="rowBanding"/>
                    <uix:contents>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:text textBinding="NAME@mpBundle"/>
                        </uix:columnHeader>
                        <uix:contents>
                          <uix:styledText textBinding="name"/>
                        </uix:contents>
                      </uix:column>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:text textBinding="VERSION@mpBundle"/>
                        </uix:columnHeader>
                        <uix:contents>
                          <uix:styledText textBinding="version"/>
                        </uix:contents>
                      </uix:column>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:text textBinding="EXPORT_TYPE@mpBundle"/>
                        </uix:columnHeader>
                        <uix:contents>
                          <uix:styledText textBinding="type"/>
                        </uix:contents>
                      </uix:column>
                    </uix:contents>
                  </uix:table>
                </uix:stackLayout>
              </uix:case>
              <uix:case name="showError">
                <uix:messageBox messageTypeBinding="error"
                                messageBinding="EXPORT_TIMEOUT@mpBundle"/>
              </uix:case>
            </uix:switcher>
          </uix:pageLayout>
        </uix:form>
      </uix:body>
    </uix:document>
  </uix:dataScope>
</uix:renderingContext>

