<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<jsp:useBean id="deployBean" scope="request"
             type="oracle.sysman.emx.ui.DeployBean"/>
<jsp:useBean id="errData" scope="request"
	     type="oracle.sysman.emx.ui.TCErrorBean"/>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="mpBundle"
              class="oracle.sysman.emx.ui.MPMsg"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:pageLayout titleBinding="header@deployBean@servletRequest">
        <%@ include file="/enablePPR.jspf" %>
        <%@ include file="/oemGlobal.jspf" %>
        <%@ include file="../health/header.jsp"%>

        <uix:pageButtons>
         <uix:pageButtonBar>
          <uix:submitButton textBinding="CANCEL@mpBundle" name="event"
                            value="cancel" formName="deployForm"
                            shortDescBinding="CANCEL@mpBundle"/>
          <uix:navigationBar minValue="1" maxValue="3" value="1"/>
         </uix:pageButtonBar>
        </uix:pageButtons>

        <uix:location>
         <uix:train id="tran" value="1">
          <uix:link textBinding="SELECT_TARGETS@mpBundle"/>
          <uix:link textBinding="DEPLOY_VERIFICATION@mpBundle"/>
          <uix:link textBinding="REVIEW@mpBundle"/>
         </uix:train>
        </uix:location>

        <uix:pageStatus>
	 <uix:switcher childNameBinding="isGroupDeploy@deployBean@servletRequest">
          <uix:case name="false">
           <uix:labeledFieldLayout columns="1" labelWidth="25%">
            <uix:messagePrompt promptBinding="NAME@mpBundle"/>
            <uix:styledText styleClass="OraDataText"
                            textBinding="type@deployBean@servletRequest"/>
            <uix:messagePrompt promptBinding="VERSION@mpBundle"/>
            <uix:styledText styleClass="OraDataText"
                            textBinding="version@deployBean@servletRequest"/>
           </uix:labeledFieldLayout>
          </uix:case>
          <uix:case name="true">
           <uix:labeledFieldLayout columns="1" labelWidth="25%">
            <uix:messagePrompt promptBinding="NAME@mpBundle"/>
            <uix:styledText styleClass="OraDataText"
                            textBinding="groupName@deployBean@servletRequest"/>
            <uix:messagePrompt promptBinding="APPLICABLE_GROUP_MEMBERS@mpBundle"/>
            <uix:styledText styleClass="OraDataText"
                            textBinding="applicableMembers@deployBean@servletRequest"/>
           </uix:labeledFieldLayout>
          </uix:case>
	 </uix:switcher>
        </uix:pageStatus>

	<uix:messages>
	 <uix:switcher childNameBinding="nodeValue@errData@servletRequest">
          <uix:case name="errNode">
           <uix:messageBox messageTypeBinding="messageType@errData@servletRequest"
                           messageBinding="errorMessage@errData@servletRequest"/>
          </uix:case>
         </uix:switcher>
	</uix:messages>

        <uix:spacer height="5"/>
        <uix:separator/>

        <uix:tableLayout width="100%">
	 <uix:rowLayout>
	  <uix:cellFormat hAlign="left" 
			  wrappingDisabled="false" vAlign="top">
           <uix:styledText styleClass="OraInstructionText"
                           textBinding="DEPLOY_SUMMARY@mpBundle"/>
	  </uix:cellFormat>
         </uix:rowLayout>
        </uix:tableLayout>

        <uix:form name="deployForm" method="POST">
         <uix:stackLayout>
          <uix:spacer height="10"/>				
          <oem:table name="deployTable"
		     summaryBinding="DEPLOY_TABLE_SUMMARY@mpBundle"
                     width="100%"
                     showAll="yes"
                     formSubmitted="true"
                     blockSizeBinding="blockSize@deployBean@servletRequest"
                     valueBinding="value@deployBean@servletRequest"
                     minValueBinding="minValue@deployBean@servletRequest"
                     maxValueBinding="maxValue@deployBean@servletRequest"
                     id="deployTable"
                     dataSourceProp="tableData"
                     beanKey="deployBean">
	   <uix:tableActions>
            <uix:pageButtonBar>
             <oem:targetSelection  textBinding="ADD_AGENTS@mpBundle"/>
            </uix:pageButtonBar>
           </uix:tableActions>
          </oem:table>

          <uix:tip>
            <uix:text textBinding="DEPLOY_VERIFICATION_TIP@mpBundle"/>
          </uix:tip>
         </uix:stackLayout>
        </uix:form>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
