<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<jsp:useBean id="deployReviewBean" scope="request"
             type="oracle.sysman.emx.ui.DeployBean"/>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="mpBundle"
              class="oracle.sysman.emx.ui.MPMsg"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:pageLayout titleBinding="header@deployReviewBean@servletRequest">
        <%@ include file="/enablePPR.jspf" %>
        <%@ include file="/oemGlobal.jspf" %>
        <%@ include file="../health/header.jsp"%>

        <uix:pageButtons>
         <uix:pageButtonBar>
          <uix:submitButton textBinding="CANCEL@mpBundle" name="event"
                            value="cancel" formName="reviewForm"
                            shortDescBinding="CANCEL@mpBundle"/>
          <uix:navigationBar minValue="1" maxValue="3" value="3"/>
          <uix:submitButton textBinding="FINISH@mpBundle" name="event"
                            value="doDeploy" formName="reviewForm"
                            shortDescBinding="DEPLOY_TITLE@mpBundle"/>

         </uix:pageButtonBar>
        </uix:pageButtons>

        <uix:location>
         <uix:train id="tran" value="3">
          <uix:link textBinding="SELECT_TARGETS@mpBundle"/>
          <uix:link textBinding="DEPLOY_VERIFICATION@mpBundle"/>
          <uix:link textBinding="REVIEW@mpBundle"/>
         </uix:train>
        </uix:location>
		
        <uix:pageStatus>
	 <uix:switcher childNameBinding="isGroupDeploy@deployReviewBean@servletRequest">
          <uix:case name="false">
           <uix:labeledFieldLayout columns="1" labelWidth="25%">
            <uix:messagePrompt promptBinding="NAME@mpBundle"/>
            <uix:styledText styleClass="OraDataText"
                            textBinding="type@deployReviewBean@servletRequest"/>
            <uix:messagePrompt promptBinding="VERSION@mpBundle"/>
            <uix:styledText styleClass="OraDataText"
                            textBinding="version@deployReviewBean@servletRequest"/>
           </uix:labeledFieldLayout>
          </uix:case>
          <uix:case name="true">
           <uix:labeledFieldLayout columns="1" labelWidth="25%">
            <uix:messagePrompt promptBinding="NAME@mpBundle"/>
            <uix:styledText styleClass="OraDataText"
                            textBinding="groupName@deployReviewBean@servletRequest"/>
            <uix:messagePrompt promptBinding="APPLICABLE_GROUP_MEMBERS@mpBundle"/>
            <uix:styledText styleClass="OraDataText"
                            textBinding="applicableMembers@deployReviewBean@servletRequest"/>
           </uix:labeledFieldLayout>
          </uix:case>
	 </uix:switcher>
        </uix:pageStatus>

	<uix:form name="reviewForm">
	</uix:form>

        <uix:spacer height="5"/>
        <uix:separator/>

        <uix:tableLayout width="100%">
	 <uix:rowLayout>
	  <uix:cellFormat hAlign="left" 
			  wrappingDisabled="false" vAlign="top">
           <uix:styledText styleClass="OraInstructionText"
                           textBinding="DEPLOY_REVIEW_SUMMARY@mpBundle"/>
	  </uix:cellFormat>
         </uix:rowLayout>
	 <uix:rowLayout>
	  <uix:cellFormat>
           <uix:spacer height="15"/>
	  </uix:cellFormat>
         </uix:rowLayout>
	 <uix:rowLayout>
	  <uix:cellFormat hAlign="left" 
			  wrappingDisabled="false" vAlign="top">
           <uix:styledText styleClass="OraInstructionText"
                           textBinding="DEPLOY_REVIEW_SUMMARY_2@mpBundle"/>
	  </uix:cellFormat>
         </uix:rowLayout>
	 <uix:rowLayout>
	  <uix:cellFormat>
           <uix:spacer height="15"/>
	  </uix:cellFormat>
         </uix:rowLayout>
	 <uix:rowLayout>
	  <uix:cellFormat hAlign="left" 
			  wrappingDisabled="false" vAlign="top">
           <uix:styledText styleClass="OraInstructionText"
                           textBinding="DEPLOY_REVIEW_SUMMARY_3@mpBundle"/>
	  </uix:cellFormat>
         </uix:rowLayout>
        </uix:tableLayout>

      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
