<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<jsp:useBean id="deployVerifyBean" scope="request"
             type="oracle.sysman.emx.ui.DeployVerificationBean"/>
<jsp:useBean id="errData" scope="request"
	     type="oracle.sysman.emx.ui.TCErrorBean"/>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="mpBundle"
              class="oracle.sysman.emx.ui.MPMsg"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:pageLayout titleBinding="header@deployVerifyBean@servletRequest">
        <%@ include file="/enablePPR.jspf" %>
        <%@ include file="/oemGlobal.jspf" %>
        <%@ include file="../health/header.jsp"%>
        <uix:header>

        <uix:pageButtons>
         <uix:pageButtonBar>
          <uix:submitButton textBinding="CANCEL@mpBundle" name="event"
                            value="cancel" formName="deployVerifyForm"
                            shortDescBinding="CANCEL@mpBundle"/>
          <uix:navigationBar minValue="1" maxValue="3" value="2" 
                             formName="deployVerifyForm"/>
         </uix:pageButtonBar>
        </uix:pageButtons>

        <uix:location>
         <uix:train id="tran" value="2">
          <uix:link textBinding="SELECT_TARGETS@mpBundle"/>
          <uix:link textBinding="DEPLOY_VERIFICATION@mpBundle"/>
          <uix:link textBinding="REVIEW@mpBundle"/>
         </uix:train>
        </uix:location>
		
        <uix:pageStatus>
	 <uix:switcher childNameBinding="isGroupDeploy@deployVerifyBean@servletRequest">
          <uix:case name="false">
           <uix:labeledFieldLayout columns="1" labelWidth="25%">
            <uix:messagePrompt promptBinding="NAME@mpBundle"/>
            <uix:styledText styleClass="OraDataText"
                            textBinding="type@deployVerifyBean@servletRequest"/>
            <uix:messagePrompt promptBinding="VERSION@mpBundle"/>
            <uix:styledText styleClass="OraDataText"
                            textBinding="version@deployVerifyBean@servletRequest"/>
           </uix:labeledFieldLayout>
          </uix:case>
          <uix:case name="true">
           <uix:labeledFieldLayout columns="1" labelWidth="25%">
            <uix:messagePrompt promptBinding="NAME@mpBundle"/>
            <uix:styledText styleClass="OraDataText"
                            textBinding="groupName@deployVerifyBean@servletRequest"/>
            <uix:messagePrompt promptBinding="APPLICABLE_GROUP_MEMBERS@mpBundle"/>
            <uix:styledText styleClass="OraDataText"
                            textBinding="applicableMembers@deployVerifyBean@servletRequest"/>
           </uix:labeledFieldLayout>
          </uix:case>
	 </uix:switcher>
         <uix:labeledFieldLayout columns="1" labelWidth="25%">
          <uix:messagePrompt promptBinding="NAME@mpBundle"/>
          <uix:styledText styleClass="OraDataText"
                          textBinding="type@deployVerifyBean@servletRequest"/>
          <uix:messagePrompt promptBinding="VERSION@mpBundle"/>
          <uix:styledText styleClass="OraDataText"
                          textBinding="version@deployVerifyBean@servletRequest"/>
         </uix:labeledFieldLayout>
        </uix:pageStatus>

	<uix:messages>
	 <uix:switcher childNameBinding="nodeValue@errData@servletRequest">
          <uix:case name="errNode">
           <uix:messageBox messageTypeBinding="messageType@errData@servletRequest"
                           messageBinding="errorMessage@errData@servletRequest"/>
          </uix:case>
         </uix:switcher>
	</uix:messages>

        <uix:spacer height="5"/>
        <uix:separator/>

        <uix:tableLayout width="100%">
	 <uix:rowLayout>
	  <uix:cellFormat hAlign="left" 
			  wrappingDisabled="false" vAlign="top">
           <uix:styledText styleClass="OraInstructionText"
                           textBinding="DEPLOY_VERIFY_SUMMARY@mpBundle"/>
	  </uix:cellFormat>
         </uix:rowLayout>
        </uix:tableLayout>

        <uix:spacer height="15"/>

        <uix:form name="deployVerifyForm">
	 <oem:table name="deployVerifyTable"
		    summaryBinding="DEPLOY_VERIFY_TABLE_SUMMARY@mpBundle"
	            width="100%"
                    showAll="yes"
		    formSubmitted="true"
                    blockSizeBinding="blockSize@deployVerifyBean@servletRequest"
                    valueBinding="value@deployVerifyBean@servletRequest"
                    minValueBinding="minValue@deployVerifyBean@servletRequest"
                    maxValueBinding="maxValue@deployVerifyBean@servletRequest"
		    id="deployVerifyTable"
		    dataSourceProp="tableData"
		    beanKey="deployVerifyBean">
	  <uix:tableSelection>
           <uix:multipleSelection selected="false"
                selectionBinding="selection@deployVerifyBean@servletRequest">
	    </uix:multipleSelection>
	  </uix:tableSelection>
	 </oem:table>
        </uix:form>

        </uix:header>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
