<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<jsp:useBean id="deployErrors" scope="request"
             type="oracle.sysman.emx.ui.ErrorsTableBean"/>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>  
  <uix:bundle name="mpBundle"
                  class="oracle.sysman.emx.ui.MPMsg"/>

  <uix:document>
   <%@ include file="/oemTitle.jspf" %>

   <uix:body>
    <uix:pageLayout titleBinding="header@deployErrors@servletRequest">
     <%@ include file="/enablePPR.jspf" %>
     <%@ include file="/oemGlobal.jspf" %>
     <%@ include file="../health/header.jsp"%>

     <uix:pageStatus>
      <uix:labeledFieldLayout columns="2" labelWidth="20%">
       <uix:messagePrompt promptBinding="NAME@mpBundle"/>
       <uix:styledText styleClass="OraDataText"
                       textBinding="type@deployErrors@servletRequest"/>
       <uix:messagePrompt promptBinding="AGENT@mpBundle"/>
       <uix:styledText styleClass="OraDataText"
                       textBinding="agent@deployErrors@servletRequest"/>
       <uix:messagePrompt promptBinding="VERSION@mpBundle"/>
       <uix:styledText styleClass="OraDataText"
                       textBinding="version@deployErrors@servletRequest"/>
      </uix:labeledFieldLayout>
     </uix:pageStatus>

     <uix:separator/>

    <uix:form name="depErrorsTable">
     <uix:stackLayout>

      <uix:styledText styleClass="OraInstructionText" 
                      textBinding="DEPLOY_ERRORS_SUMMARY@mpBundle"/>

      <uix:spacer height="10"/>
				
      <oem:table name="depErrorsTable"
		 summaryBinding="DEPLOY_ERRORS_TABLE_SUMMARY@mpBundle"
                 width="100%"
                 showAll="yes"
                 formSubmitted="true"
                 blockSizeBinding="blockSize@deployErrors@servletRequest"
                 valueBinding="value@deployErrors@servletRequest"
                 minValueBinding="minValue@deployErrors@servletRequest"
                 maxValueBinding="maxValue@deployErrors@servletRequest"
                 id="depErrorsTable"
                 dataSourceProp="tableData"
                 beanKey="deployErrors"/>

     </uix:stackLayout>
    </uix:form>
   </uix:pageLayout>
  </uix:body>
 </uix:document>
</uix:renderingContext>
