<%--
 * Copyright (c) 2001, 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *       deploymentPlan.jsp
 *
 *      NOTES
 *       Deployment Plan Page for Target Extensions
 *
 * MODIFIED    (MM/DD/YY)  VERSION
 *    rstobbe   06/28/05 - add summary tag to tables for OAC 
 *    rstobbe   05/12/05 - code review changes 
 *    caroy     02/24/05 - name cutover 
 *    caroy     02/16/05 - ui review comments 
 *    caroy     01/05/05 - 
 *    caroy     12/27/04 - ui fixes 
 *    caroy     12/14/04 - fix_summary text 
 *    caroy     09/03/04 - caroy_create_emx
 *
 *
--%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<jsp:useBean id="deployPlanBean" scope="request"
             type="oracle.sysman.emx.ui.DeployPlanTableBean"/>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="mpBundle"
              class="oracle.sysman.emx.ui.MPMsg"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:pageLayout titleBinding="header@deployPlanBean@servletRequest">
        <%@ include file="/enablePPR.jspf" %>
        <%@ include file="/oemGlobal.jspf" %>
        <%@ include file="../health/header.jsp"%>

        <uix:pageButtons>
         <uix:pageButtonBar>
          <uix:button textBinding="RETURN@mpBundle"
               destinationBinding="verifyLink@deployPlanBean@servletRequest"
               shortDescBinding="RETURN@mpBundle"/>
         </uix:pageButtonBar>
        </uix:pageButtons>

        <uix:location>
         <uix:train id="tran" value="2">
          <uix:link disabled="true" textBinding="SELECT_TARGETS@mpBundle"/>
          <uix:link textBinding="DEPLOY_VERIFICATION@mpBundle"/>
          <uix:link disabled="true" textBinding="REVIEW@mpBundle"/>
         </uix:train>
        </uix:location>
		
        <uix:pageStatus>
         <uix:labeledFieldLayout columns="2" labelWidth="20%">
          <uix:messagePrompt promptBinding="NAME@mpBundle"/>
          <uix:styledText styleClass="OraDataText"
                          textBinding="type@deployPlanBean@servletRequest"/>
          <uix:messagePrompt promptBinding="AGENT@mpBundle"/>
          <uix:styledText styleClass="OraDataText"
                          textBinding="agent@deployPlanBean@servletRequest"/>
          <uix:messagePrompt promptBinding="VERSION@mpBundle"/>
          <uix:styledText styleClass="OraDataText"
                          textBinding="version@deployPlanBean@servletRequest"/>
         </uix:labeledFieldLayout>
        </uix:pageStatus>

        <uix:separator/>

        <uix:form name="deployPlanTable">
         <uix:stackLayout>

          <uix:styledText styleClass="OraInstructionText" 
                          textBinding="DEPLOY_PLAN_SUMMARY@mpBundle"/>

          <uix:spacer height="10"/>
	  <oem:table name="deployPlanTable"
                     summaryBinding="DEPLOY_PLAN_TABLE_SUMMARY@mpBundle"
		     width="100%"
                     showAll="yes"
                     formSubmitted="true"
		     blockSizeBinding="blockSize@deployPlanBean@servletRequest"
		     valueBinding="value@deployPlanBean@servletRequest"
		     minValueBinding="minValue@deployPlanBean@servletRequest"
		     maxValueBinding="maxValue@deployPlanBean@servletRequest"
		     id="deployPlanTable"
		     dataSourceProp="tableData"
		     beanKey="deployPlanBean"/>

         </uix:stackLayout>
        </uix:form>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
