<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<jsp:useBean id="deployResults" scope="request"
             type="oracle.sysman.emx.ui.ResultsTableBean"/>
<jsp:useBean id="errData" scope="request"
             type="oracle.sysman.emx.ui.TCErrorBean"/>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>  
  <uix:bundle name="mpBundle"
	      class="oracle.sysman.emx.ui.MPMsg"/>
  <uix:bundle name="sdkUIMsg"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:pageLayout titleBinding="header@deployResults@servletRequest">
	<%@ include file="/enablePPR.jspf" %>
	<%@ include file="/oemGlobal.jspf" %>
	<%@ include file="../health/header.jsp"%>
	
	<uix:messages>
	  <uix:switcher childNameBinding="nodeValue@errData@servletRequest">
	    <uix:case name="errNode">
	      <uix:messageBox messageTypeBinding="messageType@errData@servletRequest"
			      messageBinding="errorMessage@errData@servletRequest"/>
	    </uix:case>
	  </uix:switcher>
	</uix:messages>
	<oem:messageBox messageType="error"
			errorTableBinding="errors@servletRequest"
			titleTextKey="titleText"
			mainTextKey="mainText"/>

	<uix:pageStatus>
	  <uix:tableLayout width="100%">
	    <uix:rowLayout>
	      <uix:cellFormat width="60%" hAlign="left" wrappingDisabled="false"
			      vAlign="top">
		<uix:styledText styleClass="OraInstructionText"
				textBinding="DEPLOY_RESULTS_SUMMARY@mpBundle"/>
	      </uix:cellFormat>
	      <uix:cellFormat>
		<spacer width="10"/>
	      </uix:cellFormat>
	      <uix:cellFormat hAlign="right" wrappingDisabled="true" vAlign="top">
		<uix:styledText styleClass="OraTipText"
				textBinding="PAGE_REFRESHED_TIME@sdkUIMsg"/>
		<uix:spacer width="4"/>
		<uix:styledText styleClass="OraTipLabel"
				textBinding="timestamp@deployResults@servletRequest"/>
	      </uix:cellFormat>
	    </uix:rowLayout>
	  </uix:tableLayout>
	</uix:pageStatus>

	<uix:form name="depResultsForm">
	  <uix:stackLayout>
	    <uix:include nodeBinding="eml_ecm_sc_uiNode@servletRequest"/>
	    <uix:separator/>
	    <uix:styledText styleClass="OraTipText"
			    textBinding="tableTip@toolCenterTable@servletRequest"/>
	    <oem:table name="depResultsTable"
		       summaryBinding="DEPLOY_STATUS_TABLE_SUMMARY@mpBundle"
		       width="100%"
		       showAll="yes"
		       formSubmitted="true"
		       blockSizeBinding="blockSize@deployResults@servletRequest"
		       valueBinding="value@deployResults@servletRequest"
		       minValueBinding="minValue@deployResults@servletRequest"
		       maxValueBinding="maxValue@deployResults@servletRequest"
		       id="depResultsTable"
		       dataSourceProp="tableData"
		       beanKey="deployResults"/>
	  </uix:stackLayout>
	</uix:form>

      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
