<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<jsp:useBean id="detailsBean" scope="request"
             type="oracle.sysman.emx.ui.DetailsBean"/>
<jsp:useBean id="errData" scope="request"
	     type="oracle.sysman.emx.ui.TCErrorBean"/>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>  
  <uix:bundle name="mpBundle"
	      class="oracle.sysman.emx.ui.MPMsg"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/oemNoscript.jspf" %>
    <uix:body>
      <uix:pageLayout titleBinding="header@detailsBean@servletRequest">
	<%@ include file="/enablePPR.jspf" %>
	<%@ include file="/oemGlobal.jspf" %>
        <%@ include file="../health/header.jsp"%>

	<uix:messages>
	  <uix:stackLayout>
	    <uix:switcher childNameBinding="nodeValue@errData@servletRequest">
	      <uix:case name="errNode">
		<uix:messageBox messageTypeBinding="messageType@errData@servletRequest"
				messageBinding="errorMessage@errData@servletRequest"/>
	      </uix:case>
	    </uix:switcher>
	  </uix:stackLayout>
	</uix:messages>
	
	<uix:pageStatus>
	  <uix:tableLayout width="100%">
	    <uix:rowLayout>
	      <uix:cellFormat width="60%" hAlign="left" 
			      wrappingDisabled="false" vAlign="top">
                <uix:switcher childNameBinding="isGroup@detailsBean@servletRequest">
                  <uix:case name="true">
                    <uix:styledText styleClass="OraInstructionText"
			            textBinding="GROUP_DETAILS_SUMMARY@mpBundle"/>
                  </uix:case>
                  <uix:case name="false">
                    <uix:styledText styleClass="OraInstructionText"
			            textBinding="DETAILS_SUMMARY@mpBundle"/>
                  </uix:case>
                </uix:switcher>
	      </uix:cellFormat>
	    </uix:rowLayout>
	  </uix:tableLayout>
	</uix:pageStatus>
	
	<uix:pageButtons>
	  <uix:switcher childNameBinding="showDetails@detailsBean@servletRequest">
	    <uix:case name="no">
	      <uix:pageButtonBar>
		<uix:button textBinding="CANCEL@mpBundle" destination="home"
                            shortDescBinding="CANCEL@mpBundle"/>
	      </uix:pageButtonBar>
	    </uix:case>
	    <uix:case name="yes">
	      <uix:pageButtonBar>
		<uix:button textBinding="DEPLOY@mpBundle"
			    destinationBinding="deployUrl@detailsBean@servletRequest"
                            shortDescBinding="DEPLOY_TITLE@mpBundle"/>
		<uix:button textBinding="UNDEPLOY@mpBundle"
			    destinationBinding="undeployUrl@detailsBean@servletRequest"
                            shortDescBinding="UNDEPLOY_TITLE@mpBundle"/>
		<uix:submitButton textBinding="EXPORT@mpBundle"
				  name="event"
				  value="export"
				  formName="detailsForm"
                                  shortDescBinding="EXPORT_MP@mpBundle"/>
		<uix:switcher childNameBinding="isGroup@detailsBean@servletRequest">
		  <uix:case name="false">
		    <uix:submitButton textBinding="DELETE@mpBundle"
				      name="event"
				      value="delete"
				      formName="detailsForm"
				      shortDescBinding="DELETE_MP@mpBundle"/>
		  </uix:case>
		</uix:switcher>
	      </uix:pageButtonBar>
	    </uix:case>
	  </uix:switcher>
	</uix:pageButtons>
	
	<uix:form name="detailsForm">
	</uix:form>
	<uix:switcher childNameBinding="isGroup@detailsBean@servletRequest">
	  <uix:case name="true">
	    <uix:tableLayout>
	      <uix:rowLayout>
		<uix:cellFormat width="100%">
		  <uix:spacer height="10"/>
		  <uix:labeledFieldLayout width="100%"
					  labelWidth="30%"
					  fieldWidth="70%">
		    <uix:styledText styleClass="OraFieldText"
				    textBinding="DESCRIPTION@mpBundle"/>
		    <uix:styledText styleClass="OraDataText"
				    textBinding="groupDescription@detailsBean@servletRequest"/>
                  </uix:labeledFieldLayout>
                  <uix:spacer height="10"/>
		  <uix:header textBinding="MEMBERS@mpBundle"/>
                  <uix:table id="memberTable"
                             summaryBinding="MEMBERS@mpBundle"
                             alternateTextBinding="NO_MEMBERS@mpBundle"
                             formSubmitted="true"
                             width="100%"
                             tableDataBinding="tableData@detailsBean@servletRequest">
                    <uix:tableFormat tableBanding="rowBanding"/>
                    <uix:contents>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:text textBinding="NAME@mpBundle"/>
                        </uix:columnHeader>
                        <uix:contents>
                          <uix:styledText textBinding="mpType"/>
                        </uix:contents>
                      </uix:column>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:text textBinding="VERSION@mpBundle"/>
                        </uix:columnHeader>
                        <uix:contents>
                          <uix:styledText textBinding="version"/>
                        </uix:contents>
                      </uix:column>
                    </uix:contents>
                  </uix:table>
		</uix:cellFormat>
	      </uix:rowLayout>
	    </uix:tableLayout>
          </uix:case>
	  <uix:case name="false">
	    <uix:switcher childNameBinding="showDetails@detailsBean@servletRequest">
	      <uix:case name="yes">
		<uix:tableLayout>
		  <uix:rowLayout>
		    <uix:cellFormat width="100%">
		      <uix:labeledFieldLayout width="100%"
					      labelWidth="30%"
					      fieldWidth="70%">
			<uix:styledText styleClass="OraFieldText"
					textBinding="VERSION@mpBundle"/>
			<uix:styledText styleClass="OraDataText"
					textBinding="version@detailsBean@servletRequest"/>
			<uix:styledText styleClass="OraFieldText"
					textBinding="DESCRIPTION@mpBundle"/>
			<uix:styledText styleClass="OraDataText"
					textBinding="description@detailsBean@servletRequest"/>
			<uix:styledText styleClass="OraFieldText"
					textBinding="DEPLOY_REQS@mpBundle"/>
			<uix:styledText styleClass="OraDataText"
					textBinding="deploymentRequirements@detailsBean@servletRequest"/>
		      </uix:labeledFieldLayout>
		    </uix:cellFormat>
		  </uix:rowLayout>
		  <uix:rowLayout width="100%">
		    <uix:cellFormat width="50%">
		      <uix:header textBinding="DEPLOYMENTS@mpBundle"
				  size="1">
			<uix:labeledFieldLayout width="100%"
						labelWidth="30%"
						fieldWidth="70%">
			  <uix:styledText styleClass="OraFieldText"
					  textBinding="MOST_RECENT@mpBundle"/>
			  <uix:styledText styleClass="OraDataText"
					  textBinding="mostRecentDeployment@detailsBean@servletRequest"/>
			  <uix:styledText styleClass="OraFieldText"
					  textBinding="SUCCESSFUL@mpBundle"/>
			  <uix:styledText styleClass="OraDataText"
					  textBinding="successfulDeployments@detailsBean@servletRequest"/>
			  <uix:styledText styleClass="OraFieldText"
					  textBinding="FAILED@mpBundle"/>
			  <uix:styledText styleClass="OraDataText"
					  textBinding="failedDeployments@detailsBean@servletRequest"/>
			  <uix:styledText styleClass="OraFieldText"
					  textBinding="RELATED_LINK@mpBundle"/>
			  <uix:styledText styleClass="OraLinkText"
					  textBinding="MP_DEPLOYMENTS@mpBundle"
					  destinationBinding="deployedHostsUrl@detailsBean@servletRequest"/>
			</uix:labeledFieldLayout>
		      </uix:header>
		    </uix:cellFormat>
		  </uix:rowLayout>
		</uix:tableLayout>
	      </uix:case>
	    </uix:switcher>
	  </uix:case>
	</uix:switcher>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>

