<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<jsp:useBean id="editBean" scope="request"
             type="oracle.sysman.emx.ui.GroupEditBean"/>
<jsp:useBean id="errData" scope="request"
	     type="oracle.sysman.emx.ui.TCErrorBean"/>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>  
  <uix:bundle name="mpBundle"
	      class="oracle.sysman.emx.ui.MPMsg"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/oemNoscript.jspf" %>
    <uix:body>
      <uix:pageLayout titleBinding="header@editBean@servletRequest">
	<%@ include file="/enablePPR.jspf" %>
	<%@ include file="/oemGlobal.jspf" %>
        <%@ include file="../health/header.jsp"%>

	<uix:messages>
	  <uix:stackLayout>
	    <uix:switcher childNameBinding="nodeValue@errData@servletRequest">
	      <uix:case name="errNode">
		<uix:messageBox messageTypeBinding="messageType@errData@servletRequest"
				messageBinding="errorMessage@errData@servletRequest"/>
	      </uix:case>
	    </uix:switcher>
	  </uix:stackLayout>
	</uix:messages>

	<uix:pageStatus>
	  <uix:tableLayout width="100%">
	    <uix:rowLayout>
	      <uix:cellFormat width="60%" hAlign="left" 
			      wrappingDisabled="false" vAlign="top">
		<uix:styledText styleClass="OraInstructionText"
				textBinding="GROUP_EDIT_SUMMARY@mpBundle"/>
	      </uix:cellFormat>
	    </uix:rowLayout>
	  </uix:tableLayout>
	</uix:pageStatus>

	<uix:pageButtons>
	  <uix:switcher childNameBinding="showGroup@editBean@servletRequest">
	    <uix:case name="no">
	      <uix:pageButtonBar>
		<uix:button textBinding="CANCEL@mpBundle" destination="home"
                            shortDescBinding="CANCEL_GE_TT@mpBundle"/>
	      </uix:pageButtonBar>
	    </uix:case>
	    <uix:case name="yes">
	      <uix:pageButtonBar>
		<uix:submitButton textBinding="CANCEL@mpBundle"
				  name="event"
				  value="cancel"
				  formName="groupEditForm"
                                  shortDescBinding="CANCEL_GE_TT@mpBundle"/>
		<uix:submitButton textBinding="OK@mpBundle"
				  name="event"
				  value="submit"
				  formName="groupEditForm"
                                  shortDescBinding="SUBMIT_GE_TT@mpBundle"/>
	      </uix:pageButtonBar>
	    </uix:case>
	  </uix:switcher>
	</uix:pageButtons>

	<uix:form name="groupEditForm">
	  <uix:switcher childNameBinding="showGroup@editBean@servletRequest">
	    <uix:case name="yes">
	      <uix:stackLayout>
		<uix:labeledFieldLayout width="100%"
					labelWidth="30%"
					fieldWidth="70%">
		  <uix:messageTextInput name="groupName" required="uiOnly"
                                        promptBinding="NAME@mpBundle"
                                        textBinding="groupName@editBean@servletRequest"/>
                  <uix:messageTextInput promptBinding="DESCRIPTION@mpBundle"
                                        name="groupDesc"
                                        textBinding="groupDescription@editBean@servletRequest"/>
                </uix:labeledFieldLayout>
                <uix:spacer height="10"/>
                <uix:header textBinding="MEMBERS@mpBundle"/>
                <uix:table id="memberTable"
                           summaryBinding="MEMBERS@mpBundle"
                           alternateTextBinding="NO_MEMBERS@mpBundle"
                           formSubmitted="true"
                           width="100%"
                           tableDataBinding="tableData@editBean@servletRequest">
                  <uix:tableFormat tableBanding="rowBanding"/>
                  <uix:contents>
                    <uix:column>
                      <uix:columnHeader>
                        <uix:text textBinding="NAME@mpBundle"/>
                      </uix:columnHeader>
                      <uix:contents>
                        <uix:styledText textBinding="mpType"/>
                      </uix:contents>
                    </uix:column>
                    <uix:column>
                      <uix:columnHeader>
                        <uix:text textBinding="VERSION@mpBundle"/>
                      </uix:columnHeader>
                      <uix:contents>
			<uix:radioButton nameBinding="radioName"
		                         textBinding="anyVersion"
                                         selectedBinding="selAny"
                                         valueBinding="anyValue"
                                         disabled="false"/>
			<uix:radioButton nameBinding="radioName"
		                         textBinding="version"
                                         selectedBinding="selVersion"
                                         valueBinding="value"
                                         disabled="false"/>
		      </uix:contents>
		    </uix:column>
		  </uix:contents>
		</uix:table>
	      </uix:stackLayout>
	    </uix:case>
	  </uix:switcher>
	</uix:form>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
